/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwz1.webgui.server.system;

import de.xam.dwz1.webgui.RenderTool;
import de.xam.dwz1.webgui.Router;
import de.xam.dwz1.webgui.server.system.SystemVelocitySupport;
import de.xam.dwzmodel.api.ConfParamsDwzModel;
import de.xam.dwzmodel.state.ModuleManager;
import de.xam.itemset.index.IItemSetManagedIndex;
import de.xam.memspace.Memspace;
import de.xam.mybase.model.api.IMyBase;
import de.xam.mybase.model.api.MyBaseComponent;
import de.xam.p13n.shared.Personalisation;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.IRestlessContext;

public class SystemResource {
    private static final Logger log = LoggerFactory.getLogger(SystemResource.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void index(IRestlessContext ctx, HttpServletResponse res, String command, String param) throws IOException {
        Personalisation p13n = ModuleManager.get().getPersonalisation();
        SystemVelocitySupport velocitySupport = new SystemVelocitySupport(this, p13n, ConfParamsDwzModel.MESSAGE_PACKAGES, ctx.getRequestIdentifier(), Router.get(), false, command, param);
        velocitySupport.setState("index");
        velocitySupport.setTitle("System");
        boolean success = false;
        Command cmd = Command.valueOf(command);
        ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.MyBase}).readLock().lock();
        try {
            IMyBase myBase = ModuleManager.get().getMyBase();
            if ("stats".equals(param)) {
                Memspace.dumpStats((Object)myBase, (double)0.5);
            } else if ("inf".equals(param)) {
                switch (cmd) {
                    case index: {
                        break;
                    }
                    case start: {
                        myBase.indexManager().setUpdating((IItemSetManagedIndex)myBase.infModel(), true);
                        myBase.indexManager().getIndexState((IItemSetManagedIndex)myBase.infModel()).ensureIsComputed(null);
                        success = true;
                        break;
                    }
                    case stop: {
                        myBase.indexManager().setUpdating((IItemSetManagedIndex)myBase.infModel(), false);
                        myBase.indexManager().getIndexState((IItemSetManagedIndex)myBase.infModel()).markAsDirty();
                        success = true;
                    }
                }
            }
            velocitySupport.setSuccess(success);
            RenderTool.renderPage(ctx, velocitySupport);
        }
        catch (Throwable throwable) {
            ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.MyBase}).readLock().unlock();
            throw throwable;
        }
        ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.MyBase}).readLock().unlock();
    }

    public static enum Command {
        index,
        stop,
        start;

    }
}

