/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwz1.webgui.server.shell;

import bsh.EvalError;
import bsh.Interpreter;
import com.calpano.common.server.util.ExceptionUtils;
import de.xam.dwz1.DWZ;
import de.xam.dwz1.webgui.DwzBaseVelocitySupport;
import de.xam.dwz1.webgui.Router;
import de.xam.dwz1.webgui.server.shell.ShellResource;
import de.xam.dwzmodel.state.ModuleManager;
import de.xam.itemset.IEntity;
import de.xam.itemset.IItem;
import de.xam.itemset.IProperty;
import de.xam.itemset.IStatement;
import de.xam.itemset.impl.ItemSets;
import de.xam.itemset.impl.Items;
import de.xam.kfacet.impl.wiki.WikiItem;
import de.xam.mybase.model.MyBases;
import de.xam.p13n.shared.Personalisation;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.xydra.base.XId;
import org.xydra.core.XX;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.sharedutils.ReflectionUtils;

public class ShellVelocitySupport
extends DwzBaseVelocitySupport {
    private static final Logger log = LoggerFactory.getLogger(ShellVelocitySupport.class);
    private boolean executed = false;
    private final String input;
    private Object resultObject;
    private final String script;
    private final ShellResource shellResource;
    private String strErr = "";
    private String strOut = "";

    public ShellVelocitySupport(ShellResource shellResource, Personalisation p13n, String[] messagePackages, String requestId, Router router, boolean interpretMarkdown, String input, String script) {
        super(p13n, messagePackages, requestId, "shell", "index", false);
        this.shellResource = shellResource;
        this.input = input;
        this.script = script;
    }

    private void execute() {
        if (this.executed) {
            return;
        }
        if (this.script == null) {
            return;
        }
        if (this.script.trim().length() == 0) {
            this.executed = true;
            return;
        }
        Interpreter in = new Interpreter();
        try {
            ByteArrayOutputStream baosErr = new ByteArrayOutputStream();
            PrintStream psErr = new PrintStream((OutputStream)baosErr, true, "UTF-8");
            ByteArrayOutputStream baosOut = new ByteArrayOutputStream();
            PrintStream psOut = new PrintStream((OutputStream)baosOut, true, "UTF-8");
            in.setErr(psErr);
            in.setOut(psOut);
            in.setShowResults(true);
            try {
                in.eval("import " + XX.class.getCanonicalName());
                in.eval("import " + XId.class.getCanonicalName());
                in.eval("import " + IEntity.class.getCanonicalName());
                in.eval("import " + IItem.class.getCanonicalName());
                in.eval("import " + IStatement.class.getCanonicalName());
                in.eval("import " + IProperty.class.getCanonicalName());
                in.eval("import " + Items.class.getCanonicalName());
                in.eval("import " + ItemSets.class.getCanonicalName());
                in.eval("import " + MyBases.class.getCanonicalName());
                in.eval("import " + WikiItem.class.getCanonicalName());
                in.set("MM", (Object)ModuleManager.get());
                in.set("DWZ", (Object)DWZ.get());
                in.set("mybase", (Object)ModuleManager.get().getMyBase());
                in.set("router", (Object)super.getRouter());
                in.set("input", (Object)this.input);
                this.resultObject = in.eval(this.script);
                this.strErr = baosErr.toString("UTF-8");
                psErr.close();
                this.strOut = baosOut.toString("UTF-8");
                psOut.close();
            }
            catch (EvalError e) {
                log.warn("error", (Throwable)e);
                this.strErr = this.strErr + "\nERROR: " + e.getMessage() + "\n";
                this.strErr = this.strErr + "Line " + e.getErrorLineNumber() + "\n";
                this.strErr = this.strErr + "Text " + e.getErrorText() + "\n";
                this.strErr = this.strErr + "Trace " + e.getScriptStackTrace() + "\n";
                this.strErr = this.strErr + "Causes:\n";
                for (Throwable t : e.getSuppressed()) {
                    this.strErr = this.strErr + t.toString() + "\n  " + ReflectionUtils.firstNLines((Throwable)t, (int)200);
                }
                log.warn("EvalError = " + ExceptionUtils.toHtmlStringWithStacktrace((Throwable)e));
                return;
            }
            catch (Throwable t) {
                log.warn("Throable = " + ExceptionUtils.toHtmlStringWithStacktrace((Throwable)t), t);
                throw t;
            }
            finally {
                this.executed = true;
            }
        }
        catch (UnsupportedEncodingException e1) {
            throw new RuntimeException(e1);
        }
    }

    public String getErrStream() {
        this.execute();
        return this.strErr;
    }

    public String getInput() {
        return this.input;
    }

    public String getOutStream() {
        this.execute();
        return this.strOut;
    }

    public Object getResult() {
        this.execute();
        return this.resultObject;
    }

    public String getScript() {
        return this.script;
    }

    public ShellResource getSemResource() {
        return this.shellResource;
    }

    public ShellResource getShellResource() {
        return this.shellResource;
    }

    public boolean isExecuted() {
        return this.executed;
    }
}

