/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwz1.webgui.server.query;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import de.xam.dwz1.webgui.DwzBaseVelocitySupport;
import de.xam.dwz1.webgui.server.query.TableQuery;
import de.xam.dwzmodel.api.ConfParamsDwzModel;
import de.xam.dwzmodel.state.ModuleManager;
import de.xam.itemset.IItemSet;
import de.xam.itemset.impl.Items;
import de.xam.mybase.model.MyBases;
import de.xam.mybase.model.api.IMyBase;
import de.xam.p13n.shared.Personalisation;
import de.xam.texthtml.text.TextTool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.xydra.base.XId;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.IRestlessContext;

public class TableVelocitySupport
extends DwzBaseVelocitySupport {
    private static final Logger log = LoggerFactory.getLogger(TableVelocitySupport.class);
    private final List<XId> subjects;
    private List<XId> predicates;

    public String getSubjects() {
        List<String> subjectNames = TableVelocitySupport.toDisplayStrings(this.getMyBase().itemSet(), this.subjects);
        return this.subjects == null ? "*" : Joiner.on((String)",").join(subjectNames);
    }

    private static List<String> toDisplayStrings(IItemSet itemSet, List<XId> idList) {
        assert (idList != null);
        ArrayList<String> stringList = new ArrayList<String>(idList.size());
        for (XId id : idList) {
            String s = Items.getDisplayString((IItemSet)itemSet, (XId)id);
            stringList.add(s);
        }
        return stringList;
    }

    public String getPredicates() {
        List<String> predicateNames = TableVelocitySupport.toDisplayStrings(this.getMyBase().itemSet(), this.predicates);
        return this.predicates == null ? "*" : Joiner.on((String)",").join(predicateNames);
    }

    public TableVelocitySupport(Personalisation p13n, String[] messagePackages, String requestId, String subjectNames, String predicateNames) {
        super(p13n, messagePackages, requestId, "query", "table", false);
        List subjectNameList = subjectNames == null ? Collections.EMPTY_LIST : Splitter.on((String)",").splitToList((CharSequence)subjectNames);
        this.subjects = new ArrayList<XId>(subjectNameList.size());
        for (String subjectName : subjectNameList) {
            XId subjectId = MyBases.getItemIdByName((IMyBase)ModuleManager.get().getMyBase(), (String)TextTool.trim((String)subjectName));
            if (subjectId == null) {
                log.warn("Subject Item '" + subjectName + "' not found");
                continue;
            }
            this.subjects.add(subjectId);
        }
        if (predicateNames.equals("*")) {
            Set usedPredicates = MyBases.getUsedRelationsAndProperties((IMyBase)ModuleManager.get().getMyBase(), this.subjects.iterator());
            this.predicates = new ArrayList<XId>(usedPredicates.size());
            this.predicates.addAll(usedPredicates);
        } else {
            List predicateNameList = Splitter.on((String)",").splitToList((CharSequence)predicateNames);
            this.predicates = new ArrayList<XId>(predicateNameList.size());
            for (String predicateName : predicateNameList) {
                XId id = MyBases.getItemIdByName((IMyBase)ModuleManager.get().getMyBase(), (String)TextTool.trim((String)predicateName));
                if (id == null) {
                    log.warn("Predicate Item '" + predicateName + "' not found");
                    continue;
                }
                this.predicates.add(id);
            }
        }
    }

    public TableQuery getTable() {
        IMyBase myBase = ModuleManager.get().getMyBase();
        TableQuery tq = new TableQuery(myBase.itemSet(), myBase.infModel(), this.subjects, this.predicates);
        return tq;
    }

    public String getQuery() {
        return "(" + this.getSubjects() + ")(" + this.getPredicates() + ")";
    }

    public static TableVelocitySupport create(IRestlessContext ctx, String subjects, String predicates) {
        Personalisation p13n = ModuleManager.get().getPersonalisation();
        TableVelocitySupport velocitySupport = new TableVelocitySupport(p13n, ConfParamsDwzModel.MESSAGE_PACKAGES, ctx.getRequestIdentifier(), subjects, predicates);
        return velocitySupport;
    }
}

