/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwz1.webgui.server.query;

import de.xam.dwz1.webgui.DwzBaseVelocitySupport;
import de.xam.dwz1.webgui.RenderTool;
import de.xam.dwz1.webgui.RestOutput;
import de.xam.dwz1.webgui.Router;
import de.xam.dwz1.webgui.server.query.AutocompleteResource;
import de.xam.dwz1.webgui.server.query.QueryVelocitySupport;
import de.xam.dwz1.webgui.server.query.SPOVelocitySupport;
import de.xam.dwz1.webgui.server.query.TableVelocitySupport;
import de.xam.dwzmodel.api.ConfParamsDwzModel;
import de.xam.dwzmodel.state.ModuleManager;
import de.xam.mybase.model.api.MyBaseComponent;
import de.xam.p13n.shared.Personalisation;
import de.xam.textsearch.Match;
import java.io.IOException;
import java.util.List;
import org.xydra.base.XId;
import org.xydra.restless.IRestlessContext;

public class QueryResource {
    public static final String COMMAND = "command";

    public static void queryItems(IRestlessContext ctx, String command, String query, String output, String optionalFilterName) throws IOException {
        if (command.equalsIgnoreCase(Command.autocomplete.name()) && output.equalsIgnoreCase(RestOutput.json.name())) {
            AutocompleteResource.autocomplete(ctx, query, 200, optionalFilterName);
            return;
        }
        QueryVelocitySupport velocitySupport = QueryVelocitySupport.create(ctx, query, "items_" + command);
        List<Match<XId>> results = velocitySupport.getResults();
        if (results.size() == 1) {
            XId resultId = (XId)results.get(0).getValue();
            ctx.getResponse().sendRedirect(Router.get().url_item(resultId));
            return;
        }
        RenderTool.renderPage(ctx, velocitySupport);
    }

    public static void queryItemsIndex(IRestlessContext ctx, String output) throws IOException {
        QueryVelocitySupport velocitySupport = QueryVelocitySupport.create(ctx, null, "items_index");
        RenderTool.renderPage(ctx, velocitySupport);
    }

    public static void autocompletePrefetch(IRestlessContext ctx, String optionalFilterName) throws IOException {
        AutocompleteResource.autocompletePrefetch(ctx, ctx.getResponse(), optionalFilterName);
    }

    public static void querySPOdo(IRestlessContext ctx, String s, String p, String o, String sName, String pName, String oName) throws IOException {
        ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.ItemSet}).readLock().lock();
        SPOVelocitySupport velocitySupport = SPOVelocitySupport.create(ctx, s, p, o, sName, pName, oName);
        velocitySupport.setTitle("Query " + velocitySupport.getQuery());
        RenderTool.renderPage(ctx, velocitySupport);
        ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.ItemSet}).readLock().unlock();
    }

    public static void queryTableDo(IRestlessContext ctx, String subjects, String predicates) throws IOException {
        ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.ItemSet, MyBaseComponent.InfModel}).readLock().lock();
        TableVelocitySupport velocitySupport = TableVelocitySupport.create(ctx, subjects, predicates);
        velocitySupport.setState("do");
        velocitySupport.setTitle("Table Query");
        RenderTool.renderPage(ctx, velocitySupport);
        ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.ItemSet, MyBaseComponent.InfModel}).readLock().unlock();
    }

    public static void queryTableIndex(IRestlessContext ctx) throws IOException {
        Personalisation p13n = ModuleManager.get().getPersonalisation();
        DwzBaseVelocitySupport velocitySupport = new DwzBaseVelocitySupport(p13n, ConfParamsDwzModel.MESSAGE_PACKAGES, ctx.getRequestIdentifier(), "query", "table", false);
        velocitySupport.setState("index");
        RenderTool.renderPage(ctx, velocitySupport);
    }

    public static void querySparql(IRestlessContext ctx) throws IOException {
        Personalisation p13n = ModuleManager.get().getPersonalisation();
        DwzBaseVelocitySupport velocitySupport = new DwzBaseVelocitySupport(p13n, ConfParamsDwzModel.MESSAGE_PACKAGES, ctx.getRequestIdentifier(), "query", "sparql", false);
        velocitySupport.setState("index");
        RenderTool.renderPage(ctx, velocitySupport);
    }

    public static enum Command {
        autocomplete,
        fulltext,
        subitems;

    }
}

