/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwz1.webgui.server.file;

import de.xam.dwz1.webgui.RenderTool;
import de.xam.dwz1.webgui.Router;
import de.xam.dwz1.webgui.server.file.FileVelocitySupport;
import de.xam.dwzmodel.api.ConfParamsDwzModel;
import de.xam.dwzmodel.api.FileUpload;
import de.xam.dwzmodel.state.FileManager;
import de.xam.dwzmodel.state.FileMeta;
import de.xam.dwzmodel.state.ModuleManager;
import de.xam.p13n.shared.Personalisation;
import de.xam.texthtml.text.CamelCase;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileUploadException;
import org.xydra.annotations.Template;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.IMultipartFormDataHandler;
import org.xydra.restless.IRestlessContext;
import org.xydra.restless.ProgressManager;
import org.xydra.restless.RestlessUtils;

public class FileResource {
    private static final Logger log = LoggerFactory.getLogger(FileResource.class);

    public void index(IRestlessContext ctx, HttpServletResponse res, String command, String filename, String format, String progressToken) throws IOException {
        Personalisation p13n = ModuleManager.get().getPersonalisation();
        FileVelocitySupport velocitySupport = new FileVelocitySupport(this, p13n, ConfParamsDwzModel.MESSAGE_PACKAGES, ctx.getRequestIdentifier(), Router.get(), false, command, filename);
        velocitySupport.setState("index");
        velocitySupport.setTitle("File " + CamelCase.convertTo__Word_Word_Word((String)command));
        boolean success = false;
        Command cmd = Command.valueOf(command);
        switch (cmd) {
            case open: {
                if (filename != null) {
                    log.info("Opening " + filename);
                    RenderTool.renderPage(ctx, velocitySupport);
                    IMultipartFormDataHandler.IProgressReporter pr = ProgressManager.createDefaultProgressReporter((String)progressToken);
                    try {
                        success = ModuleManager.get().getFiles().doOpen(filename, pr);
                    }
                    catch (Error | Exception e) {
                        ProgressManager.reportException((IMultipartFormDataHandler.IProgressReporter)pr, (Throwable)e);
                    }
                    return;
                }
                RenderTool.renderPage(ctx, velocitySupport);
                return;
            }
            case close: {
                ModuleManager.get().getFiles().doClose();
                res.sendRedirect(Router.get().url_guide("close"));
                break;
            }
            case copyTo: {
                FileManager.CopyResult copyResult = null;
                if (filename == null) {
                    velocitySupport.setState("index");
                } else {
                    long rev;
                    velocitySupport.setState("copy");
                    try {
                        rev = RestlessUtils.getUrlParameterAsLong((String)ctx.getRequest().getParameter("rev"));
                    }
                    catch (IllegalArgumentException e) {
                        rev = -30L;
                    }
                    log.info("Saving as (make a copy) from " + filename);
                    IMultipartFormDataHandler.IProgressReporter pr = ProgressManager.createDefaultProgressReporter((String)progressToken);
                    copyResult = ModuleManager.get().getFiles().doCopyTo(rev, filename, format, pr);
                }
                velocitySupport.setSuccess(copyResult != null);
                velocitySupport.copyResult = copyResult;
                RenderTool.renderPage(ctx, velocitySupport);
                return;
            }
            case createNew: {
                log.info("Create New");
                success = ModuleManager.get().getFiles().doCreateNew();
                velocitySupport.setSuccess(success);
                RenderTool.renderPage(ctx, velocitySupport);
                return;
            }
            case export: {
                if (filename != null && format != null) {
                    success = ModuleManager.get().getFiles().doExportTo(ctx, filename, format);
                    return;
                }
                velocitySupport.setSuccess(success);
                RenderTool.renderPage(ctx, velocitySupport);
                return;
            }
            case versions: {
                velocitySupport.setSuccess(success);
                RenderTool.renderPage(ctx, velocitySupport);
                return;
            }
            case upload: {
                velocitySupport.setSuccess(success);
                RenderTool.renderPage(ctx, velocitySupport);
                return;
            }
            case builtin: {
                if (filename != null) {
                    IMultipartFormDataHandler.IProgressReporter pr = ProgressManager.createDefaultProgressReporter((String)progressToken);
                    success = ModuleManager.get().getFiles().doImportBuiltin(ctx, filename, pr);
                    if (success) {
                        ctx.getResponse().sendRedirect(Router.get().url_items_tagcloud(null));
                    }
                    return;
                }
                velocitySupport.setSuccess(false);
                RenderTool.renderPage(ctx, velocitySupport);
                return;
            }
        }
    }

    public IMultipartFormDataHandler upload() throws IOException, FileUploadException {
        return new IMultipartFormDataHandler(){
            private boolean success = false;
            private String contentName;

            public void onContentPartStream(String fieldName, String contentName, Map<String, String> headers, String contentType, InputStream in, IMultipartFormDataHandler.IProgressReporter progress) throws IOException {
                FileUpload upload = new FileUpload(contentName, headers, contentType, in);
                this.success = ModuleManager.get().getFiles().doImportUpload(upload, progress);
            }

            public void onContentPartString(String fieldName, String contentName, Map<String, String> headerMap, String contentType, String value, IMultipartFormDataHandler.IProgressReporter progress) {
                this.contentName = contentName;
            }

            public void onEndOfRequest(IRestlessContext ctx, IMultipartFormDataHandler.IProgressReporter progress) throws IOException {
                Personalisation p13n = ModuleManager.get().getPersonalisation();
                FileVelocitySupport velocitySupport = new FileVelocitySupport(FileResource.this, p13n, ConfParamsDwzModel.MESSAGE_PACKAGES, ctx.getRequestIdentifier(), Router.get(), false, "upload", this.contentName == null ? "upload" : this.contentName);
                velocitySupport.setState("uploaded");
                velocitySupport.setTitle("File");
                velocitySupport.setSuccess(this.success);
                RenderTool.renderPage(ctx, velocitySupport);
            }
        };
    }

    @Template(value="link(..)")
    public static String link(String command, FileMeta fileMeta, String progressToken) {
        StringBuilder b = new StringBuilder();
        b.append("<a href='");
        b.append(Router.get().url_file(command, fileMeta.getFilename()) + "&_progressToken_=" + progressToken);
        b.append("'>");
        b.append(fileMeta.getFilename());
        b.append("</a>");
        return b.toString();
    }

    public static enum Command {
        open("open"),
        copyTo("copyTo"),
        createNew("createNew"),
        upload("import"),
        export("export"),
        builtin("import"),
        versions("versions"),
        close("close");

        private final String template;

        private Command(String template) {
            this.template = template;
        }

        public String getTemplate() {
            return this.template;
        }
    }
}

