/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwz1.server;

import bsh.EvalError;
import com.calpano.common.server.local.ShutdownServer;
import de.xam.desktop.Desktop;
import de.xam.dwz1.DwzAppInfo;
import de.xam.dwz1.api.ConfParamsDWZ1;
import de.xam.dwz1.server.LocalMachine;
import de.xam.dwz1.webgui.Router;
import de.xam.dwzmodel.DwzModel;
import de.xam.dwzmodel.state.ModuleManager;
import de.xam.mybase.model.IoProgressReporter;
import de.xam.shell.Shell;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Level;
import org.xydra.conf.IConfig;
import org.xydra.conf.escape.Escaping;
import org.xydra.conf.impl.ConfigTool;
import org.xydra.env.Env;
import org.xydra.jetty.DesktopJetty;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.log.conf.LogConfTool;
import org.xydra.log.impl.universal.UniversalLogger;
import org.xydra.log.util.Log4jUtils;

public abstract class BaseDenkWerkZeugServer
implements ShutdownServer.IGetStopped {
    protected static Logger log;
    private DesktopJetty desktopJetty;
    private Shell shell;
    private boolean shutdown = false;
    private Thread shutdownHook;
    private ShutdownServer shutDownServer;
    private final Set<Flag> activeFlags = new HashSet<Flag>();

    private static int getAppServerPort() {
        IConfig conf = Env.get().conf();
        int shutDownServerPort = conf.getInt("jetty-port");
        return shutDownServerPort;
    }

    private static int getShutDownServerPort() {
        IConfig conf = Env.get().conf();
        int shutDownServerPort = conf.getInt("shutDownServerPort");
        return shutDownServerPort;
    }

    private static void showWelcomeConsole0() {
        System.out.println("");
        System.out.println("");
        System.out.println("        \u2b23");
    }

    private static void showWelcomeConsole1() {
        System.out.println("");
        System.out.println("        Denkwerkzeug");
        System.out.println("        " + BaseDenkWerkZeugServer.getAppVersionAndConfigString());
        System.out.println("");
        System.out.println("_______ Read the following only if something went wrong 8-) ______________");
        System.out.println("Default server port: " + BaseDenkWerkZeugServer.getAppServerPort() + ". Default shutdown port: " + BaseDenkWerkZeugServer.getShutDownServerPort() + ".");
    }

    private static void showWelcomeConsole2() {
        System.out.println("______________________________________________________________________________________________________________");
        System.out.println("");
        System.out.println("    Opening your default browser on");
        System.out.println("");
        System.out.println("        " + BaseDenkWerkZeugServer.startUrl());
        System.out.println("");
        System.out.println("    Please wait up to 30 seconds.");
        System.out.println("    If nothing happens, you can open the web address yourself in any local browser.");
        System.out.println("");
        System.out.println("");
        System.out.println("    How to stop the server?");
        System.out.println("        1) In DenkWerkZeug:  Use the menu option 'Shutdown'.");
        System.out.println("        2) In this console:  Type 'q', then ENTER.");
        System.out.println("    Or if (1) and (2) don't work. You might loose unsaved data:");
        System.out.println("        3) Hard shutdown:    Open http://localhost:" + BaseDenkWerkZeugServer.getShutDownServerPort() + " in any browser.");
        System.out.println("        4) Taskmanager:      Kill the 'DenkWerkZeugServer' process.");
        System.out.println("");
        System.out.println("______________________________________________________________________________________________________________");
        System.out.println("");
    }

    private static String startUrl() {
        return "http://localhost:" + BaseDenkWerkZeugServer.getAppServerPort() + "/boot?targetUrl=" + "http://localhost:" + BaseDenkWerkZeugServer.getAppServerPort() + new Router("").url_guide("start");
    }

    public static String getAppVersionAndConfigString() {
        String appName = (String)Env.get().conf().tryToGetAs("appName", String.class);
        return DwzAppInfo.getVersionString() + "." + appName;
    }

    public void boot(String[] args) throws IOException, URISyntaxException, EvalError {
        BaseDenkWerkZeugServer.showWelcomeConsole0();
        Thread.currentThread().setName("DWZ-main");
        IConfig conf = Env.get().conf();
        this.configureDevVsProduction(conf);
        Desktop.configureSystemProperties((String)BaseDenkWerkZeugServer.getAppName());
        BaseDenkWerkZeugServer.showWelcomeConsole1();
        this.bootLogging();
        log.info("     _____ DenkWerkZeugServer _____ ");
        log.info("     " + BaseDenkWerkZeugServer.getAppVersionAndConfigString());
        LocalMachine.logAndSysout("     Got command line parameters: " + Arrays.asList(args), log);
        System.out.println("     Possible command line parameters (usage: '-foo'):");
        System.out.println("     '-clearconf' - delete user config file");
        System.out.println("     '-v' - verbatim, more logging, more debug output");
        System.out.println("     '-trace' - Log level TRACE -- this logs A LOT! Very slow.");
        System.out.println("     '-debug' - Log level DEBUG -- this logs more");
        System.out.println("     '-info'  - Log level INFO  -- this logs overview messages");
        System.out.println("     Default: - Log level WARN  -- show only warnings and errors");
        for (String s : args) {
            if (s.equals("-clearconf")) {
                this.setActiveFlag(Flag.clearconf);
                continue;
            }
            if (s.equalsIgnoreCase("-v")) {
                this.setActiveFlag(Flag.verbose);
                continue;
            }
            if (s.equalsIgnoreCase("-trace")) {
                this.setActiveFlag(Flag.logLevelTrace);
                continue;
            }
            if (s.equalsIgnoreCase("-debug")) {
                this.setActiveFlag(Flag.logLevelDebug);
                continue;
            }
            if (!s.equalsIgnoreCase("-info")) continue;
            this.setActiveFlag(Flag.logLevelInfo);
        }
        log.info("Active options: " + Arrays.asList(this.activeFlags));
        this.processFlagVerbose();
        this.processFlagLogLevel();
        this.processFlagClearConf();
        log.info("Configuring app settings ...");
        this.configureApp(conf);
        System.out.println("Set server port: " + BaseDenkWerkZeugServer.getAppServerPort() + ". Set shutdown port: " + BaseDenkWerkZeugServer.getShutDownServerPort() + ".");
        if (this.isFlagActive(Flag.verbose)) {
            BaseDenkWerkZeugServer.dumpConfig(conf);
        }
        BaseDenkWerkZeugServer.writeConf(conf);
        log.info("Stop other instances of this app ...");
        try {
            ShutdownServer.sendStopToLocalhost((int)BaseDenkWerkZeugServer.getShutDownServerPort());
        }
        catch (UnknownHostException e) {
            log.warn("???", (Throwable)e);
        }
        catch (SocketException e) {
            log.info("... found and stopped.");
        }
        catch (IOException e) {
            log.warn("???", (Throwable)e);
        }
        log.info("Starting local web server ...");
        this.start(conf);
    }

    public void bootLogging() {
        UniversalLogger.activate();
        log = LoggerFactory.getLogger(BaseDenkWerkZeugServer.class);
        Log4jUtils.configureLog4j();
        this.configureSomeLoggersFromCode();
    }

    private void processFlagClearConf() {
        if (this.isFlagActive(Flag.clearconf)) {
            Desktop.clearUserConf((String)BaseDenkWerkZeugServer.getAppName());
        }
    }

    private boolean isFlagActive(Flag flag) {
        return this.activeFlags.contains((Object)flag);
    }

    protected void setActiveFlag(Flag flag) {
        this.activeFlags.add(flag);
    }

    private void processFlagLogLevel() {
        boolean trace = this.isFlagActive(Flag.logLevelTrace);
        boolean debug = this.isFlagActive(Flag.logLevelDebug);
        boolean info = this.isFlagActive(Flag.logLevelInfo);
        if (trace) {
            Log4jUtils.setRootLevel((Level)Level.TRACE);
            Log4jUtils.setLevel(ShutdownServer.class, (Level)Level.DEBUG);
        } else if (debug) {
            Log4jUtils.setRootLevel((Level)Level.DEBUG);
        } else if (info) {
            Log4jUtils.setRootLevel((Level)Level.INFO);
        }
    }

    private void processFlagVerbose() {
        boolean verbose = this.isFlagActive(Flag.verbose);
        IConfig conf = Env.get().conf();
        conf.set("verbose", (Object)verbose);
        if (!verbose) {
            return;
        }
        LocalMachine.logAndSysout("Java version: " + System.getProperty("java.version"), log);
        LocalMachine.logAndSysout("Java home: " + System.getProperty("java.home"), log);
        LocalMachine.logAndSysout("OS: " + System.getProperty("os.name") + " // " + System.getProperty("os.version") + " // " + System.getProperty("os.arch"), log);
        LocalMachine.logAndSysout("User name: '" + System.getProperty("user.name") + "' // Homedir: '" + System.getProperty("user.home") + "' // Workdir: '" + System.getProperty("user.dir") + "'", log);
        LocalMachine.logAndSysout("Separator file: '" + System.getProperty("file.separator") + "' // path '" + System.getProperty("path.separator") + "' // line '" + Escaping.toCodepoints((String)System.getProperty("line.separator")) + "'", log);
        LocalMachine.logAndSysout("File encoding: " + System.getProperty("file.encoding"), log);
    }

    private static void dumpConfig(IConfig conf) {
        System.out.println("=== Configuration");
        ConfigTool.dump((IConfig)conf);
    }

    private static String getAppName() {
        IConfig conf = Env.get().conf();
        return conf.getString("appName");
    }

    private static void writeConf(IConfig conf) {
        File writeFile = LocalMachine.writeUserConf(conf);
        if (writeFile != null) {
            LocalMachine.logAndSysout("Done configuring. Wrote user config file to " + writeFile.getAbsolutePath(), log);
        }
    }

    public void configureApp(IConfig conf) {
        new ConfParamsDWZ1().configureDefaults(conf);
        String docRootUrlString = LocalMachine.getAutoDiscoveredWebAppDocRoot(log);
        assert (docRootUrlString != null);
        log.info("Using webapp.docRoot = '" + docRootUrlString + "'");
        conf.set("jetty-docroot", (Object)docRootUrlString);
        File readFile = LocalMachine.loadUserConf(conf, log);
        if (readFile != null) {
            LocalMachine.logAndSysout("Read user conf from " + readFile.getAbsolutePath(), log);
            String webrootInConf = conf.getString("jetty-docroot");
            if ((webrootInConf.startsWith("jar") || webrootInConf.endsWith(".jar!/")) && !docRootUrlString.equals(webrootInConf)) {
                log.info("Auto-fixed docRoot from " + webrootInConf + " to " + docRootUrlString);
                conf.set("jetty-docroot", (Object)docRootUrlString);
            }
        }
        this.configureConfFromCode(conf);
        LocalMachine.logAndSysout("Processing configuation ...", log);
        LogConfTool.applyLogConf();
    }

    protected abstract void configureConfFromCode(IConfig var1);

    protected abstract void configureDevVsProduction(IConfig var1);

    protected abstract void configureSomeLoggersFromCode();

    protected boolean doExit() {
        LocalMachine.logAndSysout("_____ Shutting down clean _____", log);
        boolean success = this.stop();
        LocalMachine.logAndSysout("_____ Bye _____", log);
        return success;
    }

    protected void onExit() {
        LocalMachine.logAndSysout("_____ Shutting down in a hurry _____", log);
        this.stop();
    }

    private void start(IConfig conf) throws IOException, URISyntaxException {
        this.shutdownHook = new Thread(){

            @Override
            public void run() {
                if (BaseDenkWerkZeugServer.this.shutdown) {
                    return;
                }
                BaseDenkWerkZeugServer.this.onExit();
            }
        };
        this.shutdownHook.setName("App-ShutdownHook");
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        this.shutDownServer = ShutdownServer.activateOnPort((int)BaseDenkWerkZeugServer.getShutDownServerPort(), (ShutdownServer.IGetStopped)this);
        this.desktopJetty = new DesktopJetty();
        this.desktopJetty.configureFromConf(conf);
        try {
            this.desktopJetty.startServer();
        }
        catch (Error | Exception e) {
            log.error("Could not start server", e);
            this.stop();
        }
        log.info("Launching browser ... URL = " + BaseDenkWerkZeugServer.startUrl());
        try {
            Desktop.openUrlInDefaultBrowser((String)BaseDenkWerkZeugServer.startUrl());
        }
        catch (Throwable t) {
            log.warn("Failed to open browser", t);
            System.out.println("Could not open browser. Please go yourself to\n" + BaseDenkWerkZeugServer.startUrl());
        }
        log.info("Browser launched.");
        System.out.println("======= Log file is at " + Desktop.getLogDir((String)BaseDenkWerkZeugServer.getAppName()));
        System.out.println("_______ Done with technical details. _____________________________________");
        BaseDenkWerkZeugServer.showWelcomeConsole2();
        System.out.println("_______ Logging resumes with even more technical stuff ... _________");
        try {
            this.shell = new Shell(new Shell.CommandHandler(){

                public boolean handleCommand(String cmd, Writer w) throws IOException {
                    return false;
                }

                public boolean handleExit() {
                    boolean success = BaseDenkWerkZeugServer.this.doExit();
                    return success;
                }
            });
            this.shell.openShell();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        System.out.println("    Shell closed.");
    }

    public boolean stop() {
        if (this.shell != null) {
            this.shell.stop();
        }
        if (this.desktopJetty != null) {
            this.desktopJetty.stopServer();
        }
        if (this.shutDownServer != null) {
            this.shutDownServer.stopListeningForStopRequests();
        }
        this.shutdown = true;
        return true;
    }

    public void configureForTests() {
        DwzModel.configureForTests();
        IConfig conf = Env.get().conf();
        conf.setAs("jetty-port", (Object)8889);
        conf.setAs("shutDownServerPort", (Object)8887);
        this.bootLogging();
        this.configureApp(conf);
        IoProgressReporter iop = IoProgressReporter.createOnLogInfo((Logger)log);
        ModuleManager.get().boot(iop);
    }

    public static enum Flag {
        verbose,
        clearconf,
        logLevelDebug,
        logLevelTrace,
        logLevelInfo;

    }
}

