/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwz1;

import com.calpano.common.server.util.ExceptionUtils;
import com.calpano.kgif.io.FileFormat;
import de.xam.dwz1.webgui.ItemWidget;
import de.xam.dwz1.webgui.PartialEditLinks;
import de.xam.dwz1.webgui.Router;
import de.xam.dwzmodel.DwzModel;
import de.xam.dwzmodel.io.DwzFileFormats;
import de.xam.dwzmodel.state.FileManager;
import de.xam.dwzmodel.state.ModuleManager;
import de.xam.htmlwidgets.ToHtml;
import de.xam.htmlwidgets.elements.Link;
import de.xam.htmlwidgets.elements.Span;
import de.xam.htmlwidgets.elements.form.Form;
import de.xam.htmlwidgets.elements.form.HiddenInput;
import de.xam.htmlwidgets.elements.form.Input;
import de.xam.htmlwidgets.elements.form.SubmitInput;
import de.xam.htmlwidgets.elements.form.TextInput;
import de.xam.htmlwidgets.elements.list.OrderedList;
import de.xam.htmlwidgets.elements.table.Table;
import de.xam.htmlwidgets.elements.table.TableCell;
import de.xam.htmlwidgets.elements.table.TableRow;
import de.xam.htmlwidgets.parts.Attribute;
import de.xam.htmlwidgets.parts.HtmlNode;
import de.xam.itemset.IItem;
import de.xam.itemset.IItemSet;
import de.xam.itemset.IProperty;
import de.xam.itemset.IStatement;
import de.xam.itemset.impl.ItemSets;
import de.xam.kfacet.impl.wiki.WikiConfig;
import de.xam.kfacet.impl.wiki.WikiFacet;
import de.xam.kfacet.impl.wiki.WikiItem;
import de.xam.kfacet.impl.wiki.spi.IEntity2Href;
import de.xam.mybase.model.MyBases;
import de.xam.mybase.model.api.IMyBase;
import de.xam.mybase.model.api.MyBaseImpl;
import de.xam.mybase.model.api.SesameWrapper;
import de.xam.mybase.model.api.render.RelatedItems;
import de.xam.mybase.model.api.render.RelatedItemsTreeRoot;
import de.xam.mybase.model.api.render.RenderRel;
import de.xam.mybase.model.api.render.RenderTarget;
import de.xam.tokenpipe.user.pipe.link.spi.ILinkListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryException;
import org.xydra.base.XId;
import org.xydra.base.value.XValue;
import org.xydra.index.Factory;
import org.xydra.index.IEntrySet;
import org.xydra.index.impl.SerializableMapSetIndex;
import org.xydra.index.impl.SmallEntrySetFactory;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class DWZ
extends DwzModel {
    private static final Logger log = LoggerFactory.getLogger(DWZ.class);
    private static DWZ INSTANCE;

    public static String getWikiHtml(XId itemId) throws IOException {
        if (itemId == null) {
            return "";
        }
        IItem item = DWZ.getMyBase().itemSet().getItemById(itemId);
        if (item == null) {
            log.warn("request for wikiHtml for a null-item with id '" + itemId + "'");
            return "";
        }
        assert (item != null);
        String wikiSource = WikiItem.getWikiSource((IItem)item);
        if (wikiSource == null) {
            if (WikiConfig.builtInPagesList.contains(item.getDisplayString())) {
                return "Loading wiki content...";
            }
            return null;
        }
        DWZ.getWikiFacet();
        boolean createManualLinks = true;
        boolean createAutoLinks = true;
        String html = WikiFacet.parseToHtmlWithSideEffects((IMyBase)DWZ.getMyBase(), (IEntity2Href)DwzModel.getEntity2Href(), (IItem)item, (String)wikiSource, (boolean)true, (boolean)true, (boolean)true);
        html = PartialEditLinks.addPartialEditLinks(itemId, wikiSource, html);
        return html;
    }

    public static FileManager files() {
        return ModuleManager.get().getFiles();
    }

    public static String getRelatedItemsHtml(IItem item, XId relationId) {
        int maxRels = 50;
        int maxTargetsPerRel = 100;
        RelatedItems relatedItems = MyBases.getRelatedItems((IMyBase)DWZ.getMyBase(), (IItem)item, null);
        RelatedItemsTreeRoot rri = relatedItems.toRenderRelatedItems(DWZ.getMyBase(), relationId);
        StringBuilder b = new StringBuilder();
        ILinkListener.LinkCause linkCause = ILinkListener.LinkCause.app;
        Table table = new Table();
        table.cssClasses(new String[]{"table"});
        int relCount = 0;
        for (RenderRel renderRel : rri.getRels()) {
            if (++relCount > 50) break;
            TableRow row = table.row();
            row.cssClasses(new String[]{renderRel.isInverse() ? "backward" : "forward"});
            TableCell relCell = row.dataCell(DwzModel.toLink((XId)renderRel.id, (String)linkCause.name(), (String[])new String[]{"rel", renderRel.infd ? "inf" : "stated"}).toString());
            TableCell cell = row.dataCell();
            cell.cssClasses(new String[]{"targets"});
            OrderedList ol = (OrderedList)new OrderedList((ToHtml)cell, new Attribute[0]).cssClasses(new String[]{"targets"});
            int targetCount = 0;
            for (RenderTarget rt : renderRel.targets) {
                if (++targetCount > 100) {
                    String sId = item.getId().toString();
                    String pId = renderRel.id.toString();
                    String queryHref = Router.get().url_query_spo(sId, pId, null);
                    if (renderRel.isInverse()) {
                        queryHref = Router.get().url_query_spo(null, pId, sId);
                    }
                    String queryLabel = "(" + renderRel.targets.size() + ")";
                    HtmlNode htmlNode = new HtmlNode(relCell.getValue() + " <a href='" + queryHref + "'>" + queryLabel + "</a>");
                    relCell.setValue("");
                    relCell.html((ToHtml)htmlNode);
                    ol.li_HTML("... and more. <a href='" + queryHref + "'>Show all " + renderRel.targets.size() + "</a>", new Attribute[0]).cssClasses(new String[]{"target"});
                    break;
                }
                ol.li_HTML(DwzModel.toLink((XId)rt.id, (String)linkCause.name(), (String[])new String[]{rt.infd ? "inf" : "stated"}) + (rt.infd ? "" : "<a class='remove' title='Delete this link' href='" + Router.get().url_item_relation_delete(item.getId(), renderRel.id, rt.id) + "'><span class='glyphicon glyphicon-remove'></span></a>"), new Attribute[0]).cssClasses(new String[]{"target"});
            }
            Form form = new Form((ToHtml)cell, Form.METHOD.POST, Router.get().url_item_relation(item.getId(), renderRel.id));
            form.inputHidden("oId", "").cssClasses(new String[]{"autocomplete-item-id"});
            form.inputHidden("inverse", "" + renderRel.isInverse());
            ((Input)((Input)((Input)form.inputText("New target...", "oName", null).cssClasses(new String[]{"typeahead"})).addAttribute("style", "max-width: 110px;")).addAttribute("required", "required")).cssClasses(new String[]{"autocomplete-item-name-submit"});
            form.inputSubmit("!");
            cell.setValue(ol.toHtml("    ") + form.toHtml("    "));
        }
        b.append(table.toHtml("  "));
        return b.toString();
    }

    public static Table<ItemWidget> getPropertyUsage(XId itemId, int limit) {
        IItem item = DWZ.getMyBase().itemSet().getItemById(itemId);
        if (item == null) {
            return new Table();
        }
        return DWZ.getPropertyUsage(item, limit);
    }

    public static Table<ItemWidget> getRelationUsage(XId itemId, int limit) {
        IItem item = DWZ.getMyBase().itemSet().getItemById(itemId);
        if (item == null) {
            return new Table();
        }
        return DWZ.getRelationUsage(item, limit);
    }

    public static Form getAdd_XPX_Table(XId relationItemId) {
        Form form = new Form(null, Form.METHOD.POST, Router.get().url_relation(relationItemId));
        Table formTable = new Table();
        formTable.cssClasses(new String[]{"table", "spo-table"});
        TableRow row = formTable.row();
        TableCell cell = row.dataCell();
        HiddenInput hiddenInput = new HiddenInput((ToHtml)cell, "sId", "");
        hiddenInput.addAttribute("class", "autocomplete-item-id");
        hiddenInput.addAttribute("id", "relation-xpx-adder-s-id");
        cell.children.add(hiddenInput);
        TextInput textInput = new TextInput((ToHtml)cell, "New source...", "sName", "");
        textInput.cssClasses(new String[]{"autocomplete-item-name", "typeahead"});
        textInput.addAttribute("id", "relation-xpx-adder-s-name");
        textInput.addAttribute("style", "max-width: 110px;");
        textInput.addAttribute("required", "required");
        cell.children.add(textInput);
        row.dataCell("<span class='glyphicon glyphicon-arrow-right'></span>");
        cell = row.dataCell();
        hiddenInput = new HiddenInput((ToHtml)cell, "oId", "");
        hiddenInput.addAttribute("class", "autocomplete-item-id");
        hiddenInput.addAttribute("id", "relation-xpx-adder-s-id");
        cell.children.add(hiddenInput);
        textInput = new TextInput((ToHtml)cell, "New target...", "oName", "");
        textInput.cssClasses(new String[]{"autocomplete-item-name", "typeahead"});
        textInput.addAttribute("id", "relation-xpx-adder-o-name");
        textInput.addAttribute("style", "max-width: 110px;");
        textInput.addAttribute("required", "required");
        cell.children.add(textInput);
        SubmitInput submit = new SubmitInput((ToHtml)cell, "!");
        cell.children.add(submit);
        form.children.add(formTable);
        return form;
    }

    public static Table<ItemWidget> getRelationUsage(IItem relationItem, int limit) {
        String linkCause = "query";
        Table table = new Table();
        table.cssClasses(new String[]{"table", "spo-table"});
        SerializableMapSetIndex soMap = new SerializableMapSetIndex((Factory)new SmallEntrySetFactory());
        IItemSet itemSet = DWZ.getMyBase().itemSet();
        Set relations = itemSet.getStatementsFor(null, relationItem.getId(), null);
        for (IStatement stmt : relations) {
            soMap.index((Object)stmt.getTriple().s(), (Object)stmt.getTriple().o());
        }
        List sList = ItemSets.sortByItemContent((IItemSet)itemSet, (Iterator)soMap.keyIterator());
        int count = 0;
        for (XId s : sList) {
            if (limit > -1 && count > limit) break;
            TableRow row = table.row();
            row.dataCell(DwzModel.toLink((XId)s, (String)"query", (String[])new String[0]).toString());
            row.dataCell("<span class='glyphicon glyphicon-arrow-right'></span>");
            IEntrySet oSet = soMap.lookup((Object)s);
            OrderedList ul = new OrderedList(null, new Attribute[0]);
            ul.cssClasses(new String[]{"targets"});
            for (XId o : oSet) {
                String html = DwzModel.toLink_Value((XValue)o, (String)"query", (String[])new String[0]).toString();
                ul.li_HTML(html, new Attribute[0]).cssClasses(new String[]{"target"});
            }
            row.dataCell(ul.toString());
            ++count;
        }
        return table;
    }

    public static Table<ItemWidget> getPropertyUsage(IItem item, int limit) {
        String linkCause = "query";
        Table table = new Table();
        table.cssClasses(new String[]{"table", "spo-table"});
        SerializableMapSetIndex soMap = new SerializableMapSetIndex((Factory)new SmallEntrySetFactory());
        IItemSet itemSet = DWZ.getMyBase().itemSet();
        Set props = itemSet.getPropertiesFor(null, item.getId());
        for (IProperty prop : props) {
            assert (prop.getWritableContent().getContentValue() != null);
            soMap.index((Object)prop.getSourceEntityId(), (Object)prop);
        }
        List sList = ItemSets.sortByItemContent((IItemSet)itemSet, (Iterator)soMap.keyIterator());
        int count = 0;
        for (XId s : sList) {
            if (limit > -1 && count > limit) break;
            TableRow row = table.row();
            row.dataCell(DwzModel.toLink((XId)s, (String)"query", (String[])new String[0]).toString());
            row.dataCell("<span class='glyphicon glyphicon-arrow-right'></span>");
            IEntrySet oSet = soMap.lookup((Object)s);
            assert (oSet.size() == 1);
            IProperty prop = (IProperty)oSet.iterator().next();
            Form form = new Form(null, Form.METHOD.POST, Router.get().url_item_property(s, prop.getPropertyKey()));
            String propertyValueStr = prop.getPropertyValue().toString();
            form.inputText("", "oValue", propertyValueStr).addAttribute("required", "required");
            Link link = (Link)new Link(null, "", Router.get().url_entity_delete(prop.getId()), new Attribute[]{new Attribute("title", "Delete this property")}).cssClasses(new String[]{"remove"});
            Span span = new Span((ToHtml)link, new Attribute[0]);
            span.cssClasses(new String[]{"glyphicon glyphicon-remove"});
            link.html((ToHtml)span);
            form.html((ToHtml)link);
            form.inputSubmit("!");
            String html = form.toHtml("  ");
            row.dataCell(html);
            ++count;
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sparqlQuery(String query) {
        Table resultTable = new Table();
        resultTable.cssClasses(new String[]{"table"});
        SesameWrapper wrapper = ((MyBaseImpl)DWZ.getMyBase()).getSesameWrapper();
        try {
            boolean first = true;
            try (TupleQueryResult result = wrapper.query(query);){
                while (result.hasNext()) {
                    TableCell cell;
                    TableRow row;
                    BindingSet bindingSet = (BindingSet)result.next();
                    Iterator it = bindingSet.iterator();
                    TreeMap<String, String> res = new TreeMap<String, String>();
                    while (it.hasNext()) {
                        Binding binding = (Binding)it.next();
                        String name = binding.getName();
                        String string = binding.getValue().stringValue();
                        res.put(name, string);
                    }
                    if (first) {
                        row = resultTable.row();
                        for (String string : res.keySet()) {
                            cell = row.headerCell();
                            cell.setValue(string);
                        }
                        first = false;
                    }
                    row = resultTable.row();
                    for (Map.Entry entry : res.entrySet()) {
                        cell = row.dataCell();
                        String value = (String)entry.getValue();
                        if (SesameWrapper.isXid((String)value)) {
                            XId id = SesameWrapper.toXId((String)value);
                            StringBuilder s = DwzModel.toLink((XId)id, (ILinkListener.LinkCause)ILinkListener.LinkCause.app, (String[])new String[0]);
                            cell.setValue(s.toString());
                            continue;
                        }
                        cell.setValue(value);
                    }
                }
            }
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Error", e);
        }
        catch (MalformedQueryException e) {
            StringBuffer buf = new StringBuffer();
            buf.append(ExceptionUtils.toHtmlStringWithStacktrace((Throwable)e));
            return buf.toString();
        }
        catch (QueryEvaluationException e) {
            throw new RuntimeException("Error", e);
        }
        return resultTable.toHtml("  ");
    }

    public static List<FileFormat> getKnownFileFormatsList() {
        ArrayList<FileFormat> list = new ArrayList<FileFormat>();
        list.addAll(DwzFileFormats.getKnownFileFormats());
        Collections.sort(list);
        return list;
    }

    public static IEntity2Href createEntity2Href() {
        return new IEntity2Href(){

            public String getViewItemUrl(XId itemId) {
                return Router.get().url_item(itemId);
            }

            public String getDisambiguateItemsUrl(String name) {
                return Router.get().url_items_byName(name);
            }
        };
    }

    public static synchronized DWZ get() {
        if (INSTANCE == null) {
            INSTANCE = new DWZ();
        }
        return INSTANCE;
    }
}

