/*
 * Decompiled with CFR 0.152.
 */
package de.xam.jspwiki;

import de.xam.files.FileTools;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class VersioningFileProvider {
    private static final Logger log = LoggerFactory.getLogger(VersioningFileProvider.class);
    private final String encoding;
    private final File rootDir;
    private final File oldDir;
    private final String ext;

    public static VersioningFileProvider createJspWikiStyle(File rootDir, String encoding) {
        VersioningFileProvider vfp = new VersioningFileProvider(rootDir, new File(rootDir, "OLD"), encoding, "txt");
        return vfp;
    }

    public VersioningFileProvider(File rootDir, File oldDir, String encoding, String ext) {
        assert (rootDir.exists()) : rootDir.getAbsolutePath() + " not found";
        this.encoding = encoding;
        this.rootDir = rootDir;
        this.oldDir = oldDir;
        this.ext = ext;
    }

    public static void main(String[] args) throws IOException {
        File f = new File("./target/wiki");
        f.mkdirs();
        VersioningFileProvider v = VersioningFileProvider.createJspWikiStyle(f, "ISO-8859-1");
        System.out.println("current: " + v.getFile("Hello").readCurrentContent());
        System.out.println("1: " + v.getFile("Hello").readContentOfVersion(1));
        System.out.println("2: " + v.getFile("Hello").readContentOfVersion(2));
        System.out.println("3: " + v.getFile("Hello").readContentOfVersion(3));
        System.out.println("version: " + v.getFile("Hello").getCurrentVersionNumber());
    }

    public VersionedTextFile getFile(String name) {
        return new VersionedTextFile(name);
    }

    public int size() {
        return this.listFiles().length;
    }

    public VersionedTextFile[] getFiles() {
        File[] files = this.listFiles();
        VersionedTextFile[] vFiles = new VersionedTextFile[files.length];
        for (int i = 0; i < vFiles.length; ++i) {
            vFiles[i] = this.getFile(FileTools.getNameWithoutExtension((File)files[i]));
        }
        return vFiles;
    }

    private File[] listFiles() {
        return this.rootDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(VersioningFileProvider.this.ext);
            }
        });
    }

    public class VersionedTextFile {
        private final String name;

        public VersionedTextFile(String name) {
            assert (name != null);
            this.name = name;
        }

        void write(String content) throws IOException {
            assert (content != null);
            String currentContent = this.readCurrentContent();
            if (content.equals(currentContent)) {
                return;
            }
            int lastVersion = this.getCurrentVersionNumber();
            if (lastVersion == 0) {
                File targetFile = this.getLiveVersionFile();
                assert (!targetFile.exists());
                FileUtils.writeStringToFile((File)targetFile, (String)content, (String)VersioningFileProvider.this.encoding);
            } else {
                if (!this.getOldFileDir().exists()) {
                    this.getOldFileDir().mkdirs();
                }
                FileUtils.moveFile((File)this.getLiveVersionFile(), (File)this.getFileRepresentingOldVersion(lastVersion));
                FileUtils.writeStringToFile((File)this.getLiveVersionFile(), (String)content, (String)VersioningFileProvider.this.encoding);
            }
        }

        private File getVersionFile(int version) {
            assert (version >= 0);
            if (version == 0) {
                return null;
            }
            File f = this.getFileRepresentingOldVersion(version);
            if (f.exists()) {
                return f;
            }
            return this.getLiveVersionFile();
        }

        private File getFileRepresentingOldVersion(int version) {
            return new File(this.getOldFileDir(), "" + version + "." + VersioningFileProvider.this.ext);
        }

        public int getCurrentVersionNumber() {
            File liveVersion = this.getLiveVersionFile();
            if (liveVersion.exists()) {
                File oldFileDir = this.getOldFileDir();
                if (oldFileDir.exists()) {
                    int max = 1;
                    for (File f : oldFileDir.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname.getName().endsWith(VersioningFileProvider.this.ext);
                        }
                    })) {
                        String name = FileTools.getNameWithoutExtension((File)f);
                        try {
                            int number = Integer.parseInt(name);
                            max = Math.max(max, number);
                        }
                        catch (NumberFormatException e) {
                            log.warn("could not parse " + f.getAbsolutePath(), (Throwable)e);
                        }
                    }
                    return max + 1;
                }
                return 1;
            }
            return 0;
        }

        private File getLiveVersionFile() {
            return new File(VersioningFileProvider.this.rootDir, this.name + "." + VersioningFileProvider.this.ext);
        }

        public File getOldFileDir() {
            return new File(VersioningFileProvider.this.oldDir, this.name);
        }

        public String readCurrentContent() throws IOException {
            return this.readContentOfVersion(this.getCurrentVersionNumber());
        }

        public String readContentOfVersion(int version) throws IOException {
            if (version == 0) {
                return "";
            }
            File f = this.getVersionFile(version);
            if (f.exists()) {
                return FileUtils.readFileToString((File)f, (String)VersioningFileProvider.this.encoding);
            }
            return null;
        }

        public long timestamp(int version) {
            File f = this.getVersionFile(version);
            if (f == null) {
                return -1L;
            }
            return f.lastModified();
        }

        public long length(int version) {
            File f = this.getVersionFile(version);
            if (f == null) {
                return -1L;
            }
            return f.length();
        }

        public String getName() {
            return this.name;
        }
    }
}

