/*
 * Decompiled with CFR 0.152.
 */
package de.xam.jspwiki;

import de.xam.jspwiki.VersioningFileProvider;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.xydra.index.query.Pair;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class HomewikiSource {
    private static final Logger log = LoggerFactory.getLogger(HomewikiSource.class);
    private final SortedMap<String, String> lowercasePageNames2fileWithoutExt;
    private transient VersioningFileProvider vfp;

    public HomewikiSource(File txtDir, String encoding) {
        this.vfp = VersioningFileProvider.createJspWikiStyle(txtDir, encoding);
        int size = this.vfp.size();
        log.info("Found " + size + " pages (not yet indexed)");
        this.lowercasePageNames2fileWithoutExt = new ConcurrentSkipListMap<String, String>();
    }

    public String getRealName(String nameWithPossiblyWrongCasing) {
        assert (nameWithPossiblyWrongCasing != null);
        String realName = (String)this.lowercasePageNames2fileWithoutExt.get(nameWithPossiblyWrongCasing.toLowerCase());
        return realName;
    }

    public Set<String> getPageNameSetLowerCased() {
        return this.lowercasePageNames2fileWithoutExt.keySet();
    }

    public String getWikiSource(String pageName) throws IOException {
        String realName = this.getRealName(pageName);
        if (realName == null) {
            return null;
        }
        VersioningFileProvider.VersionedTextFile vtf = this.vfp.getFile(realName);
        return vtf.readCurrentContent();
    }

    public void indexFiles() {
        for (VersioningFileProvider.VersionedTextFile vtf : this.vfp.getFiles()) {
            String realNameLowercase = vtf.getName().toLowerCase();
            assert (!this.lowercasePageNames2fileWithoutExt.containsKey(realNameLowercase)) : vtf.getName();
            this.lowercasePageNames2fileWithoutExt.put(realNameLowercase, vtf.getName());
        }
    }

    public Iterator<String> pageNamesCaseSensitiveIterator() {
        return this.lowercasePageNames2fileWithoutExt.values().iterator();
    }

    public Pair<Integer, Long> setWikiSource(String realName, String wikiSyntax, boolean create) throws IOException {
        if (create) {
            this.lowercasePageNames2fileWithoutExt.put(realName.toLowerCase(), realName);
        }
        VersioningFileProvider.VersionedTextFile vtf = this.vfp.getFile(realName);
        vtf.write(wikiSyntax);
        int version = vtf.getCurrentVersionNumber();
        long lastModified = vtf.timestamp(version);
        return new Pair((Object)version, (Object)lastModified);
    }

    public VersioningFileProvider.VersionedTextFile getVersionedTextFile(String realPageName) {
        return this.vfp.getFile(realPageName);
    }

    public int countPages() {
        return this.vfp.size();
    }
}

