/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tokenpipe.pipe.buffer;

import de.xam.tokenpipe.IToken;
import de.xam.tokenpipe.ITokenEmitter;
import de.xam.tokenpipe.ITokenStream;
import java.util.LinkedList;
import java.util.List;

public class TokenBuffer
implements ITokenEmitter {
    private final String debugName;
    private final List<IToken> tokenBuffer = new LinkedList<IToken>();

    public TokenBuffer(String debugName) {
        this.debugName = debugName;
    }

    @Override
    public void fireToken(IToken token) {
        this.tokenBuffer.add(token);
    }

    public StringBuilder flattenToStringBuilder() {
        StringBuilder buf = new StringBuilder();
        for (IToken token : this.tokenBuffer) {
            buf.append(token.getChars() == null ? "" : token.getChars());
        }
        this.tokenBuffer.clear();
        return buf;
    }

    public void flushTokenBufferAndFireTokens(ITokenStream stream) {
        for (IToken token : this.tokenBuffer) {
            stream.fireToken(token);
        }
        this.tokenBuffer.clear();
    }

    public IToken getBufferedTokenOfType(String tokenType) throws IllegalStateException {
        for (int i = this.tokenBuffer.size() - 1; i >= 0; --i) {
            IToken t = this.tokenBuffer.get(i);
            if (!t.isStart() || !t.getType().equals(tokenType)) continue;
            return t;
        }
        throw new IllegalStateException("Found no Start-'" + tokenType + "'-token in tokenBuffer");
    }

    public IToken pop() {
        if (this.tokenBuffer.isEmpty()) {
            return null;
        }
        int index = this.tokenBuffer.size() - 1;
        IToken token = this.tokenBuffer.get(index);
        this.tokenBuffer.remove(index);
        return token;
    }

    public String toString() {
        return "debugName=" + this.debugName + "\n" + "tokenBuffer=" + this.tokenBuffer;
    }
}

