/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tokenpipe.pipe.buffer;

import de.xam.tokenpipe.IToken;
import de.xam.tokenpipe.ITokenStream;
import de.xam.tokenpipe.Token;
import org.xydra.index.query.Pair;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class FourBuffer {
    private static final Logger log = LoggerFactory.getLogger(FourBuffer.class);
    private final StringBuffer closeTag = new StringBuffer();
    private final String debugName;
    private final StringBuffer openTag = new StringBuffer();
    private final StringBuffer plainContent = new StringBuffer();
    private final StringBuffer tagContent = new StringBuffer();

    public FourBuffer(String debugName) {
        this.debugName = debugName;
    }

    public void appendCloseTagMarker(int codePoint) {
        assert (this.openTag.length() > 0);
        this.closeTag.appendCodePoint(codePoint);
    }

    public void appendOpenTagMarker(int codePoint) {
        this.openTag.appendCodePoint(codePoint);
    }

    public void appendPlainContent(int codePoint) {
        assert (this.openTag.length() == 0) : "cannot append plain content, tag is already open('" + this.openTag + "')";
        assert (this.tagContent.length() == 0);
        assert (this.closeTag.length() == 0);
        this.plainContent.appendCodePoint(codePoint);
    }

    public void appendTagContent(int codePoint) {
        assert (this.canGetTagContent()) : "cannot append tagContent before tag is open";
        this.tagContent.appendCodePoint(codePoint);
    }

    public boolean canGetTagContent() {
        return this.openTag.length() > 0;
    }

    public boolean closeTagCanMatch(String s) {
        if (this.closeTag.length() == 0) {
            return true;
        }
        return s.startsWith(this.closeTag.toString());
    }

    public boolean closeTagMatches(String s) {
        return s.equals(this.closeTag.toString());
    }

    public void discardTagAndAppend(int codePoint) {
        this.foldTagBackAsPlainContent();
        this.appendPlainContent(codePoint);
    }

    public void discardTagAndFireRemainder(ITokenStream stream, String plainType) {
        this.foldTagBackAsPlainContent();
        if (this.plainContent.length() > 0) {
            stream.fireToken(Token.create(IToken.Kind.Content, plainType, this.plainContent.toString(), new Pair[0]));
        }
    }

    public void fireTokens(ITokenStream stream, String plainType, String tagType) {
        if (this.plainContent.length() > 0) {
            stream.fireToken(Token.create(IToken.Kind.Content, plainType, this.plainContent.toString(), new Pair[0]));
        }
        stream.fireToken(Token.create(IToken.Kind.Start, tagType, this.openTag.toString(), new Pair[0]));
        if (this.tagContent.length() > 0) {
            stream.fireToken(Token.create(IToken.Kind.Content, tagType, this.tagContent.toString(), new Pair[0]));
        }
        stream.fireToken(Token.create(IToken.Kind.End, tagType, this.closeTag.toString(), new Pair[0]));
        this.plainContent.setLength(0);
        this.openTag.setLength(0);
        this.tagContent.setLength(0);
        this.closeTag.setLength(0);
    }

    private void foldTagBackAsPlainContent() {
        if (this.openTag.length() > 0) {
            this.plainContent.append(this.openTag);
            this.openTag.setLength(0);
        }
        if (this.tagContent.length() > 0) {
            this.plainContent.append(this.tagContent);
            this.tagContent.setLength(0);
        }
        if (this.closeTag.length() > 0) {
            this.plainContent.append(this.closeTag);
            this.closeTag.setLength(0);
        }
    }

    public StringBuffer getOpenTagBuffer() {
        return this.openTag;
    }

    public boolean isClosingTag() {
        boolean isClosing;
        boolean bl = isClosing = this.closeTag.length() > 0;
        assert (!isClosing || this.openTag.length() > 0);
        return isClosing;
    }

    public boolean isOpeningTag() {
        return this.openTag.length() > 0 && this.tagContent.length() == 0;
    }

    public boolean openTagCanMatch(String s) {
        if (this.openTag.length() == 0) {
            return true;
        }
        return s.startsWith(this.openTag.toString());
    }

    public boolean openTagMatches(String s) {
        return s.equals(this.openTag.toString());
    }

    public String toString() {
        return "debugName=" + this.debugName + "\n" + ".plainContent ='" + this.plainContent + "'\n" + ".openTag      ='" + this.openTag + "'\n" + ".tagContent   ='" + this.tagContent + "'\n" + ".closeTag     ='" + this.closeTag + "'";
    }

    public void disardCloseTagAndAppend(int c) {
        this.tagContent.append(this.closeTag.toString());
        this.closeTag.setLength(0);
        this.appendTagContent(c);
    }
}

