/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tokenpipe.impl;

import de.xam.texthtml.text.TextTool;
import de.xam.texthtml.text.Unicodes;
import de.xam.tokenpipe.IProvideMetaData;
import de.xam.tokenpipe.IToken;
import de.xam.tokenpipe.ITokenPipe;
import de.xam.tokenpipe.ITokenStream;
import de.xam.tokenpipe.impl.HtmlLogSink;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.apache.commons.io.FileUtils;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class TokenPipeSandbox
implements ITokenPipe,
ITokenStream {
    private static final Logger log = LoggerFactory.getLogger(TokenPipeSandbox.class);
    private static final String LOG_DIR = "./target/pipelogs";
    private static final String LOG_EXTENSION = ".log.xml";
    private ParseEvent currentParseEvent;
    private File logFile;
    private HtmlLogSink logSink;
    private OutputStreamWriter logWriter;
    private final List<ParseEvent> parseEvents;
    private final ITokenPipe pipe;
    private final int positionInParseStack;
    private final Stack<IToken> stack = new Stack();
    private final ITokenStream stream;
    private Object parseContext;

    public static File getLogFile(IProvideMetaData pmd) {
        File logDir = new File(LOG_DIR);
        logDir.mkdirs();
        return new File(logDir, pmd.getLabel() + LOG_EXTENSION);
    }

    public TokenPipeSandbox(ITokenPipe pipe, ITokenStream stream, int positionInParseStack) {
        this.pipe = pipe;
        this.stream = stream;
        this.positionInParseStack = positionInParseStack;
        this.parseEvents = new ArrayList<ParseEvent>();
    }

    @Override
    public String[] consumedTokenTypes() {
        return this.pipe.consumedTokenTypes();
    }

    @Override
    public void debug(String msg) {
        this.logSink.debug(msg);
    }

    public void dumpHistory() {
        for (ParseEvent pe : this.parseEvents) {
            System.out.println(pe.toString(this.positionInParseStack));
        }
    }

    private void finishLog() {
        this.logSink.onAfterDocument();
        try {
            this.logWriter.flush();
            this.logWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void finishLogOnException(Throwable e, String trace) {
        if (!this.logSink.isFinished) {
            this.logSink.exceptionAndFinish("at [" + this.getLabel() + "]." + trace, e);
            this.finishLog();
        }
    }

    @Override
    public void fireToken(IToken token) {
        this.stream.fireToken(token);
    }

    @Override
    public String getLabel() {
        return this.pipe.getLabel();
    }

    @Override
    public Stack<IToken> getStartTokenStack() {
        return this.stream.getStartTokenStack();
    }

    public void ignoreAndPassThrough(IToken token) {
        this.logSink.ignoreAndPassThrough(token);
    }

    public void local_onAfterDocument() {
        if (!this.stack.isEmpty()) {
            log.warn("Unclosed tokens on stack of [" + this.getLabel() + "]: " + Arrays.asList(this.stack.toArray()));
        }
    }

    public void local_onToken(IToken token) {
        if (token.isStart()) {
            this.stack.push(token);
        }
        if (token.getKind() == IToken.Kind.End) {
            if (this.stack.isEmpty()) {
                log.error("Closing token '" + token.getType() + "' never started. Token=" + token);
            } else {
                IToken open = null;
                open = this.stack.pop();
                if (!open.getType().equals(token.getType())) {
                    log.error("[" + this.getLabel() + "]: Ending token doesn't match last start token." + "\nStart: " + open.toString(100, false) + "\nEnd:   " + token.toString(100, false));
                }
            }
        }
    }

    @Override
    public void onAfterContentToken(ITokenStream stream, IToken token) {
        this.currentParseEvent = new ParseEvent(token, TokenEventKind.After);
        this.parseEvents.add(this.currentParseEvent);
        this.pipe.onAfterContentToken(stream, token);
        this.logSink.onAfterContentToken(token);
    }

    @Override
    public void onAfterDocument() {
        try {
            this.pipe.onAfterDocument();
            this.local_onAfterDocument();
        }
        catch (Error | Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.finishLog();
        }
    }

    @Override
    public void onBeforeContentToken(ITokenStream stream, IToken token) {
        this.currentParseEvent = new ParseEvent(token, TokenEventKind.Before);
        this.parseEvents.add(this.currentParseEvent);
        this.pipe.onBeforeContentToken(stream, token);
        this.logSink.onBeforeContentToken(token);
    }

    @Override
    public void onBeforeDocument() {
        this.logFile = TokenPipeSandbox.getLogFile(this);
        log.info("Logging tokenpipe sandbox to " + this.logFile.getAbsolutePath());
        try {
            FileOutputStream fos = new FileOutputStream(this.logFile);
            BufferedOutputStream bos = new BufferedOutputStream(fos, 4096);
            this.logWriter = new OutputStreamWriter((OutputStream)bos, Unicodes.UTF8);
            this.logSink = new HtmlLogSink(this.logWriter, this.getLabel());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.logSink.onBeforeDocument();
        this.pipe.onBeforeDocument();
    }

    @Override
    public void onContentCodepoint(ITokenStream stream, int codepoint, int pos, IToken token) {
        this.pipe.onContentCodepoint(stream, codepoint, pos, token);
    }

    @Override
    public void onException(Throwable e) {
        this.finishLogOnException(e, "onException");
        this.pipe.onException(e);
    }

    @Override
    public void onToken(ITokenStream stream, IToken token) {
        this.currentParseEvent = new ParseEvent(token, TokenEventKind.On);
        this.parseEvents.add(this.currentParseEvent);
        this.logSink.onToken(token);
        this.pipe.onToken(stream, token);
        this.local_onToken(token);
    }

    @Override
    public String[] producedTokenTypes() {
        return this.pipe.producedTokenTypes();
    }

    public void recordToken(IToken token, String action) {
        this.currentParseEvent.recordGeneratedToken(token);
        this.logSink.fireToken(token, action);
    }

    @Override
    public Object getParseContext() {
        return this.parseContext;
    }

    public void setParseContext(Object parseContext) {
        this.parseContext = parseContext;
    }

    static {
        try {
            File res = new File("./src/main/resources");
            File dest = new File(LOG_DIR);
            FileUtils.copyFile((File)new File(res, "xml-to-html.xsl"), (File)new File(dest, "xml-to-html.xsl"));
            FileUtils.copyFile((File)new File(res, "main.css"), (File)new File(dest, "main.css"));
        }
        catch (IOException e) {
            log.warn("Style files (xslt, css) not found. TokenPipe debug files won't look pretty", (Throwable)e);
        }
    }

    private static enum TokenEventKind {
        After,
        Before,
        On;

    }

    private class ParseEvent {
        List<IToken> generated;
        IToken received;
        TokenEventKind tokenEventKind;

        public ParseEvent(IToken received, TokenEventKind tokenEventKind) {
            this.received = received;
            this.tokenEventKind = tokenEventKind;
            this.generated = new ArrayList<IToken>();
        }

        void recordGeneratedToken(IToken token) {
            this.generated.add(token);
        }

        public String toString() {
            return this.toString(0);
        }

        public String toString(int indent) {
            String s = TextTool.indent((int)indent, (String)"  ") + "'" + this.received.getType() + "' " + TextTool.padRight((String)" ", (String)this.received.getKind().toString(), (int)"Content".length()) + " " + TextTool.padRight((String)" ", (String)this.tokenEventKind.toString(), (int)TokenEventKind.Before.toString().length()) + " [" + TokenPipeSandbox.this.getLabel() + "]" + " = " + this.received.toString(50, false);
            for (IToken gen : this.generated) {
                s = s + "\n" + TextTool.indent((int)indent, (String)"  ") + "  => " + gen.toString(50, false);
            }
            return s;
        }
    }
}

