/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tokenpipe;

import de.xam.tokenpipe.ITokenSink;
import de.xam.tokenpipe.ITokenSource;
import de.xam.tokenpipe.TokenPipeParser;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class Parsers {
    private static final Logger log = LoggerFactory.getLogger(Parsers.class);

    public static void validate(TokenPipeParser parser) {
        ITokenSource source = parser.getSource();
        ITokenSink sink = parser.getSource().getUpperTokenSink();
        HashSet<String> passedThrough = new HashSet<String>();
        Parsers.validate(passedThrough, source, sink);
        while (sink instanceof ITokenSource) {
            ITokenSource tokenSource;
            source = tokenSource = (ITokenSource)((Object)sink);
            sink = tokenSource.getUpperTokenSink();
            Parsers.validate(passedThrough, source, sink);
        }
        log.info("Expect in the end: " + Arrays.toString(passedThrough.toArray()));
    }

    private static void validate(Set<String> passedThrough, ITokenSource source, ITokenSink sink) {
        String sourceName = "[" + source.getLabel() + "]";
        String sinkName = "[" + sink.getLabel() + "]";
        log.info("=== Validating " + sourceName + " --> " + sinkName);
        log.info("Passed-through from lower layer to " + sinkName + ": " + Arrays.toString(passedThrough.toArray()));
        HashSet<String> passedFromBelow = new HashSet<String>();
        passedFromBelow.addAll(passedThrough);
        passedThrough.clear();
        log.info(sourceName + ": Producing " + Arrays.toString(source.producedTokenTypes()));
        for (String tokenType : source.producedTokenTypes()) {
            log.info(sinkName + ": '" + tokenType);
        }
    }
}

