/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.gwt.store;

import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import org.xydra.core.serialize.XydraOut;
import org.xydra.core.serialize.XydraParser;
import org.xydra.core.serialize.XydraSerializer;
import org.xydra.store.impl.rest.AbstractXydraStoreRestClient;

public class GwtXydraStoreRestClient
extends AbstractXydraStoreRestClient {
    private final String prefix;

    public GwtXydraStoreRestClient(String apiLocation, XydraSerializer serializer, XydraParser parser) {
        super(serializer, parser);
        this.prefix = apiLocation;
    }

    private final RequestBuilder request(RequestBuilder.Method method, String url, AbstractXydraStoreRestClient.Request<?> req) {
        String uri = this.prefix + url;
        uri = url.contains("?") ? uri + "&actorId=" : uri + "?actorId=";
        uri = uri + this.urlencode(req.actor.toString()) + "&passwordHash=" + this.urlencode(req.password);
        RequestBuilder rb = new RequestBuilder(method, uri);
        rb.setHeader("Accept", this.parser.getContentType());
        return rb;
    }

    protected void get(String uri, AbstractXydraStoreRestClient.Request<?> req) {
        RequestBuilder rb = this.request(RequestBuilder.GET, uri, req);
        rb.setRequestData(null);
        GwtXydraStoreRestClient.send(rb, req);
    }

    protected void post(String uri, XydraOut data, AbstractXydraStoreRestClient.Request<?> req) {
        RequestBuilder rb = this.request(RequestBuilder.POST, uri, req);
        rb.setHeader("Content-Type", data.getContentType());
        rb.setRequestData(data.getData());
        GwtXydraStoreRestClient.send(rb, req);
    }

    private static void send(RequestBuilder rb, AbstractXydraStoreRestClient.Request<?> req) {
        rb.setCallback((RequestCallback)new RestCallback(req));
        try {
            rb.send();
        }
        catch (RequestException re) {
            req.onFailure((Throwable)re);
        }
    }

    private static class RestCallback
    implements RequestCallback {
        protected final AbstractXydraStoreRestClient.Request<?> request;

        public RestCallback(AbstractXydraStoreRestClient.Request<?> request) {
            this.request = request;
        }

        public void onError(Request request, Throwable exception) {
            this.request.onFailure(exception);
        }

        public void onResponseReceived(Request request, Response response) {
            this.request.onResponse(response.getText(), response.getStatusCode(), response.getStatusText());
        }
    }
}

