/*
 * Decompiled with CFR 0.152.
 */
package de.xam.shell;

import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class Shell {
    private final CommandHandler handler;
    private final Console console;
    private final Writer w;
    private boolean shouldRun = true;

    public Shell(CommandHandler handler) throws UnsupportedEncodingException {
        this.handler = handler;
        this.console = System.console();
        this.w = new OutputStreamWriter((OutputStream)System.out, "utf-8");
    }

    public boolean openShell() throws IOException {
        System.out.print("> ");
        InputStreamReader r = new InputStreamReader(System.in, "utf-8");
        BufferedReader br = new BufferedReader(r);
        while (this.shouldRun) {
            if (br.ready()) {
                String line = br.readLine();
                if (line != null && (line.equals("q") || line.equals("quit") || line.equals("exit"))) {
                    this.shouldRun = false;
                    continue;
                }
                this.handleCommand(line);
                continue;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        System.out.println("Bye");
        return this.handler.handleExit();
    }

    public void handleCommand(String line) throws IOException {
        long now = System.nanoTime();
        boolean recognized = this.handler.handleCommand(line, this.w);
        if (!recognized) {
            this.w.write(" NOT UNDERSTOOD");
        }
        this.w.write(" (" + (System.nanoTime() - now) / 1000000L + "ms)\n> ");
        this.w.flush();
    }

    public void stop() {
        this.shouldRun = false;
        System.out.println("Shell terminated on request.");
    }

    public static interface CommandHandler {
        public boolean handleCommand(String var1, Writer var2) throws IOException;

        public boolean handleExit();
    }
}

