/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae.snapshot;

import com.google.common.cache.Cache;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.xydra.annotations.Setting;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.change.XEvent;
import org.xydra.base.rmof.XReadableModel;
import org.xydra.base.rmof.XRevWritableField;
import org.xydra.base.rmof.XRevWritableModel;
import org.xydra.base.rmof.XRevWritableObject;
import org.xydra.base.rmof.XWritableModel;
import org.xydra.base.rmof.impl.XExistsRevWritableModel;
import org.xydra.base.rmof.impl.memory.SimpleModel;
import org.xydra.base.util.DumpUtilsBase;
import org.xydra.core.XCopyUtils;
import org.xydra.core.change.EventUtils;
import org.xydra.core.serialize.SerializedModel;
import org.xydra.core.serialize.XydraElement;
import org.xydra.core.serialize.xml.XmlParser;
import org.xydra.index.iterator.Iterators;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.sharedutils.XyAssert;
import org.xydra.store.impl.gae.InstanceContext;
import org.xydra.store.impl.gae.Memcache;
import org.xydra.store.impl.gae.changes.IGaeChangesService;
import org.xydra.store.impl.gae.snapshot.AbstractGaeSnapshotServiceImpl;
import org.xydra.store.impl.utils.DebugFormatter;
import org.xydra.xgae.XGae;
import org.xydra.xgae.datastore.api.SEntity;
import org.xydra.xgae.datastore.api.SKey;
import org.xydra.xgae.datastore.api.SText;
import org.xydra.xgae.util.XGaeDebugHelper;

public class GaeSnapshotServiceImpl3
extends AbstractGaeSnapshotServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(GaeSnapshotServiceImpl3.class);
    private static final String KIND_SNAPSHOT = "XSNAPSHOT";
    private static final long MODEL_DOES_NOT_EXIST = -1L;
    private static final String PROP_XML = "xml";
    @Setting(value="")
    private static final boolean USE_MEMCACHE = true;
    private static final long STANDARD_DISTANCE = 10L;
    private final IGaeChangesService changesService;
    private final XAddress modelAddress;

    public GaeSnapshotServiceImpl3(IGaeChangesService changesService) {
        this.modelAddress = changesService.getModelAddress();
        this.changesService = changesService;
    }

    private boolean cacheResultIsConsistent(Map<String, Object> batchResult) {
        for (Map.Entry<String, Object> entry : batchResult.entrySet()) {
            XRevWritableModel value;
            String key = entry.getKey();
            boolean consistent = this.isConsistent(key, value = (XRevWritableModel)entry.getValue());
            if (consistent) continue;
            return false;
        }
        return true;
    }

    private XRevWritableModel computeSnapshot(long requestedRevNr) {
        XRevWritableModel base;
        log.debug("compute snapshot " + requestedRevNr);
        XyAssert.xyAssert((requestedRevNr >= 0L ? 1 : 0) != 0);
        Map<Object, Object> batchResult = Collections.emptyMap();
        LinkedList<String> requestKeys = new LinkedList<String>();
        long askNr = requestedRevNr - 1L;
        long askedRevs = 0L;
        Object snapshotfromMemcache = null;
        while (askNr >= 0L && askedRevs < 5L) {
            if (!GaeSnapshotServiceImpl3.revCanBeMemcached(--askNr) || askedRevs >= 5L) continue;
            String possiblyMemcachedKey = XGaeDebugHelper.toString((SKey)this.getSnapshotKey(askNr));
            requestKeys.add(possiblyMemcachedKey);
            ++askedRevs;
        }
        XyAssert.xyAssert((requestKeys.size() <= 5 ? 1 : 0) != 0, (String)"asking for %s keys", (Object[])new Object[]{requestKeys.size()});
        batchResult = Memcache.getEntities(requestKeys);
        XyAssert.xyAssert((batchResult.size() <= 5 ? 1 : 0) != 0, (String)"got %s results", (Object[])new Object[]{batchResult.size()});
        XyAssert.xyAssert((boolean)this.cacheResultIsConsistent(batchResult), (Object)"cache inconsistent, see logs");
        for (Map.Entry<Object, Object> entry : batchResult.entrySet()) {
            Object v = entry.getValue();
            if (v == null || v == Memcache.NULL_ENTITY) continue;
            snapshotfromMemcache = v;
            break;
        }
        if (snapshotfromMemcache == null) {
            log.debug("we start from scratch, nobody has ever saved a snapshot. Found no snapshots at " + Arrays.toString(requestKeys.toArray()));
            base = new SimpleModel(this.modelAddress);
            base.setRevisionNumber(-1L);
        } else {
            XyAssert.xyAssert((boolean)(snapshotfromMemcache instanceof XRevWritableModel));
            base = (XRevWritableModel)snapshotfromMemcache;
            XyAssert.xyAssert((boolean)base.getAddress().equals(this.modelAddress));
        }
        log.debug("compute from " + base.getRevisionNumber() + " up to " + requestedRevNr);
        return this.computeAndCacheSnapshotFromBase(requestedRevNr, base);
    }

    private XRevWritableModel computeAndCacheSnapshotFromBase(long requestedRevNr, XRevWritableModel base) {
        XyAssert.xyAssert((base != null ? 1 : 0) != 0);
        assert (base != null);
        XyAssert.xyAssert((boolean)this.modelAddress.equals(base.getAddress()));
        XRevWritableModel requestedSnapshot = this.computeSnapshotFromBase(base, requestedRevNr);
        return requestedSnapshot;
    }

    private XRevWritableModel computeSnapshotFromBase(XRevWritableModel base, long requestedRevNr) {
        XyAssert.xyAssert((base != null ? 1 : 0) != 0);
        assert (base != null);
        XyAssert.xyAssert((base.getRevisionNumber() < requestedRevNr ? 1 : 0) != 0, (Object)"otherwise it makes no sense to compute it");
        XyAssert.xyAssert((requestedRevNr > 0L ? 1 : 0) != 0);
        XRevWritableModel snapshot = base;
        XyAssert.xyAssert((requestedRevNr > snapshot.getRevisionNumber() ? 1 : 0) != 0);
        log.debug("Compute snapshot of model '" + this.modelAddress + "' from rev=" + snapshot.getRevisionNumber() + " to rev=" + requestedRevNr);
        long start = Math.max(snapshot.getRevisionNumber() + 1L, 0L);
        List<XEvent> events = this.changesService.getEventsBetween(this.modelAddress, start, requestedRevNr);
        if (events == null) {
            log.warn("There are no events for " + this.modelAddress + " in range [" + start + "," + requestedRevNr + "]");
        }
        assert (events != null);
        long memcachedSnapshots = 0L;
        for (XEvent event : events) {
            log.debug("Basemodel[" + snapshot.getRevisionNumber() + "], applying event[" + event.getRevisionNumber() + "]=" + DebugFormatter.format((Object)event));
            long rev = (snapshot = EventUtils.applyEventNonDestructive((XRevWritableModel)snapshot, (XEvent)event)).getRevisionNumber();
            if (!GaeSnapshotServiceImpl3.revCanBeMemcached(rev) || memcachedSnapshots >= 10L) continue;
            SKey key = this.getSnapshotKey(rev);
            Memcache.put(key, snapshot);
            ++memcachedSnapshots;
            XyAssert.xyAssert((boolean)this.isConsistent(XGaeDebugHelper.toString((SKey)key), snapshot));
        }
        XyAssert.xyAssert((snapshot.getRevisionNumber() == requestedRevNr ? 1 : 0) != 0);
        SKey key = this.getSnapshotKey(requestedRevNr);
        Memcache.put(key, snapshot);
        XyAssert.xyAssert((boolean)this.isConsistent(XGaeDebugHelper.toString((SKey)key), snapshot));
        return snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortedMap<Long, XRevWritableModel> getModelSnapshotsCache() {
        TreeMap<Long, XRevWritableModel> modelSnapshotsCache;
        Cache<String, Object> instanceCache;
        String key = "snapshots:" + this.changesService.getModelAddress();
        Cache<String, Object> cache = instanceCache = InstanceContext.getInstanceCache();
        synchronized (cache) {
            modelSnapshotsCache = (TreeMap<Long, XRevWritableModel>)instanceCache.getIfPresent((Object)key);
            if (modelSnapshotsCache == null) {
                log.debug("localVmcache for snapshots missing, creating one");
                modelSnapshotsCache = new TreeMap<Long, XRevWritableModel>();
                instanceCache.put((Object)key, modelSnapshotsCache);
            } else if (modelSnapshotsCache.size() > 100) {
                modelSnapshotsCache.clear();
            }
        }
        return modelSnapshotsCache;
    }

    public synchronized XRevWritableModel getModelSnapshot(long requestedRevNr) {
        log.debug("Get snapshot " + this.modelAddress + " rev " + requestedRevNr);
        return this.createModelSnapshot(requestedRevNr);
    }

    private XRevWritableModel createModelSnapshot(long requestedRevNr) {
        XRevWritableModel snapshot = this.getSnapshotFromMemcacheOrDatastore(requestedRevNr);
        return snapshot;
    }

    private synchronized XRevWritableModel getSnapshotFromMemcacheOrDatastore(long requestedRevNr) {
        XyAssert.xyAssert((requestedRevNr > 0L ? 1 : 0) != 0);
        log.debug("getSnapshotFromMemcacheOrDatastore " + requestedRevNr);
        SKey snapshotKey = this.getSnapshotKey(requestedRevNr);
        Object o = null;
        o = Memcache.get(snapshotKey);
        if (o != null) {
            log.debug("return from memcache");
            if (o.equals(Memcache.NULL_ENTITY)) {
                return null;
            }
            XyAssert.xyAssert((boolean)this.isConsistent(XGaeDebugHelper.toString((SKey)snapshotKey), (XRevWritableModel)o));
            XRevWritableModel snapshot = (XRevWritableModel)o;
            XyAssert.xyAssert((snapshot.getRevisionNumber() == requestedRevNr ? 1 : 0) != 0);
            return snapshot;
        }
        SEntity e = XGae.get().datastore().sync().getEntity(snapshotKey);
        if (e != null) {
            log.debug("return from datastore");
            SText xmlText = (SText)e.getAttribute(PROP_XML);
            if (xmlText == null) {
                return null;
            }
            String xml = xmlText.getValue();
            XydraElement snapshotXml = new XmlParser().parse(xml);
            XExistsRevWritableModel snapshot = SerializedModel.toModelState((XydraElement)snapshotXml, (XAddress)this.modelAddress);
            return snapshot;
        }
        XRevWritableModel snapshot = this.computeSnapshot(requestedRevNr);
        return snapshot;
    }

    private static boolean revCanBeMemcached(long requestedRevNr) {
        return requestedRevNr % 10L == 0L;
    }

    private synchronized SKey getSnapshotKey(long revNr) {
        return XGae.get().datastore().createKey(KIND_SNAPSHOT, this.modelAddress.toURI() + "/" + revNr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized XRevWritableModel getModelSnapshotNewerOrAtRevision(long revisionNumber) {
        SortedMap<Long, XRevWritableModel> matchOrNewer;
        SortedMap<Long, XRevWritableModel> modelSnapshotsCache;
        SortedMap<Long, XRevWritableModel> sortedMap = modelSnapshotsCache = this.getModelSnapshotsCache();
        synchronized (sortedMap) {
            matchOrNewer = modelSnapshotsCache.subMap(revisionNumber, Long.MAX_VALUE);
        }
        if (matchOrNewer.isEmpty()) {
            return this.createModelSnapshot(revisionNumber);
        }
        XRevWritableModel cached = matchOrNewer.values().iterator().next();
        XyAssert.xyAssert((cached.getRevisionNumber() >= revisionNumber ? 1 : 0) != 0);
        log.debug("re-using locamVmCache with revNr " + cached.getRevisionNumber() + " for " + revisionNumber);
        return cached;
    }

    private boolean isConsistent(String key, XRevWritableModel value) {
        String generatedKey = XGaeDebugHelper.toString((SKey)this.getSnapshotKey(value.getRevisionNumber()));
        if (!key.equals(generatedKey)) {
            log.warn("entry.key = " + key + " vs. gen.key = " + generatedKey);
            return false;
        }
        return true;
    }

    @Override
    public XRevWritableModel getModelSnapshot(long requestedRevNr, boolean precise) {
        if (requestedRevNr == -1L) {
            return null;
        }
        if (requestedRevNr == 0L) {
            return new SimpleModel(this.modelAddress);
        }
        if (precise) {
            return XCopyUtils.createSnapshot((XReadableModel)this.getModelSnapshot(requestedRevNr));
        }
        return XCopyUtils.createSnapshot((XReadableModel)this.getModelSnapshotNewerOrAtRevision(requestedRevNr));
    }

    @Override
    public XAddress getModelAddress() {
        return this.modelAddress;
    }

    @Override
    public XRevWritableModel getPartialSnapshot(long snapshotRev, Iterable<XAddress> locks) {
        log.debug("getPartialSnapshot[" + snapshotRev + "]");
        if (snapshotRev == -1L) {
            return null;
        }
        if (snapshotRev == 0L) {
            return new SimpleModel(this.modelAddress);
        }
        if (Iterators.isEmpty(locks)) {
            return null;
        }
        Iterator<XAddress> it = locks.iterator();
        if (it.next().equals(this.getModelAddress())) {
            XyAssert.xyAssert((!it.hasNext() ? 1 : 0) != 0);
            return this.getModelSnapshot(snapshotRev, true);
        }
        XRevWritableModel fullModel = this.getModelSnapshot(snapshotRev);
        SimpleModel partialModel = new SimpleModel(this.getModelAddress());
        for (XAddress lock : locks) {
            switch (lock.getAddressedType()) {
                case XREPOSITORY: {
                    throw new AssertionError((Object)"Encountered REPO lock while computing partial snapshot");
                }
                case XMODEL: {
                    throw new AssertionError((Object)"Encountered MODEL lock - was processed already");
                }
                case XOBJECT: {
                    XRevWritableObject fullObject = fullModel.getObject(lock.getObject());
                    if (fullObject == null) {
                        log.info("Locking an object not yet present in snapshot: " + lock);
                        break;
                    }
                    partialModel.addObject(fullObject);
                    break;
                }
                case XFIELD: {
                    XId oid = lock.getObject();
                    XRevWritableObject partialObject = partialModel.createObject(oid);
                    partialObject.setRevisionNumber(-20L);
                    XRevWritableField fullField = fullModel.getObject(oid).getField(lock.getField());
                    if (fullField == null) {
                        log.info("Locking a field not yet present in snapshot: " + lock);
                        break;
                    }
                    partialObject.addField(fullField);
                    break;
                }
            }
        }
        log.debug("Partial snapshot: " + DumpUtilsBase.toStringBuffer((XReadableModel)partialModel));
        return partialModel;
    }

    @Override
    public XWritableModel getTentativeModelSnapshot(long currentRevNr) {
        return this.getModelSnapshot(currentRevNr, false);
    }
}

