/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae.ng;

import java.util.LinkedList;
import org.xydra.base.XId;
import org.xydra.base.XType;
import org.xydra.base.change.ChangeType;
import org.xydra.base.change.XAtomicCommand;
import org.xydra.base.change.XCommand;
import org.xydra.base.change.XFieldCommand;
import org.xydra.base.change.XModelCommand;
import org.xydra.base.change.XObjectCommand;
import org.xydra.base.change.XRepositoryCommand;
import org.xydra.base.change.XTransaction;
import org.xydra.base.rmof.XRevWritableField;
import org.xydra.base.rmof.XStateWritableField;
import org.xydra.base.rmof.XStateWritableObject;
import org.xydra.base.value.XValue;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.sharedutils.ReflectionUtils;
import org.xydra.sharedutils.XyAssert;
import org.xydra.store.impl.gae.changes.GaeChange;
import org.xydra.store.impl.gae.ng.CheckResult;
import org.xydra.store.impl.gae.ng.ContextBeforeCommand;
import org.xydra.store.impl.gae.ng.ContextInTxn;
import org.xydra.store.impl.gae.ng.GaeModelRevInfo;
import org.xydra.store.impl.gae.ng.TentativeObjectState;

public class Executor {
    private static final Logger log = LoggerFactory.getLogger(Executor.class);

    private static CheckResult checkAtomic(XAtomicCommand command, GaeChange change, boolean inTransaction, ContextBeforeCommand ctxBeforeCmd, ContextInTxn ctxInTxn) {
        XyAssert.xyAssert((ctxBeforeCmd != null ? 1 : 0) != 0);
        assert (ctxBeforeCmd != null);
        switch (command.getTarget().getAddressedType()) {
            case XREPOSITORY: {
                return Executor.checkRepositoryCommand((XRepositoryCommand)command, change, ctxBeforeCmd, ctxInTxn);
            }
            case XMODEL: {
                return Executor.checkModelCommand((XModelCommand)command, change, ctxBeforeCmd, ctxInTxn, inTransaction);
            }
            case XOBJECT: {
                return Executor.checkObjectCommand((XObjectCommand)command, change, ctxBeforeCmd, ctxInTxn, inTransaction);
            }
            case XFIELD: {
                return Executor.checkFieldCommand((XFieldCommand)command, change, ctxBeforeCmd, ctxInTxn, inTransaction);
            }
        }
        throw new AssertionError((Object)"Cannot happen");
    }

    private static CheckResult checkFieldCommand(XFieldCommand command, GaeChange change, ContextBeforeCommand ctxBeforeCmd, ContextInTxn ctxInTxn, boolean inTransaction) {
        if (!ctxInTxn.exists()) {
            return CheckResult.failed("Model '" + command.getModelId() + "' does not exist");
        }
        XId objectId = command.getChangedEntity().getObject();
        XStateWritableObject objectInTxn = ctxInTxn.getObject(objectId);
        if (objectInTxn == null) {
            return CheckResult.failed("Object '" + objectId + "' does not exist, no field command can succeed");
        }
        XStateWritableField fieldInTxn = objectInTxn.getField(command.getFieldId());
        if (fieldInTxn == null) {
            return CheckResult.failed("Command { " + command + "} is invalid. Field '" + command.getFieldId() + "' not found in object '" + command.getObjectId() + ", no field command can succeed");
        }
        boolean valueExists = !fieldInTxn.isEmpty();
        switch (command.getChangeType()) {
            case ADD: {
                if (valueExists) {
                    if (command.getIntent() == XAtomicCommand.Intent.Forced) {
                        boolean sameValue;
                        XValue oldValueInTxn = fieldInTxn.getValue();
                        XValue newValue = command.getValue();
                        XyAssert.xyAssert((newValue != null ? 1 : 0) != 0);
                        boolean bl = sameValue = oldValueInTxn != null && oldValueInTxn.equals(newValue);
                        if (sameValue) {
                            return CheckResult.successNoChange("had already the same value");
                        }
                        return CheckResult.successValue(command, change, ctxInTxn, inTransaction);
                    }
                    return CheckResult.failed("Could not safely add field value, there was already one");
                }
                if (command.getIntent() == XAtomicCommand.Intent.SafeRevBound) {
                    long fieldRevBeforeCmd = Executor.getFieldRevBeforeCmd(ctxBeforeCmd, objectId, command.getFieldId());
                    if (command.getRevisionNumber() != fieldRevBeforeCmd) {
                        return CheckResult.failed("Expected revNr " + command.getRevisionNumber() + " but found " + fieldRevBeforeCmd);
                    }
                }
                return CheckResult.successValue(command, change, ctxInTxn, inTransaction);
            }
            case REMOVE: {
                if (!valueExists) {
                    if (command.getIntent() == XAtomicCommand.Intent.Forced) {
                        return CheckResult.successNoChange("was empty before, nothing to remove");
                    }
                    return CheckResult.failed("Could not safely remove field value, there was none");
                }
                if (command.getIntent() == XAtomicCommand.Intent.SafeRevBound) {
                    long fieldRevBeforeCmd = Executor.getFieldRevBeforeCmd(ctxBeforeCmd, objectId, command.getFieldId());
                    if (command.getRevisionNumber() != fieldRevBeforeCmd) {
                        return CheckResult.failed("Expected revNr " + command.getRevisionNumber() + " but found " + fieldRevBeforeCmd);
                    }
                }
                return CheckResult.successValue(command, change, ctxInTxn, inTransaction);
            }
            case CHANGE: {
                if (!valueExists) {
                    if (command.getIntent() == XAtomicCommand.Intent.Forced) {
                        return CheckResult.successValue(command, change, ctxInTxn, inTransaction);
                    }
                    return CheckResult.failed("Could not safely change field value, there was none");
                }
                if (command.getIntent() == XAtomicCommand.Intent.Forced) {
                    boolean sameValue;
                    XValue oldValueInTxn = fieldInTxn.getValue();
                    XValue newValue = command.getValue();
                    XyAssert.xyAssert((newValue != null ? 1 : 0) != 0);
                    boolean bl = sameValue = oldValueInTxn != null && oldValueInTxn.equals(newValue);
                    if (sameValue) {
                        return CheckResult.successNoChange("had already the same value");
                    }
                    return CheckResult.successValue(command, change, ctxInTxn, inTransaction);
                }
                if (command.getIntent() == XAtomicCommand.Intent.SafeRevBound) {
                    long fieldRevBeforeCmd = Executor.getFieldRevBeforeCmd(ctxBeforeCmd, objectId, command.getFieldId());
                    if (command.getRevisionNumber() != fieldRevBeforeCmd) {
                        return CheckResult.failed("Expected revNr " + command.getRevisionNumber() + " but found " + fieldRevBeforeCmd);
                    }
                }
                return CheckResult.successValue(command, change, ctxInTxn, inTransaction);
            }
        }
        throw new AssertionError((Object)"illegal command");
    }

    private static long getFieldRevBeforeCmd(ContextBeforeCommand ctxBeforeCmd, XId objectId, XId fieldId) {
        XRevWritableField fieldBeforeCmd;
        TentativeObjectState objectBeforeCmd = ctxBeforeCmd.getObject(objectId);
        long fieldRevBeforeCmd = objectBeforeCmd == null ? ctxBeforeCmd.getRevisionNumber() : ((fieldBeforeCmd = objectBeforeCmd.getField(fieldId)) == null ? objectBeforeCmd.getRevisionNumber() : fieldBeforeCmd.getRevisionNumber());
        return fieldRevBeforeCmd;
    }

    private static long getObjectRevBeforeCmd(ContextBeforeCommand ctxBeforeCmd, XId objectId) {
        TentativeObjectState objectBeforeCmd = ctxBeforeCmd.getObject(objectId);
        long objectRevBeforeCmd = objectBeforeCmd == null ? ctxBeforeCmd.getRevisionNumber() : objectBeforeCmd.getRevisionNumber();
        return objectRevBeforeCmd;
    }

    private static long getModelRevBeforeCmd(ContextBeforeCommand ctxBeforeCmd) {
        return ctxBeforeCmd.getRevisionNumber();
    }

    private static CheckResult checkModelCommand(XModelCommand command, GaeChange change, ContextBeforeCommand ctxBeforeCmd, ContextInTxn ctxInTxn, boolean inTransaction) {
        if (!ctxInTxn.exists()) {
            return CheckResult.failed("Model '" + command.getModelId() + "' does not exist");
        }
        XId objectId = command.getChangedEntity().getObject();
        boolean objectExists = ctxInTxn.hasObject(objectId);
        switch (command.getChangeType()) {
            case ADD: {
                if (objectExists) {
                    switch (command.getIntent()) {
                        case Forced: {
                            return CheckResult.successNoChange("objectExists " + command.getChangedEntity());
                        }
                        case SafeStateBound: 
                        case SafeRevBound: {
                            return CheckResult.failed("objectExists " + command.getChangedEntity());
                        }
                    }
                    throw new AssertionError();
                }
                if (command.getIntent() == XAtomicCommand.Intent.SafeRevBound && command.getIntent() == XAtomicCommand.Intent.SafeRevBound) {
                    long modelRevBeforeCmd = Executor.getModelRevBeforeCmd(ctxBeforeCmd);
                    if (command.getRevisionNumber() != modelRevBeforeCmd) {
                        return CheckResult.failed("ModelRevision number expected " + command.getRevisionNumber() + " but found " + modelRevBeforeCmd);
                    }
                }
                return CheckResult.successCreatedObject(command, change, ctxInTxn, inTransaction);
            }
            case REMOVE: {
                if (!objectExists) {
                    switch (command.getIntent()) {
                        case Forced: {
                            return CheckResult.successNoChange("!tos.objectExists");
                        }
                        case SafeStateBound: 
                        case SafeRevBound: {
                            return CheckResult.failed("!objectExists");
                        }
                    }
                    throw new AssertionError();
                }
                if (command.getIntent() == XAtomicCommand.Intent.SafeRevBound) {
                    long objectRevBeforeCmd = Executor.getObjectRevBeforeCmd(ctxBeforeCmd, objectId);
                    if (command.getRevisionNumber() != objectRevBeforeCmd) {
                        return CheckResult.failed("ObjectRevision number expected " + command.getRevisionNumber() + " but found " + objectRevBeforeCmd);
                    }
                }
                return CheckResult.successRemovedObject(command, change, ctxInTxn, inTransaction);
            }
        }
        throw new AssertionError((Object)("impossible type for model command " + command));
    }

    private static CheckResult checkObjectCommand(XObjectCommand command, GaeChange change, ContextBeforeCommand ctxBeforeCmd, ContextInTxn ctxInTxn, boolean inTransaction) {
        if (!ctxInTxn.exists()) {
            return CheckResult.failed("Model '" + command.getModelId() + "' does not exist");
        }
        XId objectId = command.getChangedEntity().getObject();
        XId fieldId = command.getFieldId();
        XStateWritableObject objectInTxn = ctxInTxn.getObject(objectId);
        boolean fieldExists = objectInTxn.hasField(fieldId);
        switch (command.getChangeType()) {
            case ADD: {
                if (fieldExists) {
                    if (command.getIntent() == XAtomicCommand.Intent.Forced) {
                        return CheckResult.successNoChange("tos '" + objectInTxn.getAddress() + "' hasField '" + fieldId + "'");
                    }
                    return CheckResult.failed("tos '" + objectInTxn.getAddress() + "' hasField '" + fieldId + "'");
                }
                if (command.getIntent() == XAtomicCommand.Intent.SafeRevBound) {
                    long objectRevBeforeCmd = Executor.getObjectRevBeforeCmd(ctxBeforeCmd, objectId);
                    if (command.getRevisionNumber() != objectRevBeforeCmd) {
                        return CheckResult.failed("Revision number expected " + command.getRevisionNumber() + " but found " + objectRevBeforeCmd);
                    }
                }
                return CheckResult.successCreatedField(command, ctxBeforeCmd.getRevisionNumber(), ctxInTxn, change, inTransaction);
            }
            case REMOVE: {
                if (!fieldExists) {
                    if (command.getIntent() == XAtomicCommand.Intent.Forced) {
                        return CheckResult.successNoChange("tos '" + objectInTxn.getAddress() + "' hasField '" + fieldId + "'");
                    }
                    return CheckResult.failed("tos '" + objectInTxn.getAddress() + "' has no field '" + fieldId + "'");
                }
                if (command.getIntent() == XAtomicCommand.Intent.SafeRevBound) {
                    long fieldRevBeforeCmd = Executor.getFieldRevBeforeCmd(ctxBeforeCmd, objectId, fieldId);
                    if (command.getRevisionNumber() != fieldRevBeforeCmd) {
                        return CheckResult.failed("FieldRevision number expected " + command.getRevisionNumber() + " but found " + fieldRevBeforeCmd);
                    }
                }
                return CheckResult.successRemovedField(command, change, ctxInTxn, inTransaction);
            }
        }
        throw new AssertionError((Object)("impossible type for object command " + command));
    }

    static CheckResult checkPreconditions(ContextBeforeCommand executionContext, XCommand command, GaeChange change) {
        ContextInTxn inTxnContext = executionContext.forkTxn();
        CheckResult result = command.getChangeType() == ChangeType.TRANSACTION ? Executor.checkTransaction((XTransaction)command, change, executionContext, inTxnContext) : (command.getTarget().getAddressedType() == XType.XREPOSITORY ? Executor.checkRepositoryCommand((XRepositoryCommand)command, change, executionContext, inTxnContext) : Executor.checkAtomic((XAtomicCommand)command, change, false, executionContext, inTxnContext));
        if (result.getStatus() == GaeChange.Status.FailedPreconditions) {
            log.debug("Status=" + (Object)((Object)result.getStatus()) + " hint: " + result.getDebugHint());
        }
        return result;
    }

    private static CheckResult checkRepositoryCommand(XRepositoryCommand repoCmd, GaeChange change, ContextBeforeCommand ctxBeforeCmd, ContextInTxn ctxInTxn) {
        GaeModelRevInfo infoBeforeCmd = ctxBeforeCmd.getInfo();
        boolean modelExistsBeforeCmd = infoBeforeCmd.isModelExists();
        switch (repoCmd.getChangeType()) {
            case ADD: {
                if (!ctxInTxn.exists()) {
                    long modelRevBeforeCmd;
                    if (repoCmd.getIntent() == XAtomicCommand.Intent.SafeRevBound && (modelRevBeforeCmd = infoBeforeCmd.getLastStableSuccessChange()) != repoCmd.getRevisionNumber()) {
                        return CheckResult.failed("SafeRevBound RepositoryCommand ADD failed. Reason: modelRevNr=" + modelRevBeforeCmd + " cmdRevNr=" + repoCmd.getRevisionNumber());
                    }
                    return CheckResult.successCreatedModel(repoCmd, change, ctxInTxn);
                }
                if (repoCmd.isForced()) {
                    return CheckResult.successNoChange("Model exists");
                }
                return CheckResult.failed("Safe RepositoryCommand ADD failed; model existed already");
            }
            case REMOVE: {
                long modelRevBeforeCmd = infoBeforeCmd.getLastStableSuccessChange();
                if (!modelExistsBeforeCmd) {
                    if (repoCmd.getIntent() == XAtomicCommand.Intent.Forced) {
                        return CheckResult.successNoChange("Model did not exist");
                    }
                    return CheckResult.failed("Safe-X RepositoryCommand REMOVE failed. Reason: model did not exist; modelRevNr=" + modelRevBeforeCmd + " cmdRevNr=" + repoCmd.getRevisionNumber() + " intent:" + repoCmd.getIntent());
                }
                assert (modelExistsBeforeCmd);
                if (repoCmd.getIntent() == XAtomicCommand.Intent.SafeRevBound && modelRevBeforeCmd != repoCmd.getRevisionNumber()) {
                    return CheckResult.failed("SafeRevBound RepositoryCommand REMOVE failed. Reason: modelRevNr=" + modelRevBeforeCmd + " cmdRevNr=" + repoCmd.getRevisionNumber());
                }
                log.debug("Removing model " + repoCmd.getChangedEntity() + " " + modelRevBeforeCmd);
                return CheckResult.successRemovedModel(repoCmd, change, ctxInTxn);
            }
        }
        throw new AssertionError((Object)("XRepositoryCommand with unexpected type: " + repoCmd));
    }

    private static CheckResult checkTransaction(XTransaction transaction, GaeChange change, ContextBeforeCommand ctxBeforeCmd, ContextInTxn ctxInTxn) {
        LinkedList<CheckResult> results = new LinkedList<CheckResult>();
        for (int i = 0; i < transaction.size(); ++i) {
            XAtomicCommand command = transaction.getCommand(i);
            try {
                CheckResult atomicResult = Executor.checkAtomic(command, change, true, ctxBeforeCmd, ctxInTxn);
                if (atomicResult.getStatus().isFailure()) {
                    return CheckResult.failed("txn failed at command " + command + " Reason: " + atomicResult.getDebugHint());
                }
                results.add(atomicResult);
                continue;
            }
            catch (Throwable e) {
                log.warn("Txn failed on exception", e);
                return CheckResult.failed("txn failed at command " + command + " Reason: " + e.getClass().getName() + ": " + ReflectionUtils.firstNLines((Throwable)e, (int)200));
            }
        }
        return CheckResult.successTransaction(transaction, change, ctxInTxn);
    }
}

