/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae.ng;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.XType;
import org.xydra.base.change.XAtomicEvent;
import org.xydra.base.rmof.XReadableModel;
import org.xydra.base.rmof.XReadableObject;
import org.xydra.base.rmof.XStateWritableModel;
import org.xydra.base.rmof.XStateWritableObject;
import org.xydra.base.rmof.impl.XExists;
import org.xydra.core.model.delta.ChangedModel;
import org.xydra.core.model.delta.ChangedObject;
import org.xydra.core.model.delta.DeltaUtils;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.sharedutils.XyAssert;
import org.xydra.store.impl.gae.ng.ContextBeforeCommand;

public class ContextInTxn
implements XStateWritableModel,
XExists {
    private static final Logger log = LoggerFactory.getLogger(ContextInTxn.class);
    private final ChangedModel changedModel;

    public XStateWritableObject createObject(XId objectId) {
        return this.changedModel.createObject(objectId);
    }

    public XAddress getAddress() {
        return this.changedModel.getAddress();
    }

    public XId getId() {
        return this.changedModel.getId();
    }

    public boolean hasObject(XId objectId) {
        return this.changedModel.hasObject(objectId);
    }

    public XStateWritableObject getObject(XId objectId) {
        return this.changedModel.getObject(objectId);
    }

    public boolean isEmpty() {
        return this.changedModel.isEmpty();
    }

    public Iterator<XId> iterator() {
        return this.changedModel.iterator();
    }

    public XType getType() {
        return this.changedModel.getType();
    }

    public boolean removeObject(XId objectId) {
        return this.changedModel.removeObject(objectId);
    }

    public ContextInTxn(ContextBeforeCommand ctxBeforeCmd) {
        XyAssert.xyAssert((ctxBeforeCmd != null ? 1 : 0) != 0);
        assert (ctxBeforeCmd != null);
        this.changedModel = new ChangedModel((XReadableModel)ctxBeforeCmd);
        assert (this.changedModel.exists() == ctxBeforeCmd.exists());
        log.trace("At context creation time model '" + this.changedModel.getAddress() + "' exists: " + this.changedModel.exists());
    }

    public boolean hasChanges() {
        return this.changedModel.hasChanges();
    }

    public void setExists(boolean modelExists) {
        this.changedModel.setExists(modelExists);
    }

    public boolean exists() {
        return this.changedModel.exists();
    }

    public List<XAtomicEvent> toEvents(XId actorId, ContextBeforeCommand ctxBeforeCommand, boolean inTransaction) {
        XyAssert.xyAssert((this.getAddress() != null ? 1 : 0) != 0);
        ArrayList<XAtomicEvent> events = new ArrayList<XAtomicEvent>();
        boolean inTxn = inTransaction || this.changedModel.countCommandsNeeded(2) > 1;
        DeltaUtils.createEventsForChangedModel(events, (XId)actorId, (ChangedModel)this.changedModel, (inTxn || this.changedModel.modelWasRemoved() ? 1 : 0) != 0);
        return events;
    }

    public Collection<? extends XReadableObject> getAdded() {
        return this.changedModel.getAdded();
    }

    public Collection<XId> getRemoved() {
        return this.changedModel.getRemoved();
    }

    public Iterable<ChangedObject> getChanged() {
        return this.changedModel.getChangedObjects();
    }
}

