/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae.ng;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xydra.annotations.Setting;
import org.xydra.base.Base;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.XType;
import org.xydra.base.rmof.XReadableModel;
import org.xydra.base.rmof.XReadableObject;
import org.xydra.base.rmof.XRevWritableModel;
import org.xydra.base.rmof.XRevWritableObject;
import org.xydra.base.rmof.impl.XExistsReadable;
import org.xydra.base.rmof.impl.memory.SimpleObject;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.sharedutils.XyAssert;
import org.xydra.store.impl.gae.UniCache;
import org.xydra.store.impl.gae.ng.ContextInTxn;
import org.xydra.store.impl.gae.ng.GaeModelRevInfo;
import org.xydra.store.impl.gae.ng.TentativeObjectState;
import org.xydra.store.impl.gae.ng.TosUtils;
import org.xydra.store.impl.gae.snapshot.IGaeSnapshotService;
import org.xydra.xgae.XGae;
import org.xydra.xgae.datastore.api.SEntity;
import org.xydra.xgae.datastore.api.SKey;
import org.xydra.xgae.datastore.api.SPreparedQuery;

public class ContextBeforeCommand
implements XRevWritableModel,
UniCache.CacheEntryHandler<TentativeObjectState>,
XExistsReadable {
    private static final Logger log = LoggerFactory.getLogger(ContextBeforeCommand.class);
    private final IGaeSnapshotService snapshotService;
    private final GaeModelRevInfo info;
    public static final String KIND_TOS = "TOS";
    UniCache<TentativeObjectState> tosCache = new UniCache<TentativeObjectState>(this, "TOS");
    private final XAddress modelAddress;
    @Setting(value="Where to cache TOS")
    private final UniCache.StorageOptions storeOpts = UniCache.StorageOptions.create(0, false, true, false);

    public ContextBeforeCommand(XAddress modelAddress, GaeModelRevInfo info, IGaeSnapshotService snapshotService) {
        this.modelAddress = modelAddress;
        this.info = info;
        this.snapshotService = snapshotService;
    }

    public XReadableModel getModelSnapshot() {
        long modelRev = this.getInfo().getLastSuccessChange();
        XRevWritableModel modelSnapshot = this.snapshotService.getModelSnapshot(modelRev, false);
        return modelSnapshot;
    }

    public ContextInTxn forkTxn() {
        return new ContextInTxn(this);
    }

    public GaeModelRevInfo getInfo() {
        return this.info;
    }

    private static XAddress fromKey(SKey key) {
        String localName = key.getName();
        XyAssert.xyAssert((boolean)localName.startsWith("tos"));
        localName = localName.substring("tos".length());
        XAddress address = Base.toAddress((String)localName);
        return address;
    }

    private static String toKey(XAddress objectOrModelAddress) {
        return "tos" + objectOrModelAddress;
    }

    @Override
    public TentativeObjectState fromEntity(SEntity entity) {
        return TosUtils.fromEntity_static(entity, this.modelAddress);
    }

    @Override
    public TentativeObjectState fromSerializable(Serializable s) {
        return (TentativeObjectState)s;
    }

    public static List<TentativeObjectState> getAllTentativeObjectStatesOfModel(XAddress modelAddress) {
        String keyPrefix = "tos/" + modelAddress.getRepository() + "/" + modelAddress.getModel();
        SPreparedQuery preparedQuery = XGae.get().datastore().sync().prepareRangeQuery(KIND_TOS, false, keyPrefix, keyPrefix + "\uffff");
        log.info("Firing query " + preparedQuery.toString());
        preparedQuery.setChunkSize(128);
        List entityList = preparedQuery.asList();
        ArrayList<TentativeObjectState> tosList = new ArrayList<TentativeObjectState>(entityList.size());
        log.info("got " + entityList.size() + " results");
        for (SEntity entity : entityList) {
            TentativeObjectState tos = TosUtils.fromEntity_static(entity, modelAddress);
            tosList.add(tos);
        }
        return tosList;
    }

    TentativeObjectState getTentativeObjectState(XId objectId) {
        XAddress objectAddress = Base.resolveObject((XAddress)this.modelAddress, (XId)objectId);
        String key = ContextBeforeCommand.toKey(objectAddress);
        TentativeObjectState tos = this.tosCache.get(key, this.storeOpts);
        if (tos == null) {
            long tentativeModelRev = this.getInfo().getLastSuccessChange();
            SimpleObject simpleObject = new SimpleObject(objectAddress);
            simpleObject.setRevisionNumber(tentativeModelRev);
            tos = new TentativeObjectState((XReadableObject)simpleObject, false, tentativeModelRev);
            this.saveTentativeObjectState(tos);
        }
        return tos;
    }

    void saveTentativeObjectState(TentativeObjectState tos) {
        XyAssert.xyAssert((tos != null ? 1 : 0) != 0);
        assert (tos != null);
        String key = ContextBeforeCommand.toKey(tos.getAddress());
        this.tosCache.put(key, tos, this.storeOpts);
    }

    @Override
    public SEntity toEntity(SKey datastoreKey, TentativeObjectState tos) {
        return TosUtils.toEntity(datastoreKey, tos);
    }

    @Override
    public Serializable toSerializable(TentativeObjectState entry) {
        return entry;
    }

    public long getRevisionNumber() {
        return this.getInfo().getLastSuccessChange();
    }

    public boolean hasObject(XId objectId) {
        return this.getObject(objectId) != null;
    }

    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    public Iterator<XId> iterator() {
        return this.snapshotService.getModelSnapshot(this.getRevisionNumber(), false).iterator();
    }

    public XType getType() {
        return XType.XMODEL;
    }

    public XAddress getAddress() {
        return this.modelAddress;
    }

    public XId getId() {
        return this.getAddress().getModel();
    }

    public boolean removeObject(XId objectId) {
        TentativeObjectState tos = this.getTentativeObjectState(objectId);
        tos.setObjectExists(false);
        tos.setModelRev(this.getRevisionNumber());
        this.saveTentativeObjectState(tos);
        return true;
    }

    public void addObject(XRevWritableObject object) {
        TentativeObjectState tos = this.getTentativeObjectState(object.getId());
        tos.setObjectExists(true);
        tos.setObjectState((XReadableObject)object);
        tos.setModelRev(this.getRevisionNumber());
        this.saveTentativeObjectState(tos);
    }

    public TentativeObjectState createObject(XId objectId) {
        TentativeObjectState object = this.getObject(objectId);
        if (object == null) {
            SimpleObject simpleObject = new SimpleObject(this.getObjectAddress(objectId));
            object = new TentativeObjectState((XReadableObject)simpleObject, true, this.getRevisionNumber());
        } else {
            object.setObjectExists(true);
            object.setModelRev(this.getRevisionNumber());
        }
        this.saveTentativeObjectState(object);
        return object;
    }

    private XAddress getObjectAddress(XId objectId) {
        return Base.resolveObject((XAddress)this.getAddress(), (XId)objectId);
    }

    public TentativeObjectState getObject(XId objectId) {
        TentativeObjectState tos = this.getTentativeObjectState(objectId);
        if (tos == null) {
            return null;
        }
        if (!tos.exists()) {
            return null;
        }
        return tos;
    }

    public void setRevisionNumber(long rev) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "ctxBefore @" + this.modelAddress + " r" + this.getRevisionNumber();
    }

    public boolean exists() {
        return this.getInfo().isModelExists();
    }
}

