/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae.execute;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.concurrent.Future;
import org.xydra.base.Base;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.XType;
import org.xydra.base.rmof.XReadableObject;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.store.impl.gae.changes.GaeLocks;
import org.xydra.store.impl.gae.changes.IGaeChangesService;
import org.xydra.store.impl.gae.changes.KeyStructure;
import org.xydra.store.impl.gae.execute.InternalGaeContainerXEntity;
import org.xydra.store.impl.gae.execute.InternalGaeField;
import org.xydra.xgae.XGae;
import org.xydra.xgae.datastore.api.IDatastoreSync;
import org.xydra.xgae.datastore.api.SEntity;
import org.xydra.xgae.datastore.api.SKey;
import org.xydra.xgae.datastore.api.STransaction;

class InternalGaeObject
extends InternalGaeContainerXEntity<InternalGaeField>
implements XReadableObject {
    private static final Logger log = LoggerFactory.getLogger(InternalGaeObject.class);
    private long objectRev = -20L;

    protected InternalGaeObject(IGaeChangesService changesService, XAddress objectAddr, SEntity objectEntity, GaeLocks locks) {
        super(changesService, objectAddr, InternalGaeObject.getSavedRevison(objectAddr, objectEntity, locks), locks);
        assert (KeyStructure.toAddress(objectEntity.getKey()).equals(objectAddr));
        assert (objectAddr.getAddressedType() == XType.XOBJECT);
    }

    private static long getSavedRevison(XAddress objectAddr, SEntity objectEntity, GaeLocks locks) {
        long objectRev = locks.canWrite(objectAddr) ? (Long)objectEntity.getAttribute("revision") : -20L;
        return objectRev;
    }

    @Override
    public long getRevisionNumber() {
        long rev = super.getRevisionNumber();
        if (rev == -20L) {
            return -20L;
        }
        if (this.objectRev == -20L) {
            Iterator<XId> i$ = this.iterator();
            while (i$.hasNext()) {
                XId fieldId = i$.next();
                InternalGaeField field = this.getField(fieldId);
                assert (field != null);
                long fieldRev = field.getRevisionNumber();
                assert (fieldRev >= 0L);
                if (fieldRev <= rev) continue;
                rev = fieldRev;
            }
            this.objectRev = rev;
        }
        return this.objectRev;
    }

    public XId getId() {
        return this.getAddress().getObject();
    }

    public InternalGaeField getField(XId fieldId) {
        return (InternalGaeField)this.getChild(fieldId);
    }

    public boolean hasField(XId fieldId) {
        return this.hasChild(fieldId);
    }

    @Override
    protected InternalGaeField loadChild(XAddress childAddr, SEntity childEntity) {
        return new InternalGaeField(this.getChangesService(), childAddr, childEntity);
    }

    @Override
    protected XAddress resolveChild(XAddress addr, XId childId) {
        return Base.resolveField((XAddress)addr, (XId)childId);
    }

    static Future<SKey> createObject(XAddress objectAddr, GaeLocks locks, long rev) {
        assert (locks.canWrite(objectAddr));
        assert (objectAddr.getAddressedType() == XType.XOBJECT);
        SKey key = KeyStructure.createEntityKey(objectAddr);
        SEntity e = XGae.get().datastore().createEntity(key);
        e.setAttribute("revision", rev);
        return XGae.get().datastore().async().putEntity(e);
    }

    static void updateObjectRev(XAddress objectAddr, GaeLocks locks, long rev) {
        assert (locks.canRead(objectAddr));
        assert (objectAddr.getAddressedType() == XType.XOBJECT);
        IDatastoreSync syncDb = XGae.get().datastore().sync();
        SKey key = KeyStructure.createEntityKey(objectAddr);
        while (true) {
            STransaction txn = syncDb.beginTransaction();
            SEntity e = syncDb.getEntity(key, txn);
            assert (e != null) : "should not be removed while we hold a lock to a contained field";
            long oldRev = (Long)e.getAttribute("revision");
            assert (oldRev != rev);
            if (oldRev >= rev) {
                syncDb.endTransaction(txn);
                return;
            }
            e.setAttribute("revision", rev);
            XGae.get().datastore().async().putEntity(e, txn);
            try {
                syncDb.endTransaction(txn);
                return;
            }
            catch (ConcurrentModificationException cme) {
                log.debug("Encountered concurrend modification while trying to update the revision of object " + objectAddr, (Throwable)cme);
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException e1) {
                }
                continue;
            }
            break;
        }
    }

    public XType getType() {
        return XType.XOBJECT;
    }
}

