/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae.execute;

import java.util.concurrent.Future;
import org.xydra.base.Base;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.XType;
import org.xydra.base.rmof.XReadableModel;
import org.xydra.base.rmof.XReadableObject;
import org.xydra.store.impl.gae.changes.GaeLocks;
import org.xydra.store.impl.gae.changes.IGaeChangesService;
import org.xydra.store.impl.gae.changes.KeyStructure;
import org.xydra.store.impl.gae.execute.InternalGaeContainerXEntity;
import org.xydra.store.impl.gae.execute.InternalGaeObject;
import org.xydra.xgae.XGae;
import org.xydra.xgae.datastore.api.SEntity;
import org.xydra.xgae.datastore.api.SKey;

class InternalGaeModel
extends InternalGaeContainerXEntity<InternalGaeObject>
implements XReadableModel {
    private InternalGaeModel(IGaeChangesService changesService, XAddress modelAddr, long modelRev, GaeLocks locks) {
        super(changesService, modelAddr, modelRev, locks);
        assert (modelAddr.getAddressedType() == XType.XMODEL);
    }

    public XId getId() {
        return this.getAddress().getModel();
    }

    public XReadableObject getObject(XId objectId) {
        return (XReadableObject)this.getChild(objectId);
    }

    public boolean hasObject(XId objectId) {
        return this.hasChild(objectId);
    }

    @Override
    protected InternalGaeObject loadChild(XAddress childAddr, SEntity childEntity) {
        return new InternalGaeObject(this.getChangesService(), childAddr, childEntity, this.getLocks());
    }

    @Override
    protected XAddress resolveChild(XAddress addr, XId childId) {
        return Base.resolveObject((XAddress)addr, (XId)childId);
    }

    static InternalGaeModel get(IGaeChangesService changesService, long modelRev, GaeLocks locks) {
        assert (locks.canRead(changesService.getModelAddress()));
        SEntity e = XGae.get().datastore().sync().getEntity(KeyStructure.createEntityKey(changesService.getModelAddress()));
        if (e == null) {
            return null;
        }
        XAddress modelAddr = changesService.getModelAddress();
        return new InternalGaeModel(changesService, modelAddr, modelRev, locks);
    }

    static Future<SKey> createModel(XAddress modelAddr, GaeLocks locks) {
        assert (locks.canWrite(modelAddr));
        assert (modelAddr.getAddressedType() == XType.XMODEL);
        SEntity e = XGae.get().datastore().createEntity(KeyStructure.createEntityKey(modelAddr));
        return XGae.get().datastore().async().putEntity(e);
    }

    public XType getType() {
        return XType.XMODEL;
    }
}

