/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae.execute;

import java.util.List;
import java.util.concurrent.Future;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.change.ChangeType;
import org.xydra.base.change.XCommand;
import org.xydra.base.change.XEvent;
import org.xydra.base.rmof.XReadableModel;
import org.xydra.base.rmof.XRevWritableModel;
import org.xydra.base.rmof.XRevWritableObject;
import org.xydra.base.rmof.impl.XExistsReadableModel;
import org.xydra.base.rmof.impl.memory.SimpleModel;
import org.xydra.base.rmof.impl.memory.SimpleObject;
import org.xydra.common.NanoClock;
import org.xydra.core.change.EventUtils;
import org.xydra.core.model.delta.ChangedModel;
import org.xydra.core.model.delta.DeltaUtils;
import org.xydra.index.query.Pair;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.sharedutils.XyAssert;
import org.xydra.store.impl.gae.InstanceRevisionManager;
import org.xydra.store.impl.gae.changes.GaeChange;
import org.xydra.store.impl.gae.changes.GaeLocks;
import org.xydra.store.impl.gae.changes.GaeModelRevision;
import org.xydra.store.impl.gae.changes.IGaeChangesService;
import org.xydra.store.impl.gae.changes.VoluntaryTimeoutException;
import org.xydra.store.impl.gae.execute.IGaeExecutionService;
import org.xydra.store.impl.gae.snapshot.IGaeSnapshotService;
import org.xydra.store.impl.utils.DebugFormatter;
import org.xydra.xgae.datastore.api.SKey;
import org.xydra.xgae.util.FutureUtils;

public class GaeExecutionServiceImpl3
implements IGaeExecutionService {
    private static final long WAIT_INITIAL = 10L;
    private static final long WAIT_MAX = 1000L;
    private static final Logger log = LoggerFactory.getLogger(GaeExecutionServiceImpl3.class);
    private final InstanceRevisionManager revisionManager;
    private final IGaeChangesService changesservice;
    private final IGaeSnapshotService snapshots;
    private final XAddress modelAddr;

    public GaeExecutionServiceImpl3(InstanceRevisionManager revisionManager, IGaeChangesService changes, IGaeSnapshotService snapshots) {
        this.revisionManager = revisionManager;
        this.changesservice = changes;
        this.modelAddr = changes.getModelAddress();
        XyAssert.xyAssert((snapshots.getModelAddress() == this.modelAddr ? 1 : 0) != 0);
        this.snapshots = snapshots;
    }

    @Override
    public long executeCommand(XCommand command, XId actorId) {
        log.debug("Execute " + DebugFormatter.format((Object)command));
        NanoClock c = new NanoClock().start();
        XyAssert.xyAssert((boolean)this.modelAddr.equalsOrContains(command.getChangedEntity()), (Object)("cannot handle command " + command + " - it does not address a model"));
        GaeLocks locks = GaeLocks.createLocks(command);
        c.stopAndStart("createlocks");
        log.debug("Phase 1: grabRevisionAndRegister " + locks.size() + " locks = " + locks);
        GaeChange change = this.changesservice.grabRevisionAndRegisterLocks(this.revisionManager.getInstanceRevisionInfo().getLastTaken(), locks, actorId);
        XyAssert.xyAssert((change.rev >= 0L ? 1 : 0) != 0);
        c.stopAndStart("grabRevisionAndRegisterLocks");
        GaeModelRevision gaeModelRev = this.revisionManager.getInstanceRevisionInfo().getGaeModelRevision();
        long snapshotRev = gaeModelRev.getModelRevision().revision();
        log.info("[r" + change.rev + "] Phase 2: getPartialSnapshot at {rev=" + snapshotRev + "/lastCommited=" + this.revisionManager.getInstanceRevisionInfo().getLastCommitted() + "}");
        XRevWritableModel partialSnapshot = null;
        if (gaeModelRev.getModelRevision().modelExists()) {
            partialSnapshot = this.snapshots.getPartialSnapshot(snapshotRev, change.getLocks());
            c.stopAndStart("getPartialSnapshot");
        }
        log.info("[r" + change.rev + "] Phase 3: updateSnapshot to " + (change.rev - 1L) + " and wait for locks");
        XRevWritableModel workingModel = this.updatePartialSnapshot(partialSnapshot, snapshotRev, change);
        c.stopAndStart("updateSnapshot");
        log.debug("[r" + change.rev + "] Phase 4: checkPreconditionsAndSaveEvents change = " + change + ", command = " + command);
        long ret = this.checkPreconditionsAndSaveEvents(change, command, actorId, (XExistsReadableModel)workingModel);
        log.trace("result " + ret);
        c.stopAndStart("checkPreconditionsAndSaveEvents");
        XyAssert.xyAssert((boolean)change.getStatus().isCommitted(), (String)"If we reach this line, change must be commited is %s", (Object[])new Object[]{change.getStatus()});
        if (log.isInfoEnabled() || ret == -1L && log.isWarnEnabled()) {
            String msg = "[r" + change.rev + "] -> " + (ret == -1L ? "failed" : (ret == -2L ? "nochange" : "success")) + " {" + gaeModelRev + "}. Stats: " + c.getStats();
            if (ret == -1L) {
                log.warn(msg);
            } else {
                log.info(msg);
            }
        }
        return ret;
    }

    private XRevWritableModel updatePartialSnapshot(XRevWritableModel snapshot, long snapshotRev, GaeChange change) {
        long start;
        long end;
        long workingWindowSize;
        XRevWritableModel workingModel = snapshot;
        for (long checkRev = snapshotRev + 1L; checkRev < change.rev; ++checkRev) {
            GaeChange checkChange = this.changesservice.getChange(checkRev);
            if (checkChange == null) {
                throw new IllegalStateException("Our change.rev=" + change.rev + " waits for locks. Check for " + checkRev + " got null from backend");
            }
            if (checkChange.getStatus().canChange()) {
                boolean timedOut;
                if (!change.isConflicting(checkChange)) {
                    workingModel = GaeExecutionServiceImpl3.invalidateObjectRevisions((XReadableModel)snapshot, workingModel, checkChange.getLocks());
                    continue;
                }
                long waitTime = 10L;
                while (!(timedOut = checkChange.isTimedOut())) {
                    try {
                        Thread.sleep(waitTime);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    checkChange.reload();
                    if (!checkChange.getStatus().canChange()) {
                        this.changesservice.cacheCommittedChange(checkChange);
                        XyAssert.xyAssert((!checkChange.hasLocks() ? 1 : 0) != 0);
                        break;
                    }
                    waitTime = GaeExecutionServiceImpl3.increaseExponentiallyWithFactorAndMaximum(waitTime, 2, 1000L);
                }
                if (timedOut) {
                    this.changesservice.commit(checkChange, GaeChange.Status.FailedTimeout);
                }
            }
            XyAssert.xyAssert((boolean)checkChange.getStatus().isCommitted());
            if (!checkChange.getStatus().hasEvents()) continue;
            log.trace("checkRev=" + checkRev + " Applying " + checkChange.getEvent());
            workingModel = EventUtils.applyEventNonDestructive((XReadableModel)snapshot, (XRevWritableModel)workingModel, (XEvent)checkChange.getEvent(), (boolean)true);
        }
        if (log.isInfoEnabled() && (workingWindowSize = (end = change.rev) - (start = snapshotRev)) > 1L) {
            log.info("[r" + change.rev + "] Current working window size = " + workingWindowSize + " [" + start + "," + end + "] GA?category=performance&action=workingwindow&label=size&value=" + workingWindowSize);
        }
        if (workingModel != null && workingModel.getRevisionNumber() != change.rev - 1L) {
            if (workingModel == snapshot) {
                workingModel = SimpleModel.shallowCopy((XRevWritableModel)snapshot);
            }
            workingModel.setRevisionNumber(change.rev - 1L);
        }
        return workingModel;
    }

    private static long increaseExponentiallyWithFactorAndMaximum(long l, int f, long max) {
        long result = l * 2L;
        if (result > max) {
            result = max;
        }
        return result;
    }

    private static XRevWritableModel invalidateObjectRevisions(XReadableModel referenceModel, XRevWritableModel model, GaeLocks locks) {
        if (model == null) {
            return null;
        }
        XRevWritableModel result = model;
        for (XAddress lock : locks) {
            XId objectId = lock.getObject();
            if (objectId == null) continue;
            XRevWritableObject object = result.getObject(lock.getObject());
            if (object == null) {
                log.warn("null-object '" + lock.getObject() + "' in snapshot " + result.getAddress());
                continue;
            }
            assert (object != null);
            if (referenceModel != null && object == referenceModel.getObject(lock.getObject())) {
                if (result == referenceModel) {
                    result = SimpleModel.shallowCopy((XRevWritableModel)result);
                }
                object = SimpleObject.shallowCopy((XRevWritableObject)object);
                assert (object != null);
                result.addObject(object);
            }
            object.setRevisionNumber(-20L);
        }
        return result;
    }

    private long checkPreconditionsAndSaveEvents(GaeChange change, XCommand command, XId actorId, XExistsReadableModel snapshot) {
        ChangedModel changedModel = DeltaUtils.executeCommand((XExistsReadableModel)snapshot, (XCommand)command);
        if (changedModel == null) {
            change.giveUpIfTimeoutCritical();
            this.changesservice.commit(change, GaeChange.Status.FailedPreconditions);
            log.info("Failed preconditions");
            return -1L;
        }
        List events = DeltaUtils.createEvents((XAddress)this.modelAddr, (ChangedModel)changedModel, (XId)actorId, (long)change.rev, (command.getChangeType() == ChangeType.TRANSACTION ? 1 : 0) != 0);
        log.debug("[r" + change.rev + "] DeltaUtils generated " + events.size() + " events");
        if (events.size() > 1000) {
            log.warn("Created over 1000 events (" + events.size() + ") GA?category=xydra&action=saveManyEvents&label=events&value=" + events.size());
            try {
                throw new RuntimeException("Over 1000 events");
            }
            catch (Exception e) {
                log.warn("Over 1000 events", (Throwable)e);
            }
        }
        try {
            if (events.isEmpty()) {
                change.giveUpIfTimeoutCritical();
                this.changesservice.commit(change, GaeChange.Status.SuccessNochange);
                log.debug("No change");
                return -2L;
            }
            Pair<int[], List<Future<SKey>>> res = change.setEvents(events);
            for (Future future : (List)res.getSecond()) {
                FutureUtils.waitFor((Future)future);
            }
            change.giveUpIfTimeoutCritical();
        }
        catch (VoluntaryTimeoutException vte) {
            this.changesservice.commit(change, GaeChange.Status.FailedTimeout);
            throw vte;
        }
        this.changesservice.commit(change, GaeChange.Status.SuccessExecuted);
        return change.rev;
    }
}

