/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae.changes;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.index.iterator.ITransformer;
import org.xydra.index.iterator.TransformingIterator;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.store.impl.gae.changes.KeyStructure;
import org.xydra.store.impl.utils.DebugFormatter;
import org.xydra.xgae.XGae;
import org.xydra.xgae.datastore.api.SEntity;
import org.xydra.xgae.datastore.api.SPreparedQuery;
import org.xydra.xgae.util.XGaeDebugHelper;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    public static Set<XId> findChildren(XAddress address) {
        assert (address.getRepository() != null);
        assert (address.getField() == null);
        StringBuffer uri = new StringBuffer();
        uri.append('/');
        uri.append(address.getRepository().toString());
        uri.append('/');
        if (address.getModel() != null) {
            uri.append(address.getModel().toString());
            uri.append('/');
            if (address.getObject() != null) {
                uri.append(address.getObject().toString());
                uri.append('/');
            }
        }
        HashSet<XId> childIds = new HashSet<XId>();
        String kind = address.getAddressedType().getChildType().toString();
        String low = uri.toString();
        String high = low + "\uffff";
        SPreparedQuery preparedQuery = XGae.get().datastore().sync().prepareRangeQuery(kind, true, low, high);
        for (SEntity e : preparedQuery.asIterable()) {
            XAddress childAddr = KeyStructure.toAddress(e.getKey());
            assert (address.equals(childAddr.getParent()));
            childIds.add(Utils.getEntityId(childAddr));
        }
        log.debug(XGaeDebugHelper.dataGet((String)XGae.get().datastore().sync().getDatastoreName(), (String)("query-children:" + address.toURI()), (Object)DebugFormatter.format(childIds), (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Now));
        return childIds;
    }

    private static XId getEntityId(XAddress address) {
        if (address.getField() != null) {
            return address.getField();
        }
        if (address.getObject() != null) {
            return address.getObject();
        }
        if (address.getModel() != null) {
            return address.getModel();
        }
        return address.getRepository();
    }

    public static Iterator<XAddress> findModelAdresses() {
        SPreparedQuery preparedQuery = XGae.get().datastore().sync().prepareRangeQuery("XCHANGE", true, null, "1");
        Iterator it = preparedQuery.asIterable().iterator();
        return new TransformingIterator(it, (ITransformer)new ITransformer<SEntity, XAddress>(){

            public XAddress transform(SEntity in) {
                return KeyStructure.getAddressFromChangeKey(in.getKey());
            }
        });
    }
}

