/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae.changes;

import java.io.Serializable;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.store.impl.gae.changes.GaeModelRevision;
import org.xydra.xgae.util.XGaeDebugHelper;

public class RevisionInfo
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(RevisionInfo.class);
    public static final long NOT_SET = -1L;
    private static final long serialVersionUID = -8537625185285087183L;
    private String datasourceName;
    private GaeModelRevision gaeModelRev;
    private long lastCommitted;
    private long lastTaken;

    public RevisionInfo(String datasourceName) {
        this.datasourceName = datasourceName;
        this.gaeModelRev = GaeModelRevision.createGaeModelRevDoesNotExistYet();
        this.clear();
    }

    public RevisionInfo(String datasourceName, GaeModelRevision modelRev, long lastCommited, long lastTaken) {
        assert (modelRev != null);
        this.datasourceName = datasourceName;
        this.gaeModelRev = modelRev;
        this.lastCommitted = lastCommited;
        this.lastTaken = lastTaken;
        log.debug(XGaeDebugHelper.init((String)this.datasourceName));
    }

    public void clear() {
        log.debug(XGaeDebugHelper.clear((String)this.datasourceName));
        this.gaeModelRev.clear();
        this.lastCommitted = -1L;
        this.lastTaken = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GaeModelRevision getGaeModelRevision() {
        RevisionInfo revisionInfo = this;
        synchronized (revisionInfo) {
            GaeModelRevision result = this.gaeModelRev;
            log.trace(XGaeDebugHelper.dataGet((String)this.datasourceName, (String)"gaeModelRev", (Object)result, (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Now));
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long getLastCommitted() {
        RevisionInfo revisionInfo = this;
        synchronized (revisionInfo) {
            long result = this.lastCommitted;
            log.trace(XGaeDebugHelper.dataGet((String)this.datasourceName, (String)"lastCommitted", (Object)result, (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Now));
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long getLastTaken() {
        RevisionInfo revisionInfo = this;
        synchronized (revisionInfo) {
            long result = this.lastTaken;
            log.trace(XGaeDebugHelper.dataGet((String)this.datasourceName, (String)"lastTaken", (Object)result, (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Now));
            return result;
        }
    }

    void setDatasourceName(String datasourceName) {
        this.datasourceName = datasourceName;
    }

    protected void setGaeModelRev(GaeModelRevision gaeModelRev) {
        assert (gaeModelRev != null);
        log.debug(XGaeDebugHelper.dataPut((String)this.datasourceName, (String)"gaeModelRev", (Object)gaeModelRev, (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Now));
        this.gaeModelRev = gaeModelRev;
    }

    public synchronized void setLastCommittedIfHigher(long lastCommitted) {
        if (lastCommitted > this.lastCommitted) {
            log.debug(XGaeDebugHelper.dataPut((String)this.datasourceName, (String)"lastCommitted", (Object)lastCommitted, (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Now));
            this.lastCommitted = lastCommitted;
            this.setLastTakenIfHigher(lastCommitted);
        }
    }

    public synchronized void setLastTakenIfHigher(long lastTaken) {
        if (lastTaken > this.lastTaken) {
            log.debug(XGaeDebugHelper.dataPut((String)this.datasourceName, (String)"lastTaken", (Object)lastTaken, (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Now));
            this.lastTaken = lastTaken;
        }
    }

    public String toString() {
        return "{current:" + this.getGaeModelRevision() + "; lastTaken:" + this.getLastTaken() + ",lastCommitted:" + this.getLastCommitted() + "}";
    }

    public boolean isBetterThan(RevisionInfo other) {
        if (other == null) {
            return true;
        }
        if (this.gaeModelRev.getLastSilentCommitted() > other.gaeModelRev.getLastSilentCommitted()) {
            return true;
        }
        if (other.gaeModelRev.getModelRevision() == null) {
            if (this.gaeModelRev.getModelRevision() != null) {
                return true;
            }
            return this.lastTaken > other.lastTaken;
        }
        assert (other.gaeModelRev.getModelRevision() != null);
        return this.gaeModelRev.getModelRevision().isBetterThan(other.gaeModelRev.getModelRevision());
    }

    public void setCurrentGaeModelRevIfRevisionIsHigher(GaeModelRevision gaeModelRev) {
        assert (gaeModelRev.getModelRevision() != null);
        if (gaeModelRev.getModelRevision().revision() > this.gaeModelRev.getModelRevision().revision()) {
            log.trace(XGaeDebugHelper.dataPut((String)this.datasourceName, (String)"gaeModelRev", (Object)gaeModelRev, (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Now));
            this.gaeModelRev = gaeModelRev;
        }
    }
}

