/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae.changes;

import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.change.ChangeType;
import org.xydra.base.change.XFieldEvent;
import org.xydra.base.change.impl.memory.MemoryAtomicEvent;
import org.xydra.base.value.XValue;
import org.xydra.index.XI;
import org.xydra.store.impl.gae.changes.GaeEvents;

class GaeFieldEvent
extends MemoryAtomicEvent
implements XFieldEvent {
    private static final long serialVersionUID = -4274165693986851623L;
    private final long modelRevision;
    private final long objectRevision;
    private final long fieldRevision;
    private final GaeEvents.AsyncValue newValue;

    protected GaeFieldEvent(XId actor, XAddress target, GaeEvents.AsyncValue newValue, ChangeType changeType, long modelRevision, long objectRevision, long fieldRevision, boolean inTransaction, boolean implied) {
        super(target, changeType, actor, inTransaction, implied);
        assert (target.getField() != null && fieldRevision >= -1L);
        assert (objectRevision >= -1L || objectRevision == -21L || objectRevision == -20L);
        assert (modelRevision >= -1L || modelRevision == -21L);
        assert (newValue != null);
        this.newValue = newValue;
        this.modelRevision = modelRevision;
        this.objectRevision = objectRevision;
        this.fieldRevision = fieldRevision;
    }

    public XAddress getChangedEntity() {
        return this.getTarget();
    }

    public XValue getNewValue() {
        return this.newValue.get();
    }

    public long getOldFieldRevision() {
        return this.fieldRevision;
    }

    public long getOldModelRevision() {
        return this.modelRevision;
    }

    public long getOldObjectRevision() {
        return this.objectRevision;
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof XFieldEvent)) {
            return false;
        }
        XFieldEvent event = (XFieldEvent)object;
        if (!XI.equals((Object)this.getNewValue(), (Object)event.getNewValue())) {
            return false;
        }
        if (this.modelRevision != event.getOldModelRevision()) {
            return false;
        }
        long otherObjectRev = event.getOldObjectRevision();
        if (this.objectRevision != otherObjectRev && this.objectRevision != -20L && otherObjectRev != -20L) {
            return false;
        }
        return this.fieldRevision == event.getOldFieldRevision();
    }

    public int hashCode() {
        int result = super.hashCode();
        result ^= this.getNewValue() == null ? 0 : this.getNewValue().hashCode();
        result = (int)((long)result + this.modelRevision);
        if (this.objectRevision != -21L) {
            result += 54993033;
        }
        result = (int)((long)result + this.fieldRevision);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("  GaeFieldEvent");
        sb.append(" rev:");
        sb.append(this.rev2str(this.getRevisionNumber()));
        sb.append(" old:");
        sb.append(this.rev2str(this.getOldModelRevision()));
        sb.append("/");
        sb.append(this.rev2str(this.getOldObjectRevision()));
        sb.append("/");
        sb.append(this.rev2str(this.getOldFieldRevision()));
        this.addChangeTypeAndFlags(sb);
        sb.append(" @" + this.getTarget());
        sb.append(" ->*" + this.getNewValue() + "*");
        sb.append("                 (actor:'" + this.getActor() + "')");
        return sb.toString();
    }
}

