/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae.changes;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.xydra.base.Base;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.XType;
import org.xydra.base.change.ChangeType;
import org.xydra.base.change.XAtomicEvent;
import org.xydra.base.change.XFieldEvent;
import org.xydra.base.change.XModelEvent;
import org.xydra.base.change.XObjectEvent;
import org.xydra.base.change.XRepositoryEvent;
import org.xydra.base.change.impl.memory.MemoryModelEvent;
import org.xydra.base.change.impl.memory.MemoryObjectEvent;
import org.xydra.base.change.impl.memory.MemoryRepositoryEvent;
import org.xydra.base.value.XValue;
import org.xydra.core.serialize.SerializedValue;
import org.xydra.core.serialize.XydraElement;
import org.xydra.core.serialize.XydraOut;
import org.xydra.core.serialize.xml.XmlOut;
import org.xydra.core.serialize.xml.XmlParser;
import org.xydra.index.query.Pair;
import org.xydra.sharedutils.XyAssert;
import org.xydra.store.impl.gae.GaeUtils2;
import org.xydra.store.impl.gae.changes.GaeFieldEvent;
import org.xydra.store.impl.gae.changes.KeyStructure;
import org.xydra.xgae.XGae;
import org.xydra.xgae.datastore.api.SEntity;
import org.xydra.xgae.datastore.api.SKey;
import org.xydra.xgae.datastore.api.SText;
import org.xydra.xgae.datastore.api.SValue;
import org.xydra.xgae.util.AsyncEntity;

public class GaeEvents {
    private static final String PROP_EVENT_TYPES = "eventTypes";
    private static final String PROP_EVENT_TARGETS = "eventTargets";
    private static final String PROP_EVENT_VALUES = "eventValues";
    private static final String PROP_EVENT_REVS_OBJECT = "objectRevisions";
    private static final String PROP_EVENT_REVS_FIELD = "fieldRevisions";
    private static final String PROP_EVENT_IMPLIED = "eventIsImplied";
    private static final SText VALUE_EXTERN = XGae.get().datastore().createText("extern");
    private static final String PROP_VALUE = "value";
    private static final int MAX_VALUE_SIZE = 1024;
    public static final int TRANSINDEX_NONE = -1;
    private static final AsyncValue VALUE_NULL = new AsyncValue(null);

    protected static AsyncValue getValue(XAddress modelAddr, long revisionNumber, int transindex) {
        if (transindex == -1) {
            return VALUE_NULL;
        }
        if (transindex < -1) {
            SKey changeKey = KeyStructure.createChangeKey(modelAddr, revisionNumber);
            return new AsyncValue(GaeUtils2.getEntityFromMemcacheAndAsyncDatatore(changeKey), transindex);
        }
        return GaeEvents.getExternalValue(modelAddr, revisionNumber, transindex);
    }

    private static AsyncValue getExternalValue(XAddress modelAddr, long revisionNumber, int transindex) {
        SKey valueKey = KeyStructure.createValueKey(modelAddr, revisionNumber, transindex);
        return new AsyncValue(GaeUtils2.getEntityFromMemcacheAndAsyncDatatore(valueKey), transindex);
    }

    protected static Pair<int[], List<Future<SKey>>> saveEvents(XAddress modelAddr, SEntity changeEntity, List<XAtomicEvent> events) {
        ArrayList<Integer> types = new ArrayList<Integer>();
        ArrayList<String> targets = new ArrayList<String>();
        ArrayList<SText> values = new ArrayList<SText>();
        ArrayList<Long> objectRevs = new ArrayList<Long>();
        ArrayList<Long> fieldRevs = new ArrayList<Long>();
        ArrayList<Boolean> implied = new ArrayList<Boolean>();
        int[] valueIds = new int[events.size()];
        ArrayList<Future> futures = new ArrayList<Future>();
        for (int i = 0; i < events.size(); ++i) {
            XAtomicEvent ae = events.get(i);
            XyAssert.xyAssert((events.size() == 1 || ae.inTransaction() ? 1 : 0) != 0, (String)("Multiple events should be in a txn. Events:" + events.size() + " inTxn?" + ae.inTransaction() + " event: %s"), (Object[])new Object[]{ae});
            types.add(EventType.get((XType)ae.getTarget().getAddressedType(), (ChangeType)ae.getChangeType()).id);
            targets.add(ae.getTarget().toString());
            implied.add(ae.isImplied());
            if (ae instanceof XRepositoryEvent) {
                values.add(XGae.get().datastore().createText(((XRepositoryEvent)ae).getModelId().toString()));
                continue;
            }
            if (ae instanceof XModelEvent) {
                objectRevs.add(ae.getOldObjectRevision());
                values.add(XGae.get().datastore().createText(((XModelEvent)ae).getObjectId().toString()));
                continue;
            }
            if (ae instanceof XObjectEvent) {
                objectRevs.add(ae.getOldObjectRevision());
                fieldRevs.add(ae.getOldFieldRevision());
                values.add(XGae.get().datastore().createText(((XObjectEvent)ae).getFieldId().toString()));
                continue;
            }
            assert (ae instanceof XFieldEvent);
            objectRevs.add(ae.getOldObjectRevision());
            fieldRevs.add(ae.getOldFieldRevision());
            XValue xv = ((XFieldEvent)ae).getNewValue();
            if (xv == null) {
                values.add(null);
                valueIds[i] = -1;
                continue;
            }
            XmlOut out = new XmlOut(false);
            SerializedValue.serialize((XValue)xv, (XydraOut)out);
            String valueStr = out.getData();
            SText value = XGae.get().datastore().createText(valueStr);
            if (valueStr.length() > 1024) {
                SKey k = KeyStructure.createValueKey(modelAddr, ae.getOldModelRevision() + 1L, i);
                SEntity e = XGae.get().datastore().createEntity(k);
                e.setAttribute(PROP_VALUE, (SValue)value);
                futures.add(XGae.get().datastore().async().putEntity(e));
                values.add(VALUE_EXTERN);
                valueIds[i] = i;
                continue;
            }
            assert (values.size() == i);
            values.add(value);
            valueIds[i] = GaeEvents.getInternalValueId(i);
        }
        changeEntity.setAttribute(PROP_EVENT_TYPES, types);
        changeEntity.setAttribute(PROP_EVENT_TARGETS, targets);
        changeEntity.setAttribute(PROP_EVENT_VALUES, values);
        if (!objectRevs.isEmpty()) {
            changeEntity.setAttribute(PROP_EVENT_REVS_OBJECT, objectRevs);
        }
        if (!fieldRevs.isEmpty()) {
            changeEntity.setAttribute(PROP_EVENT_REVS_FIELD, fieldRevs);
        }
        changeEntity.setAttribute(PROP_EVENT_IMPLIED, implied);
        return new Pair((Object)valueIds, futures);
    }

    private static int getInternalValueId(int i) {
        return -2 - i;
    }

    protected static Pair<XAtomicEvent[], int[]> loadAtomicEvents(XAddress modelAddr, long rev, XId actor, SEntity changeEntity) {
        List types = (List)changeEntity.getAttribute(PROP_EVENT_TYPES);
        List targets = (List)changeEntity.getAttribute(PROP_EVENT_TARGETS);
        List values = (List)changeEntity.getAttribute(PROP_EVENT_VALUES);
        List objectRevs = (List)changeEntity.getAttribute(PROP_EVENT_REVS_OBJECT);
        List fieldRevs = (List)changeEntity.getAttribute(PROP_EVENT_REVS_FIELD);
        List implied = (List)changeEntity.getAttribute(PROP_EVENT_IMPLIED);
        XyAssert.xyAssert((types != null ? 1 : 0) != 0, (Object)"changeEntity.PROP_EVENT_TYPES was null");
        assert (types != null && targets != null && values != null && implied != null);
        XAtomicEvent[] events = new XAtomicEvent[types.size()];
        assert (targets.size() == events.length && implied.size() == events.length && values.size() == events.length);
        int[] valueIds = new int[events.length];
        boolean inTrans = events.length > 1;
        int ori = 0;
        int fri = 0;
        long modelRev = rev - 1L;
        block18: for (int i = 0; i < events.length; ++i) {
            EventType type = EventType.get(((Number)types.get(i)).intValue());
            XAddress target = Base.toAddress((String)((String)targets.get(i)));
            boolean isImplied = (Boolean)implied.get(i);
            switch (type.getTargetType()) {
                case XREPOSITORY: {
                    XId modelId = Base.toId((String)((SText)values.get(i)).getValue());
                    switch (type.getChangeType()) {
                        case ADD: {
                            events[i] = MemoryRepositoryEvent.createAddEvent((XId)actor, (XAddress)target, (XId)modelId, (long)modelRev, (boolean)inTrans);
                            continue block18;
                        }
                        case REMOVE: {
                            events[i] = MemoryRepositoryEvent.createRemoveEvent((XId)actor, (XAddress)target, (XId)modelId, (long)modelRev, (boolean)inTrans);
                            continue block18;
                        }
                    }
                    assert (false);
                    continue block18;
                }
                case XMODEL: {
                    XId objectId = Base.toId((String)((SText)values.get(i)).getValue());
                    long objectRev = ((Number)objectRevs.get(ori++)).longValue();
                    switch (type.getChangeType()) {
                        case ADD: {
                            events[i] = MemoryModelEvent.createAddEvent((XId)actor, (XAddress)target, (XId)objectId, (long)modelRev, (boolean)inTrans);
                            continue block18;
                        }
                        case REMOVE: {
                            events[i] = MemoryModelEvent.createRemoveEvent((XId)actor, (XAddress)target, (XId)objectId, (long)modelRev, (long)objectRev, (boolean)inTrans, (boolean)isImplied);
                            continue block18;
                        }
                    }
                    assert (false);
                    continue block18;
                }
                case XOBJECT: {
                    XId fieldId = Base.toId((String)((SText)values.get(i)).getValue());
                    long objectRev = ((Number)objectRevs.get(ori++)).longValue();
                    long fieldRev = ((Number)fieldRevs.get(fri++)).longValue();
                    switch (type.getChangeType()) {
                        case ADD: {
                            events[i] = MemoryObjectEvent.createAddEvent((XId)actor, (XAddress)target, (XId)fieldId, (long)modelRev, (long)objectRev, (boolean)inTrans);
                            continue block18;
                        }
                        case REMOVE: {
                            events[i] = MemoryObjectEvent.createRemoveEvent((XId)actor, (XAddress)target, (XId)fieldId, (long)modelRev, (long)objectRev, (long)fieldRev, (boolean)inTrans, (boolean)isImplied);
                            continue block18;
                        }
                    }
                    assert (false);
                    continue block18;
                }
                case XFIELD: {
                    AsyncValue value;
                    SText valueTxt = (SText)values.get(i);
                    long objectRev = ((Number)objectRevs.get(ori++)).longValue();
                    long fieldRev = ((Number)fieldRevs.get(fri++)).longValue();
                    if (valueTxt == null) {
                        assert (type.getChangeType() == ChangeType.REMOVE);
                        value = VALUE_NULL;
                        valueIds[i] = -1;
                    } else {
                        assert (type.getChangeType() != ChangeType.REMOVE);
                        boolean isExtern = VALUE_EXTERN.equals(valueTxt);
                        if (!isExtern) {
                            String valueXml = valueTxt.getValue();
                            XydraElement eventElement = new XmlParser().parse(valueXml);
                            value = new AsyncValue(SerializedValue.toValue((XydraElement)eventElement));
                            valueIds[i] = GaeEvents.getInternalValueId(i);
                        } else {
                            value = GaeEvents.getExternalValue(modelAddr, rev, i);
                            valueIds[i] = i;
                        }
                    }
                    assert (value != null);
                    events[i] = new GaeFieldEvent(actor, target, value, type.getChangeType(), modelRev, objectRev, fieldRev, inTrans, isImplied);
                }
            }
        }
        return new Pair((Object)events, (Object)valueIds);
    }

    static int getEventIndex(int transindex) {
        return transindex < -1 ? GaeEvents.getInternalValueId(transindex) : transindex;
    }

    public static class AsyncValue {
        private final AsyncEntity future;
        private final int transIndex;
        private XValue value;

        private AsyncValue(AsyncEntity future, int transIndex) {
            this.future = future;
            this.transIndex = transIndex;
            assert (transIndex != -1);
        }

        protected AsyncValue(XValue value) {
            this.value = value;
            this.future = null;
            this.transIndex = -1;
        }

        public XValue get() {
            if (this.value == null && this.transIndex != -1) {
                SText eventXml;
                SEntity eventEntity = this.future.get();
                if (eventEntity == null) {
                    return null;
                }
                if (this.transIndex < 0) {
                    int realindex = GaeEvents.getInternalValueId(this.transIndex);
                    List eventValues = (List)eventEntity.getAttribute(GaeEvents.PROP_EVENT_VALUES);
                    if (eventValues == null || realindex >= eventValues.size()) {
                        return null;
                    }
                    eventXml = (SText)eventValues.get(realindex);
                    if (eventXml == null) {
                        return null;
                    }
                } else {
                    eventXml = (SText)eventEntity.getAttribute(GaeEvents.PROP_VALUE);
                }
                XydraElement eventElement = new XmlParser().parse(eventXml.getValue());
                this.value = SerializedValue.toValue((XydraElement)eventElement);
                assert (this.value != null);
            }
            return this.value;
        }
    }

    private static final class EventType
    extends Enum<EventType> {
        public static final /* enum */ EventType AddModel = new EventType(1);
        public static final /* enum */ EventType RemoveModel = new EventType(2);
        public static final /* enum */ EventType AddObject = new EventType(3);
        public static final /* enum */ EventType RemoveObject = new EventType(4);
        public static final /* enum */ EventType AddField = new EventType(5);
        public static final /* enum */ EventType RemoveField = new EventType(6);
        public static final /* enum */ EventType AddValue = new EventType(7);
        public static final /* enum */ EventType ChangeValue = new EventType(8);
        public static final /* enum */ EventType RemoveValue = new EventType(9);
        public final int id;
        private static final /* synthetic */ EventType[] $VALUES;

        public static EventType[] values() {
            return (EventType[])$VALUES.clone();
        }

        public static EventType valueOf(String name) {
            return Enum.valueOf(EventType.class, name);
        }

        private EventType(int id) {
            this.id = id;
        }

        static EventType get(int id) {
            switch (id) {
                case 1: {
                    return AddModel;
                }
                case 2: {
                    return RemoveModel;
                }
                case 3: {
                    return AddObject;
                }
                case 4: {
                    return RemoveObject;
                }
                case 5: {
                    return AddField;
                }
                case 6: {
                    return RemoveField;
                }
                case 7: {
                    return AddValue;
                }
                case 8: {
                    return ChangeValue;
                }
                case 9: {
                    return RemoveValue;
                }
            }
            return null;
        }

        public ChangeType getChangeType() {
            switch (this) {
                case AddField: {
                    return ChangeType.ADD;
                }
                case AddModel: {
                    return ChangeType.ADD;
                }
                case AddObject: {
                    return ChangeType.ADD;
                }
                case AddValue: {
                    return ChangeType.ADD;
                }
                case ChangeValue: {
                    return ChangeType.CHANGE;
                }
                case RemoveField: {
                    return ChangeType.REMOVE;
                }
                case RemoveModel: {
                    return ChangeType.REMOVE;
                }
                case RemoveObject: {
                    return ChangeType.REMOVE;
                }
                case RemoveValue: {
                    return ChangeType.REMOVE;
                }
            }
            assert (false);
            return null;
        }

        public XType getTargetType() {
            switch (this) {
                case AddField: {
                    return XType.XOBJECT;
                }
                case AddModel: {
                    return XType.XREPOSITORY;
                }
                case AddObject: {
                    return XType.XMODEL;
                }
                case AddValue: {
                    return XType.XFIELD;
                }
                case ChangeValue: {
                    return XType.XFIELD;
                }
                case RemoveField: {
                    return XType.XOBJECT;
                }
                case RemoveModel: {
                    return XType.XREPOSITORY;
                }
                case RemoveObject: {
                    return XType.XMODEL;
                }
                case RemoveValue: {
                    return XType.XFIELD;
                }
            }
            assert (false);
            return null;
        }

        public static EventType get(XType entity, ChangeType change) {
            assert (change != ChangeType.TRANSACTION);
            switch (entity) {
                case XREPOSITORY: {
                    if (change == ChangeType.ADD) {
                        return AddModel;
                    }
                    assert (change == ChangeType.REMOVE);
                    return RemoveModel;
                }
                case XMODEL: {
                    if (change == ChangeType.ADD) {
                        return AddObject;
                    }
                    assert (change == ChangeType.REMOVE);
                    return RemoveObject;
                }
                case XOBJECT: {
                    if (change == ChangeType.ADD) {
                        return AddField;
                    }
                    assert (change == ChangeType.REMOVE);
                    return RemoveField;
                }
                case XFIELD: {
                    switch (change) {
                        case ADD: {
                            return AddValue;
                        }
                        case CHANGE: {
                            return ChangeValue;
                        }
                        case REMOVE: {
                            return RemoveValue;
                        }
                    }
                    assert (false);
                    return null;
                }
            }
            assert (false);
            return null;
        }

        static {
            $VALUES = new EventType[]{AddModel, RemoveModel, AddObject, RemoveObject, AddField, RemoveField, AddValue, ChangeValue, RemoveValue};
        }
    }
}

