/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae.changes;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import org.xydra.base.Base;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.change.XAtomicEvent;
import org.xydra.base.change.XEvent;
import org.xydra.base.change.impl.memory.MemoryTransactionEvent;
import org.xydra.index.query.Pair;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.sharedutils.XyAssert;
import org.xydra.store.impl.gae.Memcache;
import org.xydra.store.impl.gae.changes.GaeEvents;
import org.xydra.store.impl.gae.changes.GaeLocks;
import org.xydra.store.impl.gae.changes.KeyStructure;
import org.xydra.store.impl.gae.changes.VoluntaryTimeoutException;
import org.xydra.store.impl.utils.DebugFormatter;
import org.xydra.xgae.XGae;
import org.xydra.xgae.datastore.api.SEntity;
import org.xydra.xgae.datastore.api.SKey;
import org.xydra.xgae.datastore.api.STransaction;

public class GaeChange {
    private static final Logger log = LoggerFactory.getLogger(GaeChange.class);
    private static final String PROP_LAST_ACTIVITY = "lastActivity";
    private static final String PROP_LOCKS = "locks";
    private static final String PROP_STATUS = "status";
    private static final String PROP_ACTOR = "actor";
    public static final long APPLICATION_RESERVED_TIME = 20000L;
    private static final long TIMEOUT = XGae.get().getRuntimeLimitInMillis() - 20000L;
    private static final long TIME_CRITICAL = TIMEOUT - 3000L;
    public final long rev;
    private long lastActivity;
    private GaeLocks locks;
    private final XAddress modelAddr;
    private SEntity entity;
    private Status status;
    private XId actor;
    private Pair<List<XAtomicEvent>, int[]> events;
    private transient XEvent event;
    private transient long timeoutCheckCount;

    public GaeChange(XAddress modelAddr, long rev, GaeLocks locks, XId actorId) {
        assert (TIME_CRITICAL < TIMEOUT);
        this.timeoutCheckCount = 0L;
        this.rev = rev;
        this.locks = locks;
        this.modelAddr = modelAddr;
        this.entity = XGae.get().datastore().createEntity(KeyStructure.createChangeKey(modelAddr, rev));
        this.status = Status.Creating;
        this.entity.setAttribute(PROP_STATUS, (long)this.status.value);
        this.actor = actorId;
        if (actorId != null) {
            this.entity.setAttribute(PROP_ACTOR, actorId.toString());
        }
        this.entity.setAttribute(PROP_LOCKS, locks.encode());
        this.registerActivity();
    }

    private void clearCache() {
        this.locks = null;
        this.lastActivity = -1L;
        this.actor = null;
        this.status = null;
        this.events = null;
        this.event = null;
    }

    public GaeChange(XAddress modelAddr, long rev, SEntity entity) {
        assert (TIME_CRITICAL < TIMEOUT);
        this.timeoutCheckCount = 0L;
        if (entity == null) {
            throw new IllegalArgumentException("entity is null");
        }
        this.entity = entity;
        this.rev = rev;
        this.modelAddr = modelAddr;
        assert (entity == Memcache.NULL_ENTITY || KeyStructure.assertRevisionInKey(entity.getKey(), rev));
        this.clearCache();
    }

    public void reload(STransaction trans) {
        XyAssert.xyAssert((boolean)this.getStatus().canChange());
        this.entity = XGae.get().datastore().sync().getEntity(this.entity.getKey(), trans);
        assert (this.entity != null) : "change entities should not vanish";
        this.clearCache();
    }

    public void reload() {
        this.reload(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XId getActor() {
        if (this.actor == null) {
            GaeChange gaeChange = this;
            synchronized (gaeChange) {
                String actorStr = (String)this.entity.getAttribute(PROP_ACTOR);
                if (actorStr == null) {
                    return null;
                }
                this.actor = Base.toId((String)actorStr);
            }
        }
        return this.actor;
    }

    public boolean isTimedOut() {
        if (!this.getStatus().canChange()) {
            return false;
        }
        if (this.lastActivity < 0L) {
            this.lastActivity = (Long)this.entity.getAttribute(PROP_LAST_ACTIVITY);
        }
        return GaeChange.now() - this.lastActivity > TIMEOUT;
    }

    public void commitAndClearLocks(Status status) {
        assert (this.getStatus().canChange());
        this.locks = null;
        this.entity.removeAttribute(PROP_LOCKS);
        this.setStatus(status);
        XGae.get().datastore().sync().putEntity(this.entity);
    }

    public void setStatus(Status status) {
        XyAssert.xyAssert((boolean)this.getStatus().canChange(), (Object)"A commited change cannot change its status");
        this.status = status;
        this.entity.setAttribute(PROP_STATUS, (long)status.value);
    }

    public synchronized GaeLocks getLocks() {
        XyAssert.xyAssert((boolean)this.getStatus().canChange());
        if (this.locks == null) {
            List lockStrs = (List)this.entity.getAttribute(PROP_LOCKS);
            if (lockStrs == null) {
                return null;
            }
            this.locks = new GaeLocks(lockStrs);
        }
        return this.locks;
    }

    public synchronized Status getStatus() {
        if (this.status == null) {
            Object o = this.entity.getAttribute(PROP_STATUS);
            if (o == null) {
                try {
                    throw new RuntimeException("Tracing caller of getStatus()");
                }
                catch (RuntimeException e) {
                    log.error("Accessing a change entity without status", (Throwable)e);
                }
            }
            Number n = (Number)o;
            assert (n != null) : "All change entities should have a status";
            int index = n.intValue();
            this.status = Status.get(index);
        }
        return this.status;
    }

    public boolean hasLocks() {
        return this.locks != null || this.entity.getAttribute(PROP_LOCKS) != null;
    }

    private void registerActivity() {
        XyAssert.xyAssert((boolean)this.getStatus().canChange());
        this.lastActivity = GaeChange.now();
        this.entity.setAttribute(PROP_LAST_ACTIVITY, this.lastActivity);
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    public void giveUpIfTimeoutCritical() throws VoluntaryTimeoutException {
        if (XGae.get().getRuntimeLimitInMillis() == -1L) {
            return;
        }
        if (!XGae.get().inProduction()) {
            ++this.timeoutCheckCount;
            if (this.timeoutCheckCount > 10000L) {
                throw new RuntimeException("Waiting to long");
            }
            return;
        }
        XyAssert.xyAssert((boolean)this.getStatus().canChange());
        long now = GaeChange.now();
        if (now - this.lastActivity > TIME_CRITICAL) {
            throw new VoluntaryTimeoutException("voluntarily timing out to prevent multiple processes working in the same thread;  start time was " + this.lastActivity + "; now is " + now);
        }
    }

    public Pair<int[], List<Future<SKey>>> setEvents(List<XAtomicEvent> events) {
        XyAssert.xyAssert((boolean)this.getStatus().canChange());
        XyAssert.xyAssert((events.size() >= 1 ? 1 : 0) != 0);
        Pair<int[], List<Future<SKey>>> res = GaeEvents.saveEvents(this.modelAddr, this.entity, events);
        this.events = new Pair(events, res.getFirst());
        return res;
    }

    public void save(STransaction trans) {
        XyAssert.xyAssert((boolean)this.getStatus().canChange());
        this.registerActivity();
        XGae.get().datastore().async().putEntity(this.entity, trans);
    }

    public Future<SKey> save() {
        XyAssert.xyAssert((boolean)this.getStatus().canChange());
        this.registerActivity();
        XyAssert.xyAssert((boolean)this.getStatus().canChange(), (Object)"getStatus().canChange()");
        XyAssert.xyAssert((this.entity.getAttribute("eventTypes") != null ? 1 : 0) != 0, (Object)"Trying to save changeEntity with PROP_EVENT_TYPES==null");
        return XGae.get().datastore().async().putEntity(this.entity);
    }

    public synchronized Pair<List<XAtomicEvent>, int[]> getAtomicEvents() {
        XyAssert.xyAssert((boolean)this.getStatus().hasEvents());
        if (this.events == null) {
            Pair<XAtomicEvent[], int[]> res = GaeEvents.loadAtomicEvents(this.modelAddr, this.rev, this.getActor(), this.entity);
            this.events = new Pair(Arrays.asList((Object[])res.getFirst()), res.getSecond());
        }
        return this.events;
    }

    public boolean isConflicting(GaeChange otherChange) {
        GaeLocks ourLocks = this.getLocks();
        GaeLocks otherLocks = otherChange.getLocks();
        assert (ourLocks != null) : "our locks should not be removed before change is commited";
        assert (otherLocks != null) : "locks should not be removed before change is commited";
        return ourLocks.isConflicting(otherLocks);
    }

    public synchronized XEvent getEvent() {
        if (this.event == null) {
            if (!this.getStatus().hasEvents()) {
                return null;
            }
            List events = (List)this.getAtomicEvents().getFirst();
            XyAssert.xyAssert((events.size() > 0 ? 1 : 0) != 0);
            this.event = events.size() == 1 ? (XEvent)events.get(0) : MemoryTransactionEvent.createTransactionEvent((XId)this.getActor(), (XAddress)this.modelAddr, (List)events, (long)(this.rev - 1L), (long)-21L);
            this.events = null;
        }
        return this.event;
    }

    public String toString() {
        return "rev:" + this.rev + " lastAct:" + this.lastActivity + " status:" + (Object)((Object)this.status) + " " + DebugFormatter.format((Object)this.entity);
    }

    public XId getActorId() {
        return this.actor;
    }

    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status Creating = new Status(0);
        public static final /* enum */ Status SuccessExecuted = new Status(3);
        public static final /* enum */ Status SuccessExecutedApplied = new Status(5);
        public static final /* enum */ Status SuccessNochange = new Status(4);
        public static final /* enum */ Status FailedPreconditions = new Status(100);
        public static final /* enum */ Status FailedTimeout = new Status(101);
        private final int value;
        private static final /* synthetic */ Status[] $VALUES;

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String name) {
            return Enum.valueOf(Status.class, name);
        }

        private Status(int value) {
            this.value = value;
        }

        public boolean isFailure() {
            return this == FailedPreconditions || this == FailedTimeout;
        }

        public boolean isSuccess() {
            return this == SuccessExecuted || this == SuccessNochange || this == SuccessExecutedApplied;
        }

        public boolean isCommitted() {
            return this.isSuccess() || this.isFailure();
        }

        public boolean hasEvents() {
            return this == SuccessExecuted || this == SuccessExecutedApplied;
        }

        public static Status get(int value) {
            Status status = null;
            switch (value) {
                case 0: {
                    status = Creating;
                    break;
                }
                case 3: {
                    status = SuccessExecuted;
                    break;
                }
                case 4: {
                    status = SuccessNochange;
                    break;
                }
                case 5: {
                    status = SuccessExecutedApplied;
                    break;
                }
                case 100: {
                    status = FailedPreconditions;
                    break;
                }
                case 101: {
                    status = FailedTimeout;
                }
            }
            assert (status != null && status.value == value);
            return status;
        }

        public boolean canChange() {
            return this == Creating || this == SuccessExecuted;
        }

        public boolean changedSomething() {
            return this == SuccessExecuted || this == SuccessExecutedApplied;
        }

        static {
            $VALUES = new Status[]{Creating, SuccessExecuted, SuccessExecutedApplied, SuccessNochange, FailedPreconditions, FailedTimeout};
        }
    }
}

