/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae.changes;

import com.google.common.cache.Cache;
import java.util.HashMap;
import java.util.Map;
import org.xydra.base.XAddress;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.sharedutils.XyAssert;
import org.xydra.store.impl.gae.InstanceContext;
import org.xydra.store.impl.gae.changes.GaeChange;
import org.xydra.xgae.util.XGaeDebugHelper;

public class CommitedChanges {
    private static final Logger log = LoggerFactory.getLogger(CommitedChanges.class);
    private static final String LOCAL_COMMITED_CHANGES_CACHENAME = "[.c1]";
    private static final String INSTANCE_COMMITED_CHANGES_CACHENAME = "[.c2]";
    private final XAddress modelAddr;
    private final Map<Long, GaeChange> localMap = new HashMap<Long, GaeChange>();

    public CommitedChanges(XAddress modelAddress) {
        this.modelAddr = modelAddress;
    }

    GaeChange getCachedChange(long rev) {
        GaeChange change = this.localMap.get(rev);
        log.trace(XGaeDebugHelper.dataGet((String)(LOCAL_COMMITED_CHANGES_CACHENAME + this.modelAddr), (String)("" + rev), (Object)change, (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Now));
        return change;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GaeChange getInstanceCachedChange(long rev) {
        GaeChange change;
        Map<Long, GaeChange> committedChangeCache;
        Map<Long, GaeChange> map = committedChangeCache = this.getInstanceCommittedChangeCache();
        synchronized (map) {
            change = committedChangeCache.get(rev);
        }
        log.trace(XGaeDebugHelper.dataGet((String)(LOCAL_COMMITED_CHANGES_CACHENAME + this.modelAddr), (String)("" + rev), (Object)change, (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Now));
        return change;
    }

    boolean hasCachedChange(long rev) {
        return this.localMap.containsKey(rev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasInstanceCachedChange(long rev) {
        Map<Long, GaeChange> committedChangeCache;
        Map<Long, GaeChange> map = committedChangeCache = this.getInstanceCommittedChangeCache();
        synchronized (map) {
            return committedChangeCache.containsKey(rev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, GaeChange> getInstanceCommittedChangeCache() {
        HashMap committedChangeCache;
        Cache<String, Object> instanceCache;
        String key = "changes:" + this.modelAddr;
        Cache<String, Object> cache = instanceCache = InstanceContext.getInstanceCache();
        synchronized (cache) {
            committedChangeCache = (HashMap)instanceCache.getIfPresent((Object)key);
            if (committedChangeCache == null) {
                log.debug(XGaeDebugHelper.init((String)INSTANCE_COMMITED_CHANGES_CACHENAME));
                committedChangeCache = new HashMap();
                InstanceContext.getInstanceCache().put((Object)key, committedChangeCache);
            }
        }
        return committedChangeCache;
    }

    public void cacheStableChange(GaeChange change) {
        XyAssert.xyAssert((change != null ? 1 : 0) != 0);
        assert (change != null);
        assert (change.getStatus() != null);
        XyAssert.xyAssert((!change.getStatus().canChange() ? 1 : 0) != 0);
        log.trace(XGaeDebugHelper.dataPut((String)(LOCAL_COMMITED_CHANGES_CACHENAME + this.modelAddr), (String)("" + change.rev), (Object)change, (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Now));
        this.localMap.put(change.rev, change);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheInstanceCommittedChange(GaeChange change) {
        Map<Long, GaeChange> committedChangeCache;
        XyAssert.xyAssert((change != null ? 1 : 0) != 0);
        assert (change != null);
        XyAssert.xyAssert((!change.getStatus().canChange() ? 1 : 0) != 0);
        assert (change.getStatus() != null);
        log.trace(XGaeDebugHelper.dataPut((String)(INSTANCE_COMMITED_CHANGES_CACHENAME + this.modelAddr), (String)("" + change.rev), (Object)change, (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Now));
        Map<Long, GaeChange> map = committedChangeCache = this.getInstanceCommittedChangeCache();
        synchronized (map) {
            committedChangeCache.put(change.rev, change);
        }
    }
}

