/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae.changes;

import java.util.HashMap;
import java.util.Map;
import org.xydra.base.XAddress;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.sharedutils.XyAssert;
import org.xydra.store.impl.gae.changes.CommitedChanges;
import org.xydra.store.impl.gae.changes.GaeChange;

public class AllChanges {
    private static final Logger log = LoggerFactory.getLogger(AllChanges.class);
    private final Map<Long, GaeChange> localMap = new HashMap<Long, GaeChange>();
    private final CommitedChanges commitedChanges;

    public AllChanges(XAddress modelAddress) {
        this.commitedChanges = new CommitedChanges(modelAddress);
    }

    GaeChange getCachedChange(long rev) {
        GaeChange change = this.commitedChanges.getCachedChange(rev);
        if (change == null) {
            change = this.localMap.get(rev);
        }
        return change;
    }

    public void cacheCommittedChange(GaeChange change) {
        XyAssert.xyAssert((change != null ? 1 : 0) != 0);
        assert (change != null);
        if (!change.getStatus().canChange()) {
            this.commitedChanges.cacheStableChange(change);
        } else {
            this.localMap.put(change.rev, change);
        }
    }
}

