/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.xydra.annotations.Setting;
import org.xydra.base.Base;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.XType;
import org.xydra.base.change.XAtomicCommand;
import org.xydra.base.change.XCommand;
import org.xydra.base.change.XEvent;
import org.xydra.base.change.XTransaction;
import org.xydra.base.rmof.XWritableModel;
import org.xydra.base.rmof.XWritableObject;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.persistence.GetWithAddressRequest;
import org.xydra.persistence.ModelRevision;
import org.xydra.persistence.XydraPersistence;
import org.xydra.sharedutils.XyAssert;
import org.xydra.store.InternalStoreException;
import org.xydra.store.RequestException;
import org.xydra.store.XydraStore;
import org.xydra.store.XydraStoreAdmin;
import org.xydra.store.impl.delegate.DelegatingSecureStore;
import org.xydra.store.impl.gae.IGaeModelPersistence;
import org.xydra.store.impl.gae.InstanceContext;
import org.xydra.store.impl.gae.Memcache;
import org.xydra.store.impl.gae.changes.KeyStructure;
import org.xydra.store.impl.gae.changes.XIdLengthException;
import org.xydra.store.impl.gae.ng.GaeModelPersistenceNG;
import org.xydra.store.impl.utils.DebugFormatter;
import org.xydra.xgae.XGae;
import org.xydra.xgae.datastore.api.CommittedButStillApplyingException;
import org.xydra.xgae.datastore.api.DatastoreFailureException;
import org.xydra.xgae.datastore.api.DatastoreTimeoutException;
import org.xydra.xgae.datastore.api.SEntity;
import org.xydra.xgae.datastore.api.SKey;
import org.xydra.xgae.datastore.api.SPreparedQuery;

public class GaePersistence
implements XydraPersistence {
    private static final Logger log = LoggerFactory.getLogger(GaePersistence.class);
    public static final boolean CACHE_MODEL_PERSISTENCES = true;
    private static final int MAX_ID_LENGTH = 100;
    public static final String LAST_UNICODE_CHAR = "\uffff";
    private final Cache<XId, IGaeModelPersistence> modelPersistenceMap = CacheBuilder.newBuilder().maximumSize(10L).expireAfterAccess(5L, TimeUnit.MINUTES).build();
    private final XAddress repoAddr;

    private static void checkIdLength(XId id) {
        if (id != null && id.toString().length() > 100) {
            throw new XIdLengthException(id);
        }
    }

    private static void checkIdLengths(XAtomicCommand command) {
        XAddress addr = command.getChangedEntity();
        GaePersistence.checkIdLength(addr.getObject());
        GaePersistence.checkIdLength(addr.getField());
    }

    private static void checkIdLengths(XCommand command) {
        if (command instanceof XTransaction) {
            for (XAtomicCommand ac : (XTransaction)command) {
                GaePersistence.checkIdLengths(ac);
            }
        } else {
            assert (command instanceof XAtomicCommand);
            GaePersistence.checkIdLengths((XAtomicCommand)command);
        }
    }

    public static synchronized XydraStore create() {
        return new DelegatingSecureStore((XydraPersistence)new GaePersistence(GaePersistence.getDefaultRepositoryId()), XydraStoreAdmin.XYDRA_ADMIN_ID);
    }

    public static XId getDefaultRepositoryId() {
        return Base.toId((String)"data");
    }

    public GaePersistence(XId repoId) {
        log.debug("static stuff done");
        if (repoId == null) {
            throw new IllegalArgumentException("repoId was null");
        }
        GaePersistence.checkIdLength(repoId);
        this.repoAddr = Base.toAddress((XId)repoId, null, null, null);
    }

    private void checkAddress(XAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("address was null");
        }
        if (!this.repoAddr.equalsOrContains(address)) {
            throw new RequestException("address " + address + " is not contained in repository " + this.repoAddr);
        }
    }

    public synchronized void clear() {
        log.info("Clear");
        XGae.get().datastore().sync().clear();
        XGae.get().memcache().clear();
        this.modelPersistenceMap.invalidateAll();
        assert (this.modelPersistenceMap.asMap().isEmpty());
        this.modelPersistenceMap.cleanUp();
        assert (this.modelPersistenceMap.size() == 0L);
        InstanceContext.clear();
        Memcache.clear();
    }

    public synchronized long executeCommand(XId actorId, XCommand command) {
        log.info(actorId + " executes command: " + DebugFormatter.format((Object)command));
        if (actorId == null) {
            throw new IllegalArgumentException("actorId was null");
        }
        if (command == null) {
            throw new IllegalArgumentException("command was null");
        }
        this.checkAddress(command.getTarget());
        GaePersistence.checkIdLengths(command);
        XId modelId = command.getChangedEntity().getModel();
        GaePersistence.checkIdLength(modelId);
        try {
            IGaeModelPersistence mp = this.getModelPersistence(modelId);
            return mp.executeCommand(command, actorId);
        }
        catch (DatastoreTimeoutException e) {
            throw new InternalStoreException("Storage did not work - please retry", (Throwable)e, 503);
        }
        catch (DatastoreFailureException e) {
            throw new InternalStoreException("Storage failed. Don't retry.", (Throwable)e, 500);
        }
        catch (CommittedButStillApplyingException e) {
            throw new InternalStoreException("Storage waiting for some work to complete - please retry", (Throwable)e, 503);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Setting(value="decides which GAE impl is used")
    private IGaeModelPersistence getModelPersistence(XId modelId) {
        Cache<XId, IGaeModelPersistence> cache = this.modelPersistenceMap;
        synchronized (cache) {
            IGaeModelPersistence modelPersistence = null;
            modelPersistence = (IGaeModelPersistence)this.modelPersistenceMap.getIfPresent((Object)modelId);
            if (modelPersistence == null) {
                XAddress modelAddress = this.getModelAddress(modelId);
                XyAssert.xyAssert((modelAddress != null ? 1 : 0) != 0);
                modelPersistence = new GaeModelPersistenceNG(modelAddress);
                this.modelPersistenceMap.put((Object)modelId, (Object)modelPersistence);
            }
            return modelPersistence;
        }
    }

    public synchronized List<XEvent> getEvents(XAddress address, long beginRevision, long endRevision) {
        this.checkAddress(address);
        if (address.getModel() == null) {
            throw new RequestException("address must specify a model, was " + address);
        }
        log.debug("getEvents for " + address + " [" + beginRevision + "," + endRevision + "]");
        return this.getModelPersistence(address.getModel()).getEventsBetween(address, beginRevision, endRevision);
    }

    private XAddress getModelAddress(XId modelId) {
        return Base.resolveModel((XAddress)this.repoAddr, (XId)modelId);
    }

    public synchronized Set<XId> getManagedModelIds() {
        log.debug("getModelIds");
        String low = "0/" + this.repoAddr.getRepository();
        String high = low + LAST_UNICODE_CHAR;
        SPreparedQuery preparedQuery = XGae.get().datastore().sync().prepareRangeQuery("XCHANGE", true, low, high);
        HashSet<XId> managedModelIds = new HashSet<XId>();
        for (SEntity e : preparedQuery.asIterable()) {
            SKey key = e.getKey();
            XAddress xa = KeyStructure.getAddressFromChangeKey(key);
            assert (xa.getRepository().equals((Object)this.repoAddr.getRepository()));
            managedModelIds.add(xa.getModel());
        }
        log.debug("This repo " + this.repoAddr + " manages " + managedModelIds.size() + " models");
        return managedModelIds;
    }

    public synchronized ModelRevision getModelRevision(GetWithAddressRequest addressRequest) {
        this.checkAddress(addressRequest.address);
        if (addressRequest.address.getAddressedType() != XType.XMODEL) {
            throw new RequestException("address must refer to a model, was " + addressRequest);
        }
        log.debug("getModelRevision of " + addressRequest);
        IGaeModelPersistence mp = this.getModelPersistence(addressRequest.address.getModel());
        return mp.getModelRevision(addressRequest.includeTentative);
    }

    public synchronized XWritableModel getModelSnapshot(GetWithAddressRequest addressRequest) {
        this.checkAddress(addressRequest.address);
        if (addressRequest.address.getAddressedType() != XType.XMODEL) {
            throw new RequestException("address must refer to a model, was " + addressRequest);
        }
        log.debug("get model snapshot of " + addressRequest);
        return this.getModelPersistence(addressRequest.address.getModel()).getSnapshot(addressRequest.includeTentative);
    }

    public synchronized XWritableObject getObjectSnapshot(GetWithAddressRequest addressRequest) {
        this.checkAddress(addressRequest.address);
        if (addressRequest.address.getAddressedType() != XType.XOBJECT) {
            throw new RequestException("address must refer to an object, was " + addressRequest);
        }
        log.debug("get object snapshot of " + addressRequest);
        return this.getModelPersistence(addressRequest.address.getModel()).getObjectSnapshot(addressRequest.address.getObject(), addressRequest.includeTentative);
    }

    public XId getRepositoryId() {
        return this.repoAddr.getRepository();
    }

    public synchronized boolean hasManagedModel(XId modelId) {
        if (modelId == null) {
            throw new IllegalArgumentException("modelId was null");
        }
        log.debug("model '" + modelId + "' exists?");
        return this.getModelPersistence(modelId).modelHasBeenManaged();
    }
}

