/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae;

import java.util.Map;
import org.xydra.store.impl.gae.Memcache;
import org.xydra.store.impl.gae.changes.GaeChange;
import org.xydra.store.impl.gae.changes.GaeModelRevision;
import org.xydra.store.impl.gae.changes.KeyStructure;
import org.xydra.store.impl.utils.DebugFormatter;
import org.xydra.store.impl.utils.IDebugFormatter;
import org.xydra.xgae.datastore.api.SEntity;
import org.xydra.xgae.datastore.api.SKey;

public class GaeDebugFormatter
implements IDebugFormatter {
    public String format(Object value) {
        if (value instanceof SKey) {
            return KeyStructure.toString((SKey)value);
        }
        if (value instanceof SEntity) {
            SEntity e = (SEntity)value;
            if (e.equals(Memcache.NULL_ENTITY)) {
                return "NullEntity";
            }
            StringBuffer buf = new StringBuffer();
            buf.append("key:" + e.getKey() + " ");
            for (Map.Entry a : e.getAttributes().entrySet()) {
                String aKey = (String)a.getKey();
                Object aValue = a.getValue();
                buf.append("<br />" + aKey + ": " + DebugFormatter.formatString((String)(aValue == null ? "null" : aValue.toString()), (int)300, (boolean)true) + "; ");
            }
            return "Entity={" + buf.toString() + " }";
        }
        if (value instanceof GaeChange) {
            GaeChange c = (GaeChange)value;
            return "GaeChange {" + DebugFormatter.formatString((String)c.toString(), (int)1000, (boolean)false) + "}";
        }
        if (value instanceof GaeModelRevision) {
            GaeModelRevision g = (GaeModelRevision)value;
            return "GaeModelRevision {" + DebugFormatter.formatString((String)g.toString(), (int)140, (boolean)false) + "}";
        }
        return null;
    }
}

