/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.gae.admin;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xydra.common.NanoClock;
import org.xydra.gae.admin.GaeConfiguration;
import org.xydra.gae.admin.GaeConfigurationManager;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.Restless;
import org.xydra.restless.RestlessParameter;
import org.xydra.restless.utils.HtmlUtils;
import org.xydra.restless.utils.ServletUtils;
import org.xydra.restless.utils.SharedHtmlUtils;
import org.xydra.sharedutils.XyAssert;
import org.xydra.store.XydraConfigUtils;
import org.xydra.store.XydraRuntime;
import org.xydra.xgae.XGae;

public class GaeConfigurationResource {
    private static final Logger log = LoggerFactory.getLogger(GaeConfigurationResource.class);

    public static void restless(Restless r, String path) {
        r.addMethod(path + "/gaeconf", "GET", GaeConfigurationResource.class, "index", true, new RestlessParameter[0]);
    }

    private static void addCommonStyle(Writer w) throws IOException {
        w.write("<style type='text/css'>\nform { display:inline; } \n.cpodebug h1, .cpodebug h2, .cpodebug h3, .cpodebug h4{\r\n   color: #1E93F6;\r\n   font-size: 120%;\r\n}   \r\n.cpodebug div, \r\n.cpodebug span, \r\n.cpodebug h1, \r\n.cpodebug h2, \r\n.cpodebug h3, \r\n.cpodebug h4, \r\n.cpodebug h5, \r\n.cpodebug h6, \r\n.cpodebug p, \r\n.cpodebug blockquote, \r\n.cpodebug pre,\r\n.cpodebug a, \r\n.cpodebug code, \r\n.cpodebug img, \r\n.cpodebug dl, \r\n.cpodebug dt, \r\n.cpodebug dd, \r\n.cpodebug ol, \r\n.cpodebug ul, \r\n.cpodebug li,\r\n.cpodebug table, \r\n.cpodebug tbody, \r\n.cpodebug tfoot, \r\n.cpodebug thead, \r\n.cpodebug tr, \r\n.cpodebug th, \r\n.cpodebug td {\r\n    margin: 4px;\r\n    padding: 2px;\r\n}   \r\n.cpodebug dt { color: white; background-color: #1E93F6; display: inline; }\r\n.cpodebug dd { margin-left: 15px; display: inline; }\r\n.cpodebug dd { display: block; }\r\n\r\n.cpodebug .key {\r\n   color: #1E93F6;\r\n   font-weight: bold;\r\n} \r\n.cpodebug .comment {\r\n\t\t  width: 25%;\r\n\t\t  white-space: normal;\r\n}\r\n\r\n.cpodebug th, .cpodebug td {\r\n  border: 1px solid #ccc;\r\n}</style>");
    }

    public static void index(HttpServletRequest req, HttpServletResponse res) throws IOException {
        GaeConfigurationManager.assertValidGaeConfiguration();
        NanoClock c = new NanoClock().start();
        ServletUtils.headers((HttpServletResponse)res, (String)"text/html");
        PrintWriter w = res.getWriter();
        HtmlUtils.writeHtmlHeaderOpenBody((Writer)w, (String)("GAE cache conf on instance " + XydraRuntime.getInstanceId()), (SharedHtmlUtils.HeadChild[])new SharedHtmlUtils.HeadChild[0]);
        ((Writer)w).flush();
        GaeConfigurationResource.addCommonStyle(w);
        ((Writer)w).write("Processing current request...<br />");
        ((Writer)w).write("Processing GAE back-end configuration from request...<br />");
        Map params = ServletUtils.getRequestparametersAsMap((HttpServletRequest)req);
        ((Writer)w).write("<dl class='cpodebug'>");
        ((Writer)w).write("<dt>Clear memcache</dt><dd>");
        GaeConfigurationResource.handleClearMemcache(params, w);
        ((Writer)w).write("</dd>");
        ((Writer)w).write("<dt>Process config now</dt><dd>");
        GaeConfigurationResource.handleProcessConfigNow(params, w);
        ((Writer)w).write("</dd>");
        ((Writer)w).write("</dl>");
        ((Writer)w).flush();
        ((Writer)w).write("Loading current GAE conf ...<br />");
        ((Writer)w).flush();
        GaeConfiguration gaeConf = GaeConfigurationManager.getCurrentConfiguration();
        assert (gaeConf.isStillValid());
        ((Writer)w).write("Valid for " + gaeConf.getTimeToLive() + " ms (until " + gaeConf.getValidUntilUTC() + ") <br />");
        ((Writer)w).flush();
        ((Writer)w).write("Processing updates to current conf ...<br />");
        ((Writer)w).flush();
        String validUntilUtcStr = (String)params.get("validUntilUTC");
        Map changeMap = XydraConfigUtils.getChanges(gaeConf.map(), (Map)params);
        boolean changes = false;
        for (String key : changeMap.keySet()) {
            String value = (String)changeMap.get(key);
            if (value.equals("")) {
                gaeConf.map().put(key, value);
                ((Writer)w).write("Config command: '" + key + "': ' => EMPTY<br />");
            } else {
                gaeConf.map().put(key, value);
                ((Writer)w).write("Config command: '" + key + "': ' => '" + value + "'<br />");
            }
            changes = true;
            ((Writer)w).flush();
        }
        if (changes) {
            ((Writer)w).write("Config changed. Persisting... ");
            GaeConfigurationResource.setNewTimeToLive(gaeConf, validUntilUtcStr, w);
            ((Writer)w).flush();
            gaeConf.store();
            ((Writer)w).write(" Done.<br/>");
            ((Writer)w).flush();
            ((Writer)w).write("Applying locally: Send changes to all local listeners ...");
            GaeConfigurationManager.fireOnChange(gaeConf);
            ((Writer)w).write(" Done.<br/>");
            ((Writer)w).flush();
        } else {
            ((Writer)w).write("No changes.<br/>");
        }
        ((Writer)w).flush();
        ((Writer)w).write("<h2>Config summary for instance " + XydraRuntime.getInstanceId() + " </h2>");
        long lastUpdateMsAgo = System.currentTimeMillis() - XydraRuntime.getLastTimeInitialisedAt();
        ((Writer)w).write("Last XydraRuntime init on this instance was " + lastUpdateMsAgo + " ms ago.<br />");
        TreeSet<Object> keys = new TreeSet<Object>();
        keys.addAll(params.keySet());
        keys.addAll(XydraRuntime.getConfigMap().keySet());
        keys.addAll(gaeConf.map().keySet());
        keys.remove("validUntilUTC");
        keys.add("usememcache");
        keys.add("memcacheStats");
        keys.add("persistenceStats");
        keys.add("clearvmcache");
        ((Writer)w).write("<form method='get' action='/admin/gaeconf' onSubmit='document.forms[0].__protoValue.name=document.forms[0].__protoKey.value;document.forms[0].removeChild(document.forms[0].__protoKey);'>");
        ((Writer)w).write("<table class='cpodebug'>");
        ((Writer)w).write("<tr><th scope='col'>Key</th><th scope='col'>Request</th><th scope='col'>GaeConf</th><th scope='col'>This instance</th></tr>");
        for (String string : keys) {
            String gaeConfValue = GaeConfigurationResource.normalize(gaeConf.map().get(string));
            ((Writer)w).write("<tr><td>" + string + "</td>" + "<td>" + GaeConfigurationResource.normalize((String)params.get(string)) + "</td>" + "<td>'" + gaeConfValue + "' => " + GaeConfigurationResource.formField(string, gaeConfValue) + "</td>" + "<td>" + GaeConfigurationResource.normalize((String)XydraRuntime.getConfigMap().get(string)) + "</td>" + "</tr>");
        }
        ((Writer)w).write("</table>");
        ((Writer)w).write("Add key = <input type='text' name='__protoKey' value='' />");
        ((Writer)w).write(", value = <input type='text' name='__protoValue' value='' /><br />");
        long now = System.currentTimeMillis();
        long in1Minute = now + 60000L;
        long in1Hour = now + 3600000L;
        long in1Day = now + 86400000L;
        ((Writer)w).write("Valid for <input type='radio' name='validUntilUTC' value='" + in1Minute + "'  checked='checked' />1 minute" + "<input type='radio' name='" + "validUntilUTC" + "' value='" + in1Hour + "'/>1 hour" + "<input type='radio' name='" + "validUntilUTC" + "' value='" + in1Day + "'/>1 day (careful)");
        ((Writer)w).write("<input type='submit' value='Save' />");
        ((Writer)w).write("<a href='/admin/gaeconf'>Browse only</a>");
        ((Writer)w).write("</form>");
        ((Writer)w).write("<hr />");
        ((Writer)w).write("<h3>Direct data on this instance</h3>");
        ((Writer)w).write("GaeAssert: <tt>" + XyAssert.isEnabled() + "</tt><br />");
        ((Writer)w).write("Memcache Stats: <tt>" + XGae.get().memcache().stats() + "</tt><br />");
        ((Writer)w).write("Memcache size: <tt>" + XGae.get().memcache().size() + "</tt><br />");
        ((Writer)w).flush();
        ((Writer)w).write("Processing stats for this request: " + c.stop("request").getStats() + " <br/>");
        HtmlUtils.endHtmlPage((Writer)w);
    }

    private static void handleProcessConfigNow(Map<String, String> params, Writer w) throws IOException {
        String value = GaeConfigurationResource.normalize(params.get("processconfignow"));
        if (!value.equals("")) {
            w.write("Force processing local gae conf (as it was before this request)<br/>");
            w.write("Force reload from datastore...<br/>");
            w.flush();
            GaeConfigurationManager.loadConfigOrUseDefaults();
            w.write("Force processing...<br/>");
            w.flush();
            GaeConfigurationManager.fireOnChange(GaeConfigurationManager.getCurrentConfiguration());
            w.write("<b>Done</b>.<br />");
            w.flush();
        } else {
            w.write("None. <a href='?processconfignow=true'>Request conf processing NOW</a><br />");
        }
        params.remove("processconfignow");
    }

    public static String normalize(String value) {
        if (value == null || value.trim().equals("") || value.trim().equals("null") || value.trim().equals("false")) {
            return "";
        }
        return value;
    }

    private static String formField(String key, String initialValue) {
        return "<input type='text' name='" + key + "' value='" + initialValue + "' />";
    }

    private static void setNewTimeToLive(GaeConfiguration currentConf, String validUntilUtcStr, Writer w) throws IOException {
        if (validUntilUtcStr == null) {
            log.warn("No paramter 'validUntilUTC' set. Using default 60 seconds.");
            currentConf.setValidUntilUTC(System.currentTimeMillis() + 60000L);
        } else {
            currentConf.setValidUntilUTC(Long.parseLong(validUntilUtcStr));
        }
        w.write("New config valid until " + currentConf.getValidUntilUTC() + " (set from web request) = expires in " + currentConf.getTimeToLive() + " ms<br />");
    }

    private static void handleClearMemcache(Map<String, String> params, Writer w) throws IOException {
        String value = GaeConfigurationResource.normalize(params.get("clearmemcache"));
        if (!value.equals("")) {
            w.write("Clearing memcache <b>now</b> (effective for all instances)<br />");
            w.flush();
            XGae.get().memcache().clear();
            w.write("<b>Cleared memcache</b>.<br />");
            w.flush();
        } else {
            w.write("No memcache clear requested. <a href='?clearmemcache=true'>Request one</a><br />");
        }
        params.remove("clearmemcache");
    }

    private static boolean onRightInstance(String requestedInstanceId) {
        return XydraRuntime.getInstanceId().equals(requestedInstanceId);
    }

    public static void setInstanceConfiguration(String instanceId, HttpServletResponse res) throws IOException {
        Writer w = HtmlUtils.startHtmlPage((HttpServletResponse)res, (String)("Setting configuration on instance " + XydraRuntime.getInstanceId()), (SharedHtmlUtils.HeadChild[])new SharedHtmlUtils.HeadChild[0]);
        w.write("InstanceID: " + XydraRuntime.getInstanceId() + "<br />");
        w.write("Requested instance: " + instanceId + "<br />");
        if (GaeConfigurationResource.onRightInstance(instanceId)) {
            w.write("Yeah, right instance");
        } else {
            w.write("No action. Please retry and hope your request will hit the right instance.");
        }
    }
}

