/*
 * Decompiled with CFR 0.152.
 */
package de.xam.textsearch.score;

import de.xam.textsearch.Match;
import de.xam.textsearch.score.DefaultScorer;
import de.xam.textsearch.score.IScorer;
import de.xam.textsearch.spi.IContentResolver;
import de.xam.textsearch.text.ITextQuery;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.xydra.index.impl.MapIndex;
import org.xydra.index.iterator.Iterators;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class Scores<V> {
    private static final Logger log = LoggerFactory.getLogger(Scores.class);
    private final IContentResolver<V> contentResolver;

    public Scores(IContentResolver<V> contentResolver) {
        this.contentResolver = contentResolver;
    }

    public IScorer<V> getScorerFulltextDefault() {
        return new DefaultScorer();
    }

    public List<Match<V>> score(ITextQuery<V> textquery, Iterator<V> resultIt, IScorer<V> scorer) {
        MapIndex map = new MapIndex();
        while (resultIt.hasNext()) {
            V id = resultIt.next();
            Match<V> match = new Match<V>(id);
            String content = this.contentResolver.getContentAsStringForTextIndexing(id);
            if (content == null) {
                log.warn("Read stale entity from index with ID=[" + id + "]");
                continue;
            }
            scorer.score(match, content, textquery.getPhrase(), textquery.getWords(), textquery.getFragments());
            Match existing = (Match)map.lookup(id);
            if (existing == null) {
                map.index(id, match);
                continue;
            }
            log.warn("For ID='" + id + "' have two matches 1=" + existing + " 2=" + match);
            if (existing.q() >= match.q()) continue;
            map.index(id, match);
        }
        return Iterators.toList((Iterator)map.iterator());
    }

    public List<Match<V>> score(ITextQuery<V> textquery, Set<V> resultSet, IScorer<V> scorer) {
        ArrayList<Match<V>> matches = new ArrayList<Match<V>>(resultSet.size());
        for (V id : resultSet) {
            Match<V> match = new Match<V>(id);
            String content = this.contentResolver.getContentAsStringForTextIndexing(id);
            scorer.score(match, content, textquery.getPhrase(), textquery.getWords(), textquery.getFragments());
            matches.add(match);
        }
        return matches;
    }
}

