/*
 * Decompiled with CFR 0.152.
 */
package de.xam.textsearch.score;

import de.xam.texthtml.text.TextTool;
import de.xam.textsearch.Match;
import de.xam.textsearch.score.IScorer;
import de.xam.textsearch.util.TextIndexTool;
import java.util.List;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class DefaultScorer<V>
implements IScorer<V> {
    private static final Logger log = LoggerFactory.getLogger(DefaultScorer.class);
    private static final double WEIGHT_PHRASE_SOLITAIRE_CASE = 120.0;
    private static final double WEIGHT_PHRASE_SOLITAIRE_NOCASE = 110.0;
    private static final double WEIGHT_PHRASE_INSIDE_CASE = 105.0;
    private static final double WEIGHT_PHRASE_INSISE_NOCASE = 100.0;
    private static final double WEIGHT_C = 12.0;
    private static final double WEIGHT_D = 10.0;
    private static final double WEIGHT_E = 1.2;
    private static final double WEIGHT_F = 1.0;

    @Override
    public synchronized void score(Match<V> match, String content, String phrase, List<String> words, List<String> fragments) {
        assert (content != null);
        assert (TextTool.trim((String)content).length() > 0);
        assert (phrase != null);
        assert (TextTool.trim((String)phrase).length() > 0);
        if (DefaultScorer.containsPadded(content, phrase)) {
            match.q = 120.0;
            match.addMatchedString(phrase);
        } else if (content.contains(phrase)) {
            match.q = 105.0;
            match.addMatchedString(phrase);
        } else {
            String phraseLowercase;
            String contentLowercase = content.toLowerCase();
            if (DefaultScorer.containsPadded(contentLowercase, phraseLowercase = phrase.toLowerCase())) {
                match.q = 110.0;
                match.addMatchedString(phrase);
            } else if (contentLowercase.contains(phraseLowercase)) {
                match.q = 100.0;
                match.addMatchedString(phrase);
            } else {
                double c = 1.0;
                double d = 1.0;
                double e = 1.0;
                double f = 1.0;
                int matchedWordsCaseSensitive = 0;
                int matchedWordsCaseInsensitive = 0;
                int matchedFragmentsCaseSensitive = 0;
                int matchedFragmentsCaseInsensitive = 0;
                int sumOfWordLengths = -1;
                int sumOfFragmentLengths = -1;
                if (!words.isEmpty()) {
                    sumOfWordLengths = TextIndexTool.sumOfStringLengths(words);
                    assert (sumOfWordLengths > 0) : words;
                    for (String word : words) {
                        assert (word != null);
                        assert (TextTool.trim((String)word).length() > 0);
                        if (content.contains(word)) {
                            matchedWordsCaseSensitive += word.length();
                            match.addMatchedString(word);
                            continue;
                        }
                        if (!contentLowercase.contains(word.toLowerCase())) continue;
                        matchedWordsCaseInsensitive += word.length();
                        match.addMatchedString(word);
                    }
                    c = (double)matchedWordsCaseSensitive / (double)sumOfWordLengths;
                    d = (double)matchedWordsCaseInsensitive / (double)sumOfWordLengths;
                }
                if (!fragments.isEmpty()) {
                    sumOfFragmentLengths = TextIndexTool.sumOfStringLengths(fragments);
                    assert (sumOfFragmentLengths > 0);
                    for (String fragment : fragments) {
                        if (match.hasMatchedString(fragment)) continue;
                        if (content.contains(fragment)) {
                            matchedFragmentsCaseSensitive += fragment.length();
                            match.addMatchedString(fragment);
                            continue;
                        }
                        if (!contentLowercase.contains(fragment)) continue;
                        matchedFragmentsCaseInsensitive += fragment.length();
                        match.addMatchedString(fragment);
                    }
                    e = (double)matchedFragmentsCaseSensitive / (double)sumOfFragmentLengths;
                    f = (double)matchedFragmentsCaseInsensitive / (double)sumOfFragmentLengths;
                }
                match.q = 12.0 * c + 10.0 * d + 1.2 * e + 1.0 * f;
                if (log.isTraceEnabled()) {
                    log.trace("q=" + match.q + " matchedWordsCaseSensitive=" + matchedWordsCaseSensitive + " matchedWordsCaseInsensitive=" + matchedWordsCaseInsensitive + " matchedfragmentsCaseSensitive=" + matchedFragmentsCaseSensitive + " matchedfragmentsCaseInsensitive=" + matchedFragmentsCaseInsensitive + " sumOfWordLengths=" + sumOfWordLengths + " sumOfFragmentLengths=" + sumOfFragmentLengths + "\n" + " c=" + c + " d=" + d + " e=" + e + " f=" + f);
                }
            }
        }
    }

    private static boolean containsPadded(String s, String part) {
        assert (s != null);
        int i = -1;
        do {
            if ((i = s.indexOf(part, i + 1)) == -1) {
                return false;
            }
            if (i != 0 && !DefaultScorer.isWhitespace(s.codePointAt(i - 1)) || i + part.length() != s.length() && !DefaultScorer.isWhitespace(s.codePointAt(i + part.length()))) continue;
            return true;
        } while (i >= 0);
        return false;
    }

    private static boolean isWhitespace(int c) {
        return c == 32 || c == 10 || c == 9 || c == 13;
    }

    public static void main(String[] args) {
        System.out.println(DefaultScorer.containsPadded("Hello World", "Hello"));
        System.out.println(DefaultScorer.containsPadded("Hello World", "World"));
        System.out.println(DefaultScorer.containsPadded("Hello World", "ell"));
    }
}

