/*
 * Decompiled with CFR 0.152.
 */
package de.xam.textsearch.query;

import com.google.gwt.thirdparty.guava.common.base.Joiner;
import de.xam.textsearch.query.AbstractCombinedQuery;
import de.xam.textsearch.query.IQuery;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xydra.index.iterator.ClosableIterator;
import org.xydra.index.iterator.ClosableIteratorAdapter;
import org.xydra.index.iterator.Iterators;

public class AndQuery<V>
extends AbstractCombinedQuery<V>
implements IQuery<V> {
    public static <V> AndQuery<V> create(IQuery<V> subQuery) {
        AndQuery<V> andQuery = new AndQuery<V>();
        return andQuery.and(subQuery);
    }

    public static <V> AndQuery<V> create() {
        AndQuery<V> andQuery = new AndQuery<V>();
        return andQuery;
    }

    public AndQuery<V> and(IQuery<V> subQuery) {
        this.add(subQuery);
        return this;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("(");
        Joiner.on((String)" AND ").appendTo(b, this.queries);
        b.append(")");
        return b.toString();
    }

    @Override
    public ClosableIterator<V> execute() {
        switch (this.queries.size()) {
            case 0: {
                return Iterators.none();
            }
            case 1: {
                return ((IQuery)this.queries.get(0)).execute();
            }
        }
        Set<V> intersection = this.intersect(this.queries);
        return new ClosableIteratorAdapter(intersection.iterator());
    }

    @Override
    public Set<V> executeToSet() {
        switch (this.queries.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return ((IQuery)this.queries.get(0)).executeToSet();
            }
        }
        Set<V> intersection = this.intersect(this.queries);
        return intersection;
    }

    private Set<V> intersect(List<IQuery<V>> queries) {
        int k;
        Set firstSet = null;
        for (k = 0; firstSet == null && k < this.queries.size(); ++k) {
            IQuery firstQuery = (IQuery)this.queries.get(k);
            firstSet = firstQuery.executeToSet();
        }
        if (k == this.queries.size()) {
            return Collections.emptySet();
        }
        assert (firstSet != null);
        HashSet result = new HashSet(firstSet.size());
        result.addAll(firstSet);
        for (int i = k; i < this.queries.size(); ++i) {
            Set ithSet = ((IQuery)this.queries.get(i)).executeToSet();
            if (ithSet == null) continue;
            result.retainAll(ithSet);
        }
        return result;
    }
}

