/*
 * Decompiled with CFR 0.152.
 */
package de.xam.textsearch.fragment;

import de.xam.textsearch.fragment.FragmentIndex;
import de.xam.textsearch.text.ITextQuery;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.xydra.index.iterator.ClosableIterator;
import org.xydra.index.iterator.IFilter;
import org.xydra.index.iterator.Iterators;
import org.xydra.index.query.Constraint;

public class FragmentQuery<V extends Serializable>
implements Constraint<String>,
ITextQuery<V> {
    private final String fragment;
    private final FragmentIndex<V> fragmentIndex;
    private int maxResults;
    private IFilter<V> optionalValueFilter = null;
    private boolean prefixMatch;

    public static <X extends Serializable> FragmentQuery<X> create(FragmentIndex<X> fragmentIndex, String fragment, boolean prefixMatch) {
        return new FragmentQuery<X>(fragmentIndex, fragment, prefixMatch, Integer.MAX_VALUE);
    }

    public FragmentQuery(FragmentIndex<V> fragmentIndex, String fragment, boolean prefixMatch, int maxResults) {
        this.fragmentIndex = fragmentIndex;
        this.fragment = fragment;
        this.prefixMatch = prefixMatch;
        this.maxResults = maxResults;
    }

    @Override
    public Set<V> executeToSet() {
        return this.fragmentIndex.executeQueryAsSet(this);
    }

    @Override
    public ClosableIterator<V> execute() {
        ClosableIterator<V> it = this.fragmentIndex.executeQuery(this);
        return Iterators.distinct(it);
    }

    public String getExpected() {
        return this.fragment;
    }

    public String getFragment() {
        return this.fragment;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public IFilter<V> getOptionalValueFilter() {
        return this.optionalValueFilter;
    }

    public boolean isExact() {
        return !this.isPrefixMatch();
    }

    public boolean isPrefixMatch() {
        return this.prefixMatch;
    }

    public boolean isStar() {
        return false;
    }

    public boolean matches(String element) {
        if (this.isPrefixMatch()) {
            return element.startsWith(this.fragment);
        }
        return element.equals(this.fragment);
    }

    @Override
    public FragmentQuery<V> setMaxResults(int m) {
        this.maxResults = m;
        return this;
    }

    public FragmentQuery<V> setPrefixMatch(boolean b) {
        this.prefixMatch = b;
        return this;
    }

    public FragmentQuery<V> setValueFilter(IFilter<V> optionalValueFilter) {
        this.optionalValueFilter = optionalValueFilter;
        return this;
    }

    @Override
    public String getPhrase() {
        return this.fragment;
    }

    @Override
    public List<String> getWords() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getFragments() {
        return Collections.singletonList(this.fragment);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("'");
        b.append(this.fragment);
        b.append("'");
        b.append(this.isExact() ? "" : "*");
        if (this.isLimited()) {
            b.append(" ");
            b.append("[max=");
            b.append(this.getMaxResults());
            b.append("]");
        }
        if (this.optionalValueFilter != null) {
            b.append(" filter:");
            b.append(this.optionalValueFilter.toString());
        }
        return b.toString();
    }

    public boolean isLimited() {
        return this.getMaxResults() < Integer.MAX_VALUE;
    }

    public boolean isFiltered() {
        return this.optionalValueFilter != null;
    }
}

