/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.io.rdf;

import com.calpano.kgif.io.FileFormat;
import com.calpano.kgif.io.common.IKgifStreamImporter;
import com.calpano.kgif.io.common.IStreamSource;
import com.calpano.kgif.io.rdf.AbstractRdfImporter;
import com.calpano.kgif.io.rdf.RdfCommon;
import com.calpano.kgif.v1_1_0.IEntityHandler;
import de.xam.mybase.model.IoProgressReporter;
import java.io.IOException;
import java.io.Reader;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.rdfxml.RDFXMLParser;

public class RdfXmlImporter
extends AbstractRdfImporter
implements IKgifStreamImporter {
    public RdfXmlImporter() {
        super(null);
    }

    @Override
    public FileFormat getFileFormat() {
        return RdfCommon.FILEFORMAT_RDF_XML;
    }

    @Override
    public void read(IStreamSource source, IEntityHandler eh, IoProgressReporter iop) throws IOException {
        this.clear();
        System.setProperty("entityExpansionLimit", "1000000");
        System.setProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
        RDFXMLParser parser = new RDFXMLParser();
        parser.setRDFHandler((RDFHandler)this.rdfHandler2Kgif);
        parser.setParseErrorListener(this.parseErrorListener);
        parser.setVerifyData(true);
        String baseUri = "http://id.denkwerkzeug.com/";
        try (Reader reader = source.getReader();){
            parser.parse(reader, "http://id.denkwerkzeug.com/");
        }
        catch (RDFParseException e) {
            throw new RuntimeException("Error", e);
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException("Error", e);
        }
    }

    @Override
    public String getLabel() {
        return "RDF/XML Importer";
    }
}

