/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.io.rdf;

import com.calpano.kgif.io.IIoContext;
import com.calpano.kgif.io.IStreamProcessProgressReporter;
import com.calpano.kgif.io.IoContext;
import com.calpano.kgif.io.common.util.KgifNIO;
import com.calpano.kgif.io.rdf.NTriples;
import com.calpano.kgif.io.rdf.RdfCommon;
import com.calpano.kgif.v1_1_0.IEntityHandler;
import com.calpano.kgif.v1_1_0.gen.Header;
import com.calpano.kgif.v1_1_0.gen.Link;
import com.calpano.kgif.v1_1_0.gen.Metadata;
import com.calpano.kgif.v1_1_0.gen.Node;
import com.calpano.kgif.v1_1_0.write.KgifWrites;
import de.xam.mybase.model.IoProgressReporter;
import de.xam.mybase.model.content.UriFormatter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.xydra.base.Base;
import org.xydra.index.IEntrySet;
import org.xydra.index.IMapSetIndex;
import org.xydra.index.impl.MapMapSetIndex;
import org.xydra.index.query.Constraint;
import org.xydra.index.query.KeyEntryTuple;
import org.xydra.index.query.Wildcard;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class RdfHandler2Kgif
implements RDFHandler {
    private long tripleCount = 0L;
    private final String formatName;
    protected IEntityHandler entityHandler;
    private final Map<BNode, String> bnode2id = new HashMap<BNode, String>();
    protected final IIoContext ioContext;
    String sourceName;
    private static final Logger log = LoggerFactory.getLogger(RdfHandler2Kgif.class);
    protected Map<String, String> namespaceMap = new HashMap<String, String>();
    private final MapMapSetIndex<Resource, String, Value> triples = MapMapSetIndex.createWithSmallSets();

    public RdfHandler2Kgif(String formatName, IStreamProcessProgressReporter progress) {
        this.formatName = formatName;
        this.ioContext = new IoContext(progress, "n/a");
    }

    private static void addRdfTypeInformation(Metadata metadata, Resource rdfResource, String rdfIdString) {
        if (rdfResource instanceof BNode) {
            KgifWrites.appendToMetadata((Metadata)metadata, (String)"id-semantics", (String)"bnode");
        } else {
            KgifWrites.appendToMetadata((Metadata)metadata, (String)"id-semantics", (String)"uri");
        }
        KgifWrites.appendToMetadata((Metadata)metadata, (String)"id-sourceSyntax", (String)rdfIdString);
    }

    public void endRDF() throws RDFHandlerException {
        this.progress("End of RDF, creating KGIF");
        try {
            this.generateKgifAndWrite(this.formatName, this.sourceName);
        }
        catch (IOException e1) {
            throw new RuntimeException("Error", e1);
        }
        this.progress("KGIF done");
        try {
            this.entityHandler.onGraphEnd(this.ioContext);
            this.entityHandler.onDocumentEnd(this.ioContext);
        }
        catch (IOException e) {
            throw new RuntimeException("Error", e);
        }
    }

    public void handleComment(String comment) throws RDFHandlerException {
    }

    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.namespaceMap.put(prefix, uri);
    }

    public void handleStatement(Statement stmt) throws RDFHandlerException {
        Resource s = stmt.getSubject();
        URI p = stmt.getPredicate();
        Value o = stmt.getObject();
        if (o instanceof Resource) {
            this.onUUU(s, p, (Resource)o);
        } else {
            this.onUUL(s, p, (Literal)o);
        }
        ++this.tripleCount;
        if (this.tripleCount % 1000L == 0L) {
            this.progress("Read " + this.tripleCount + " triples");
        }
    }

    public void startRDF() throws RDFHandlerException {
        this.progress("Start of RDF");
        try {
            this.entityHandler.onDocumentStart(this.ioContext);
        }
        catch (IOException e) {
            throw new RuntimeException("Error", e);
        }
    }

    private static void addLangTagAndDatatypeToMetadata(Metadata nodeMetadata, String language, URI datatype) {
        assert (language == null || datatype == null) : "rdf does not allow both";
        if (language != null) {
            KgifWrites.appendToMetadata((Metadata)nodeMetadata, (String)"rdf-langTag", (String)language);
        }
        if (datatype != null) {
            KgifWrites.appendToMetadata((Metadata)nodeMetadata, (String)"rdf-dataTypeUri", (String)datatype.stringValue());
        }
    }

    protected void onUUL(Resource s, URI p, Literal o) {
        String pId = this.toUriStr(p);
        this.triples.index((Object)s, (Object)pId, (Object)o);
    }

    protected void onUUU(Resource s, URI p, Resource o) {
        String pId = this.toUriStr(p);
        this.triples.index((Object)s, (Object)pId, (Object)o);
    }

    public void clear() {
        this.bnode2id.clear();
        this.namespaceMap.clear();
        this.namespaceMap.putAll(RdfCommon.NS_MAP_DEFAULTS);
        this.triples.clear();
        this.tripleCount = 0L;
    }

    protected String toBNodeId(BNode bnode) {
        String id = this.bnode2id.get(bnode);
        if (id == null) {
            id = bnode.getID();
            try {
                Base.toId((String)id);
            }
            catch (IllegalArgumentException e) {
                log.warn("Could not preserver BNode label '" + id + "'");
                id = RdfCommon.createRandomUniqueId();
            }
            this.bnode2id.put(bnode, id);
        }
        return id;
    }

    protected String toUriOrBnodeId(Resource r) {
        if (r instanceof BNode) {
            return this.toBNodeId((BNode)r);
        }
        assert (r instanceof URI);
        return this.toUriStr((URI)r);
    }

    protected String toUriStr(URI r) {
        return r.stringValue();
    }

    public void generateKgifAndWrite(String fileFormat, String fileSource) throws IOException {
        Header header = KgifWrites.createHeader((String)"KgifRdf", (String)"0.0.2", (String)(System.currentTimeMillis() + ""));
        Metadata metadata = new Metadata();
        header.setMetadata(metadata);
        KgifWrites.appendToMetadata((Metadata)metadata, (String)"sourceFormat", (String)this.formatName);
        KgifWrites.appendToMetadata((Metadata)metadata, (String)"sourceFilename", (String)this.sourceName);
        KgifNIO.appendNamespaceMapToMetadata(this.namespaceMap, metadata);
        this.entityHandler.onHeader(this.ioContext, header);
        this.entityHandler.onGraphStart(this.ioContext, null);
        HashSet<Resource> definedNodeResources = new HashSet<Resource>();
        HashSet<Object> usedNodeResources = new HashSet<Object>();
        Iterator keyIt = this.triples.keyIterator();
        while (keyIt.hasNext()) {
            Resource sResource = (Resource)keyIt.next();
            IMapSetIndex po = this.triples.lookup((Object)sResource);
            String string = this.toUriOrBnodeId(sResource);
            Metadata nodeMetadata = new Metadata();
            String labelStr = null;
            IEntrySet labels = po.lookup((Object)"http://www.w3.org/2000/01/rdf-schema#label");
            if (labels != null) {
                Literal chosenLiteral = null;
                if (labels.size() >= 1) {
                    HashMap<String, Literal> lang2lit = new HashMap<String, Literal>();
                    for (Value v : labels.toSet()) {
                        if (!(v instanceof Literal)) continue;
                        Literal lit = (Literal)v;
                        lang2lit.put(lit.getLanguage(), lit);
                    }
                    if (lang2lit.size() > 0) {
                        chosenLiteral = (Literal)lang2lit.get(null);
                        if (chosenLiteral == null) {
                            chosenLiteral = (Literal)lang2lit.get("en");
                        }
                        if (chosenLiteral == null) {
                            chosenLiteral = (Literal)lang2lit.get("de");
                        }
                        if (chosenLiteral == null) {
                            chosenLiteral = (Literal)lang2lit.values().iterator().next();
                        }
                    }
                    for (Literal lit : lang2lit.values()) {
                        if (lit.equals((Object)chosenLiteral)) continue;
                        String ntriplesLit = NTriples.toNTriplesLiteral(lit);
                        KgifWrites.appendToMetadata((Metadata)nodeMetadata, (String)"rdf-alternativeLabel", (String)ntriplesLit);
                    }
                }
                if (chosenLiteral != null) {
                    RdfHandler2Kgif.addLangTagAndDatatypeToMetadata(nodeMetadata, chosenLiteral.getLanguage(), chosenLiteral.getDatatype());
                    KgifWrites.appendToMetadata((Metadata)nodeMetadata, (String)"label-source", (String)"import");
                    labelStr = chosenLiteral.getLabel();
                }
            }
            if (labelStr == null) {
                String prettyLabel;
                labelStr = prettyLabel = UriFormatter.toShortAndRelevantString((String)string, this.namespaceMap, (boolean)true);
                KgifWrites.appendToMetadata((Metadata)nodeMetadata, (String)"label-source", (String)"generated");
            }
            String sId = RdfCommon.toKgifId(string, this.namespaceMap);
            Node node = KgifWrites.createNode((String)sId, (String)labelStr);
            RdfHandler2Kgif.addRdfTypeInformation(nodeMetadata, sResource, string);
            node.setMetadata(nodeMetadata);
            definedNodeResources.add(sResource);
            this.entityHandler.onNode(this.ioContext.refine(labelStr), node);
            Iterator poIt = po.tupleIterator((Constraint)new Wildcard(), (Constraint)new Wildcard());
            while (poIt.hasNext()) {
                KeyEntryTuple ket = (KeyEntryTuple)poIt.next();
                String pUriString = (String)ket.getKey();
                usedNodeResources.add(new URIImpl(pUriString));
                Value oValue = (Value)ket.getEntry();
                String pId = RdfCommon.toKgifId(pUriString, this.namespaceMap);
                if (oValue instanceof Resource) {
                    String oRdfIdOrBnodeIdStr = this.toUriOrBnodeId((Resource)oValue);
                    String oId = RdfCommon.toKgifId(oRdfIdOrBnodeIdStr, this.namespaceMap);
                    Link link = KgifWrites.createLink((String)sId, (String)pId, (String)oId);
                    usedNodeResources.add((Resource)oValue);
                    this.entityHandler.onLink(this.ioContext, link);
                    continue;
                }
                if (pUriString.equals("http://www.w3.org/2000/01/rdf-schema#label")) continue;
                String uuid = RdfCommon.createRandomUniqueId();
                Literal oLiteral = (Literal)oValue;
                String label = oLiteral.getLabel();
                URI dataTypeUri = oLiteral.getDatatype();
                String typeUriString = dataTypeUri == null ? "http://www.w3.org/2001/XMLSchema#string" : dataTypeUri.stringValue();
                Node propertyValueNode = KgifWrites.createNode((String)uuid, (String)label, (String)typeUriString);
                Metadata propertyValueNodeMetadata = new Metadata();
                KgifWrites.appendToMetadata((Metadata)propertyValueNodeMetadata, (String)"id-source", (String)"generated");
                KgifWrites.appendToMetadata((Metadata)propertyValueNodeMetadata, (String)"pmodel-att-displayAsProperty", (String)"true");
                RdfHandler2Kgif.addLangTagAndDatatypeToMetadata(propertyValueNodeMetadata, oLiteral.getLanguage(), dataTypeUri);
                propertyValueNode.setMetadata(propertyValueNodeMetadata);
                this.entityHandler.onNode(this.ioContext, propertyValueNode);
                Link link = KgifWrites.createLink((String)sId, (String)pId, (String)uuid);
                KgifWrites.setMetadataAttribute((Link)link, (String)"pmodel-att-displayAsProperty", (String)"true");
                this.entityHandler.onLink(this.ioContext, link);
            }
        }
        HashSet<Object> undefinedNodeResources = new HashSet<Object>();
        undefinedNodeResources.addAll(usedNodeResources);
        undefinedNodeResources.removeAll(definedNodeResources);
        for (Resource resource : undefinedNodeResources) {
            String rdfId = this.toUriOrBnodeId(resource);
            String prettyLabel = UriFormatter.toShortAndRelevantString((String)rdfId, this.namespaceMap, (boolean)true);
            String kgifId = RdfCommon.toKgifId(rdfId, this.namespaceMap);
            Node node = KgifWrites.createNode((String)kgifId, (String)prettyLabel);
            Metadata autogenNodeMetadata = new Metadata();
            RdfHandler2Kgif.addRdfTypeInformation(autogenNodeMetadata, resource, rdfId);
            KgifWrites.appendToMetadata((Metadata)autogenNodeMetadata, (String)"id-source", (String)"generated");
            KgifWrites.appendToMetadata((Metadata)autogenNodeMetadata, (String)"label-source", (String)"generated");
            node.setMetadata(autogenNodeMetadata);
            this.entityHandler.onNode(this.ioContext, node);
            definedNodeResources.add(resource);
        }
    }

    protected void progress(String progressMessage) {
        if (log.isTraceEnabled()) {
            log.trace("Progress: " + progressMessage);
        }
        if (this.ioContext.getProcessProgressReporter() != null) {
            this.ioContext.getProcessProgressReporter().reportProgress(progressMessage);
        }
    }

    public void setProgressReporter(final IoProgressReporter iop) {
        IStreamProcessProgressReporter progress = new IStreamProcessProgressReporter(){

            public void reportProgress(String progressMessage) {
                if (iop != null) {
                    iop.reportProgress(progressMessage);
                }
            }
        };
        this.ioContext.setProgressReporter(progress);
    }
}

