/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.io.rdf;

import com.calpano.kgif.io.FileFormat;
import com.calpano.kgif.io.common.IKgifStreamImporter;
import com.calpano.kgif.io.common.IStreamSource;
import com.calpano.kgif.io.rdf.AbstractRdfImporter;
import com.calpano.kgif.io.rdf.RdfCommon;
import com.calpano.kgif.v1_1_0.IEntityHandler;
import de.xam.mybase.model.IoProgressReporter;
import java.io.IOException;
import java.io.Reader;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.ntriples.NTriplesParser;

public class NTriplesImporter
extends AbstractRdfImporter
implements IKgifStreamImporter {
    public NTriplesImporter() {
        super(null);
    }

    @Override
    public FileFormat getFileFormat() {
        return RdfCommon.FILEFORMAT_RDF_NTRIPLES;
    }

    @Override
    public void read(IStreamSource source, IEntityHandler eh, IoProgressReporter iop) throws IOException {
        this.clear();
        NTriplesParser parser = new NTriplesParser();
        parser.setRDFHandler((RDFHandler)this.rdfHandler2Kgif);
        parser.setParseErrorListener(this.parseErrorListener);
        parser.setVerifyData(true);
        try (Reader reader = source.getReader();){
            parser.parse(reader, "");
        }
        catch (RDFParseException e) {
            throw new RuntimeException("Error", e);
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException("Error", e);
        }
    }

    @Override
    public String getLabel() {
        return "RDF/N-Triples Importer";
    }
}

