/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.io.rdf;

import com.calpano.kgif.io.IStreamProcessProgressReporter;
import com.calpano.kgif.io.common.IKgifStreamImporter;
import com.calpano.kgif.io.common.IRepeatableStreamSource;
import com.calpano.kgif.io.common.IStreamSource;
import com.calpano.kgif.io.common.impl.AbstractImporterToEntityHandler;
import com.calpano.kgif.io.common.impl.MemorySinkToSource;
import com.calpano.kgif.io.rdf.RdfHandler2Kgif;
import com.calpano.kgif.v1_1_0.IEntityHandler;
import de.xam.mybase.model.IoProgressReporter;
import java.io.IOException;
import org.openrdf.rio.ParseErrorListener;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public abstract class AbstractRdfImporter
extends AbstractImporterToEntityHandler
implements IKgifStreamImporter {
    private static final Logger log = LoggerFactory.getLogger(AbstractRdfImporter.class);
    protected RdfHandler2Kgif rdfHandler2Kgif;
    protected final ParseErrorListener parseErrorListener = new ParseErrorListener(){

        public void error(String msg, int lineNo, int colNo) {
            log.error(msg + " in input file at " + lineNo + ":" + colNo);
        }

        public void fatalError(String msg, int lineNo, int colNo) {
            log.error("FATAL: " + msg + " at input file " + lineNo + ":" + colNo);
        }

        public void warning(String msg, int lineNo, int colNo) {
            log.warn(msg + " at input file " + lineNo + ":" + colNo);
        }
    };

    @Override
    public void transformToEntityHandler(IStreamSource source, IEntityHandler entityHandler, IoProgressReporter iop) throws IOException {
        this.rdfHandler2Kgif.setProgressReporter(iop);
        this.clear();
        this.rdfHandler2Kgif.entityHandler = entityHandler;
        this.read(source, entityHandler, iop);
        source.close();
    }

    public abstract void read(IStreamSource var1, IEntityHandler var2, IoProgressReporter var3) throws IOException;

    public AbstractRdfImporter(IStreamProcessProgressReporter progress) {
        this.rdfHandler2Kgif = new RdfHandler2Kgif(this.getFileFormat().getFormatName(), progress);
        this.clear();
    }

    public void clear() {
        this.rdfHandler2Kgif.clear();
    }

    @Override
    public IRepeatableStreamSource convertToKgif1_1_0(IRepeatableStreamSource source, IoProgressReporter iop) throws IOException {
        MemorySinkToSource mss = new MemorySinkToSource("rdf-import");
        this.transform(source, mss, iop);
        return mss;
    }
}

