/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.io.common.util;

import com.calpano.kgif.io.common.IRepeatableStreamSource;
import com.calpano.kgif.io.common.IStreamSink;
import com.calpano.kgif.io.common.IStreamSource;
import com.calpano.kgif.io.common.IStreamTransformer;
import com.calpano.kgif.io.common.impl.FileStreamSink;
import com.calpano.kgif.io.common.impl.FileStreamSource;
import com.ibm.icu.text.CharsetDetector;
import de.xam.mybase.model.IoProgressReporter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class StreamSources {
    public static final int KB_1 = 1024;
    public static final int KB_16 = 16384;
    private static final Logger log = LoggerFactory.getLogger(StreamSources.class);
    public static final int MB_1 = 0x100000;

    public static void copyBytes(IStreamSource source, IStreamSink sink) throws IOException {
        try (InputStream in = source.getInputStream();
             OutputStream out = sink.openOutputStream();){
            int copied = IOUtils.copy((InputStream)in, (OutputStream)out);
            if (log.isTraceEnabled()) {
                log.trace("Wrote " + copied + " bytes to disk in " + sink.getSinkName());
            }
            out.flush();
        }
    }

    public static void copyCharacters(IStreamSource source, IStreamSink sink) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace("Copying from " + source.getEncoding() + " to UTF-8 (default)");
        }
        try (Reader reader = source.getReader();
             Writer writer = sink.openWriter();){
            IOUtils.copy((Reader)reader, (Writer)writer);
            writer.flush();
        }
    }

    public static Charset guessEncoding(IStreamSource source, Set<Charset> blacklist) throws IllegalStateException, IOException {
        InputStream in = source.getInputStream();
        CharsetDetector detector = new CharsetDetector();
        detector.setText(in);
        Object[] matches = detector.detectAll();
        if (matches == null || matches.length == 0) {
            return null;
        }
        log.trace("Detected " + Arrays.toString(matches));
        for (int i = 0; i < matches.length; ++i) {
            String charsetName = matches[i].getName();
            assert (charsetName != null);
            Charset cs = Charset.forName(charsetName);
            if (blacklist.contains(cs)) continue;
            return cs;
        }
        return null;
    }

    public static IRepeatableStreamSource makeRepeatableViaTempFile(IStreamSource streamSource, File tempFile) throws IOException {
        try (FileStreamSink fileSink = new FileStreamSink(tempFile);){
            StreamSources.copyBytes(streamSource, fileSink);
        }
        FileStreamSource fileSource = new FileStreamSource(tempFile);
        return fileSource;
    }

    public static void transformIfUpdated(IStreamSource source, IStreamTransformer transformer, IStreamSink sink, IoProgressReporter iop) throws IOException {
        long sourceAge = source.getLastModificationDateUTC();
        long sinkAge = sink.getLastModificationDateUTC();
        if (sourceAge != -1L && sinkAge != -1L && sourceAge <= sinkAge) {
            iop.reportProgress("Skipping transform " + source.getSourceName() + " -> " + sink.getSinkName());
        } else {
            try {
                transformer.transform(source, sink, iop);
            }
            catch (IOException e) {
                throw new IOException("While streaming from " + source.getSourceName() + " to " + sink.getSinkName(), e);
            }
        }
    }
}

