/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.io.common.util;

import com.calpano.kgif.io.IIoContext;
import com.calpano.kgif.io.IStreamProcessProgressReporter;
import com.calpano.kgif.io.common.IStreamSink;
import com.calpano.kgif.io.common.IStreamSource;
import com.calpano.kgif.io.common.impl.FileStreamSink;
import com.calpano.kgif.io.common.impl.FileStreamSource;
import com.calpano.kgif.io.common.util.TransformingEntityHandler;
import com.calpano.kgif.v1_1_0.IEntityHandler;
import com.calpano.kgif.v1_1_0.gen.Link;
import com.calpano.kgif.v1_1_0.gen.Node;
import com.calpano.kgif.v1_1_0.gen.Property;
import com.calpano.kgif.v1_1_0.read.KgifReadWriteException;
import com.calpano.kgif.v1_1_0.read.KgifReader;
import com.calpano.kgif.v1_1_0.write.KgifWrites;
import com.calpano.kgif.v1_1_0.write.WritingEntityHandler;
import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBException;

public class KgifTool {
    public static void transform(File kgifIn, File kgifOut, TransformingEntityHandler processor, IStreamProcessProgressReporter progress) throws KgifReadWriteException, IOException, JAXBException {
        FileStreamSource source = new FileStreamSource(kgifIn);
        FileStreamSink sink = new FileStreamSink(kgifOut);
        KgifTool.transform(source, sink, processor, progress);
        sink.close();
        source.close();
    }

    public static void transform(IStreamSource source, IStreamSink sink, TransformingEntityHandler processor, IStreamProcessProgressReporter progress) throws IOException {
        WritingEntityHandler baseEntityHandler = new WritingEntityHandler(sink.openWriter());
        processor.setBase((IEntityHandler)baseEntityHandler);
        try (KgifReader reader = new KgifReader(source.getReader(), (IEntityHandler)processor);){
            reader.read();
        }
        catch (KgifReadWriteException e) {
            progress.reportProgress("Parse problem at (line:col) " + e.getParseLocation() + ": " + (Object)((Object)e));
            throw new IOException(e);
        }
    }

    public static TransformingEntityHandler addMetadataAttributeToNodesAndLinks(final String attName, final String attValue) {
        return new TransformingEntityHandler(){

            @Override
            public void onLink(IIoContext ioContext, Link link) throws IOException, KgifReadWriteException {
                KgifWrites.setMetadataAttribute((Link)link, (String)attName, (String)attValue);
                this.base.onLink(ioContext, link);
            }

            @Override
            public void onNode(IIoContext ioContext, Node node) throws IOException, KgifReadWriteException {
                KgifWrites.setMetadataAttribute((Node)node, (String)attName, (String)attValue);
                this.base.onNode(ioContext, node);
            }

            @Override
            public void onProperty(IIoContext ioContext, Property property) throws IOException, KgifReadWriteException {
                KgifWrites.setMetadataAttribute((Property)property, (String)attName, (String)attValue);
                this.base.onProperty(ioContext, property);
            }
        };
    }
}

