/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.io.common.impl;

import com.calpano.kgif.io.IIoContext;
import com.calpano.kgif.io.common.IStreamSink;
import com.calpano.kgif.io.common.IStreamSource;
import com.calpano.kgif.io.common.IStreamTransformer;
import com.calpano.kgif.io.common.KgifRepairJob;
import com.calpano.kgif.io.common.util.KgifRepairs;
import com.calpano.kgif.io.common.util.TransformingEntityHandler;
import com.calpano.kgif.util.CleanXML;
import com.calpano.kgif.v1_1_0.IEntityHandler;
import com.calpano.kgif.v1_1_0.gen.Content;
import com.calpano.kgif.v1_1_0.gen.Label;
import com.calpano.kgif.v1_1_0.gen.Link;
import com.calpano.kgif.v1_1_0.gen.Node;
import com.calpano.kgif.v1_1_0.gen.Property;
import com.calpano.kgif.v1_1_0.read.KgifReadWriteException;
import com.calpano.kgif.v1_1_0.read.KgifReader;
import com.calpano.kgif.v1_1_0.read.MissingNodeIdEntityHandler;
import com.calpano.kgif.v1_1_0.write.WritingEntityHandler;
import de.xam.mybase.model.IoProgressReporter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;

public class AutorepairTransformer
implements IStreamTransformer {
    private final KgifRepairJob job;
    private final MissingNodeIdEntityHandler missingNodeEntityHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transform(IStreamSource source, IStreamSink sink, IoProgressReporter iop) throws IOException {
        try (Writer writer = sink.openWriter();
             WritingEntityHandler weh110 = new WritingEntityHandler(writer);){
            this.transformToEntityHandler(source, (IEntityHandler)weh110, iop);
        }
        finally {
            source.close();
        }
    }

    public void transformToEntityHandler(IStreamSource source, IEntityHandler entityHandler, IoProgressReporter iop) throws IOException {
        Reader reader = source.getReader();
        RepairingEntityHandler reh = new RepairingEntityHandler(entityHandler);
        try (KgifReader kr = new KgifReader(reader, (IEntityHandler)reh);){
            kr.read();
        }
        catch (KgifReadWriteException e) {
            iop.reportProgress("Parse problem at (line:col) " + e.getParseLocation() + ": " + (Object)((Object)e));
            iop.reportException((Throwable)e);
        }
    }

    @Override
    public String getLabel() {
        return "KGIF-Auto-Repair";
    }

    public AutorepairTransformer(KgifRepairJob repairJob) {
        this.job = repairJob;
        this.missingNodeEntityHandler = new MissingNodeIdEntityHandler();
    }

    private boolean isSameAsBefore(IIoContext ioContext, String currentId, Object current) {
        assert (currentId != null);
        Object before = this.missingNodeEntityHandler.lookupIdAndRecord(currentId, current);
        if (before == null) {
            return false;
        }
        if (ioContext.getProcessProgressReporter() != null) {
            boolean sameContent = EqualsBuilder.reflectionEquals((Object)before, (Object)current);
            if (sameContent) {
                ioContext.getProcessProgressReporter().reportProgress("Found same ID as before ('" + currentId + "'). Ignoring this occasion: " + current + ". Using this: " + before);
            } else {
                ioContext.getProcessProgressReporter().reportProgress("Found same ID as before ('" + currentId + "'). This time with different content: " + current + ". Using this: " + before);
            }
        }
        return true;
    }

    private void processContent(Content content) {
        if (content != null) {
            String contentType = content.getContentType();
            content.setContentType(KgifRepairs.repairContentType(contentType));
            if (this.job.isEnforceValidXML10()) {
                content.setContent(CleanXML.cleanStringForValidXmlContent((String)content.getContent()));
            }
        }
    }

    private class RepairingEntityHandler
    extends TransformingEntityHandler
    implements IEntityHandler {
        public RepairingEntityHandler(IEntityHandler baseEntityHandler) {
            super(baseEntityHandler);
        }

        @Override
        public void close() throws KgifReadWriteException, IOException {
            AutorepairTransformer.this.missingNodeEntityHandler.close();
            this.base.close();
        }

        @Override
        public void onGraphEnd(IIoContext ioContext) throws IOException {
            assert (ioContext != null);
            Set missingNodeIds = AutorepairTransformer.this.missingNodeEntityHandler.getMissingNodeIdStrings();
            KgifRepairs.addMissingNodes(ioContext, AutorepairTransformer.this.job, missingNodeIds, this.base);
            this.base.onGraphEnd(ioContext);
        }

        @Override
        public void onLink(IIoContext ioContext, Link link) throws IOException {
            if (link.getId() != null && AutorepairTransformer.this.isSameAsBefore(ioContext, link.getId(), link)) {
                return;
            }
            AutorepairTransformer.this.missingNodeEntityHandler.onLink(ioContext, link);
            this.base.onLink(ioContext, link);
        }

        @Override
        public void onNode(IIoContext ioContext, Node node) throws IOException {
            if (AutorepairTransformer.this.isSameAsBefore(ioContext, node.getId(), node)) {
                return;
            }
            Label label = node.getLabel();
            if (label != null) {
                String contentType = label.getContentType();
                label.setContentType(KgifRepairs.repairContentType(contentType));
                if (AutorepairTransformer.this.job.isEnforceValidXML10()) {
                    label.setContent(CleanXML.cleanStringForValidXmlContent((String)label.getContent()));
                }
            }
            Content content = node.getContent();
            AutorepairTransformer.this.processContent(content);
            this.base.onNode(ioContext, node);
        }

        @Override
        public void onProperty(IIoContext ioContext, Property property) throws IOException, KgifReadWriteException {
            if (AutorepairTransformer.this.isSameAsBefore(ioContext, property.getId(), property)) {
                return;
            }
            Content content = property.getContent();
            AutorepairTransformer.this.processContent(content);
            this.base.onProperty(ioContext, property);
        }
    }
}

