/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.io.common.impl;

import com.calpano.kgif.io.common.IStreamSource;
import com.calpano.kgif.io.common.impl.AbstractSourceOrSink;
import com.calpano.kgif.io.common.impl.NoUnicodeReplacementCharFilterReader;
import com.calpano.kgif.io.common.impl.PeekInputStream;
import com.calpano.kgif.io.common.impl.Xml10FilterReader;
import de.xam.cmodel.content.IanaContentType;
import de.xam.texthtml.text.Unicodes;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public abstract class AbstractStreamSource
extends AbstractSourceOrSink
implements IStreamSource {
    private static final Logger log = LoggerFactory.getLogger(AbstractStreamSource.class);
    private int bytebufferSize = 0;
    protected Charset encoding = Unicodes.UTF8;
    protected String ianaContentType = IanaContentType.APPLICATION__OCTECT_STREAM.getAsIanaContentTypeString();
    private PeekInputStream peekInputStream;
    private Reader reader;
    protected String sourceName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
            }
            finally {
                this.reader = null;
            }
        }
        if (this.peekInputStream != null) {
            try {
                this.peekInputStream.reallyClose();
            }
            catch (IOException iOException) {
            }
            finally {
                this.peekInputStream = null;
            }
        }
    }

    protected abstract InputStream createInputStream() throws IOException;

    @Override
    public int getByteBufferSize() {
        return this.bytebufferSize;
    }

    @Override
    public String getContentType() {
        return this.ianaContentType;
    }

    @Override
    public Charset getEncoding() {
        return this.encoding;
    }

    @Override
    public final InputStream getInputStream() throws IOException, IllegalStateException {
        if (this.peekInputStream != null && this.peekInputStream.isInBufferRange()) {
            this.peekInputStream.reset();
            return this.peekInputStream;
        }
        if (this.peekInputStream == null || this.isRepeatable()) {
            InputStream in = this.createInputStream();
            this.peekInputStream = new PeekInputStream(in, this.bytebufferSize);
            return this.peekInputStream;
        }
        throw new IllegalStateException("Non-repeatable stream was already consumed beyond buffer");
    }

    @Override
    public Reader getReader() throws IOException {
        this.getInputStream();
        if (log.isTraceEnabled()) {
            log.trace("Opening reader with encoding=" + this.encoding + " buffer=" + this.bytebufferSize + " on " + this.getSourceName());
        }
        this.reader = new InputStreamReader((InputStream)this.peekInputStream, this.encoding);
        if (this.isOption("READER__IGNORE_NON_XML1_0_CHARACTERS")) {
            this.reader = new Xml10FilterReader(this.reader);
        }
        if (this.isOption("READER__DISALLOW_UNICODE_REPLACEMENT_CHARACTER")) {
            this.reader = new NoUnicodeReplacementCharFilterReader(this.reader);
        }
        return this.reader;
    }

    @Override
    public String getSourceName() {
        return this.sourceName;
    }

    @Override
    public boolean isInBufferRange() {
        return this.peekInputStream.isInBufferRange();
    }

    protected abstract boolean isRepeatable();

    @Override
    public void setContentType(String contentType) {
        this.ianaContentType = contentType;
    }

    @Override
    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    @Override
    public void setMinBufferSize(int bufferSize) throws IllegalStateException {
        if (this.bytebufferSize < bufferSize) {
            if (this.peekInputStream == null) {
                this.bytebufferSize = bufferSize;
            } else {
                throw new IllegalStateException("Stream with buffersize=" + this.bytebufferSize + " was opened before. Cannot open buffersize=" + bufferSize + " now");
            }
        }
    }

    @Override
    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }
}

