/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.io.common;

import com.calpano.kgif.io.FileFormat;
import com.calpano.kgif.io.common.IKgifExporter;
import com.calpano.kgif.io.common.impl.KgifExporter;
import com.calpano.kgif.io.rdf.NTriplesExporter;
import com.calpano.kgif.io.rdf.RdfXmlExporter;
import java.util.HashSet;
import java.util.Set;

public class KnownKgifExporter {
    public static Set<IKgifExporter> exporter = new HashSet<IKgifExporter>();

    public static IKgifExporter getKgifExporter(FileFormat fileFormat) {
        for (IKgifExporter im : exporter) {
            if (!im.getFileFormat().equals((Object)fileFormat)) continue;
            return im;
        }
        return null;
    }

    public static void init() {
        exporter.add(new RdfXmlExporter());
        exporter.add(new NTriplesExporter());
        exporter.add(new KgifExporter());
    }

    public static IKgifExporter getKgifExporter(String filenameOrExtension) {
        for (IKgifExporter im : exporter) {
            String[] exts = im.getFileFormat().getExtensions();
            for (int j = 0; j < exts.length; ++j) {
                if (!filenameOrExtension.endsWith(exts[j])) continue;
                return im;
            }
        }
        return null;
    }

    public static boolean isKnownExportFormat(FileFormat fileFormat) {
        return KnownKgifExporter.getKgifExporter(fileFormat) != null;
    }

    static {
        KnownKgifExporter.init();
    }
}

