/*
 * Decompiled with CFR 0.152.
 */
package de.xam.memspace;

import de.xam.memspace.AbstractShellProfileNode;
import de.xam.memspace.ArrayIndexLink;
import de.xam.memspace.ArrayShellProfileNode;
import de.xam.memspace.ClassFieldLink;
import de.xam.memspace.IObjectProfileNode;
import de.xam.memspace.ObjectProfileNode;
import de.xam.memspace.ObjectShellProfileNode;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import org.xydra.annotations.IgnoreMemoryConsumption;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

abstract class ObjectProfiler {
    public static final int BOOLEAN_FIELD_SIZE = 1;
    public static final int BYTE_FIELD_SIZE = 1;
    public static final int CHAR_FIELD_SIZE = 2;
    private static final Map<Class<?>, ClassMetadata> CLASS_METADATA_CACHE = new WeakHashMap(101);
    public static final int DOUBLE_FIELD_SIZE = 8;
    public static final int FLOAT_FIELD_SIZE = 4;
    static final String INPUT_OBJECT_NAME = "<INPUT>";
    public static final int INT_FIELD_SIZE = 4;
    private static final Logger log = LoggerFactory.getLogger(ObjectProfiler.class);
    public static final int LONG_FIELD_SIZE = 8;
    public static final int OBJECT_SHELL_SIZE = 8;
    public static final int OBJREF_SIZE = 4;
    public static final boolean SHORT_COMMON_TYPE_NAMES = true;
    public static final int SHORT_FIELD_SIZE = 2;
    public static final boolean SHORT_TYPE_NAMES = false;

    private static int computeSizeof(Object obj_, IdentityHashMap<Object, Object> visited, Map<Class<?>, ClassMetadata> metadataMap) {
        Object object = obj_;
        if (object == null) {
            return 0;
        }
        log.info("Compute size of " + object.getClass().getCanonicalName());
        LinkedList<Object> queue = new LinkedList<Object>();
        visited.put(object, object);
        queue.add(object);
        int result = 0;
        ClassAccessPrivilegedAction caAction = new ClassAccessPrivilegedAction();
        FieldAccessPrivilegedAction faAction = new FieldAccessPrivilegedAction();
        while (!queue.isEmpty()) {
            object = queue.removeFirst();
            Class<?> objClass = object.getClass();
            if (objClass.isArray()) {
                int arrayLength = Array.getLength(object);
                Class<?> componentType = objClass.getComponentType();
                result += ObjectProfiler.sizeofArrayShell(arrayLength, componentType);
                if (componentType.isPrimitive()) continue;
                for (int i = 0; i < arrayLength; ++i) {
                    Object ref = Array.get(object, i);
                    if (ref == null || visited.containsKey(ref)) continue;
                    visited.put(ref, ref);
                    queue.addFirst(ref);
                }
                continue;
            }
            ClassMetadata metadata = ObjectProfiler.getClassMetadata(objClass, metadataMap, caAction, faAction);
            Field[] fields = metadata.refFields;
            result += metadata.shellSize;
            for (Field field : fields) {
                Object ref;
                if (ObjectProfiler.isMarkedAsIgnored(field)) {
                    log.info("Skipping annotated field '" + field.getName() + "' in " + object.getClass().getCanonicalName());
                    continue;
                }
                try {
                    ref = field.get(object);
                }
                catch (Exception e) {
                    throw new RuntimeException("cannot get field [" + field.getName() + "] of class [" + field.getDeclaringClass().getName() + "]: " + e.toString());
                }
                if (ref == null || visited.containsKey(ref)) continue;
                visited.put(ref, ref);
                queue.addFirst(ref);
            }
        }
        return result;
    }

    private static ObjectProfileNode createProfileTree(Object obj_, IdentityHashMap<Object, ObjectProfileNode> visited, Map<Class<?>, ClassMetadata> metadataMap) {
        Object object = obj_;
        ObjectProfileNode root = new ObjectProfileNode(null, object, null);
        LinkedList<ObjectProfileNode> queue = new LinkedList<ObjectProfileNode>();
        queue.addFirst(root);
        visited.put(object, root);
        ClassAccessPrivilegedAction caAction = new ClassAccessPrivilegedAction();
        FieldAccessPrivilegedAction faAction = new FieldAccessPrivilegedAction();
        while (!queue.isEmpty()) {
            AbstractShellProfileNode shell;
            ObjectProfileNode node = (ObjectProfileNode)queue.removeFirst();
            object = node.object;
            Class<?> objectClass = object.getClass();
            if (objectClass.isArray()) {
                int arrayLength = Array.getLength(object);
                Class<?> componentType = objectClass.getComponentType();
                shell = new ArrayShellProfileNode(node, objectClass, arrayLength);
                shell.size = ObjectProfiler.sizeofArrayShell(arrayLength, componentType);
                node.shell = shell;
                node.addFieldRef(shell);
                if (componentType.isPrimitive()) continue;
                for (int i = 0; i < arrayLength; ++i) {
                    Object ref = Array.get(object, i);
                    if (ref == null) continue;
                    ObjectProfileNode child = visited.get(ref);
                    if (child != null) {
                        ++child.refcount;
                        continue;
                    }
                    child = new ObjectProfileNode(node, ref, new ArrayIndexLink(node.link, i));
                    node.addFieldRef(child);
                    queue.addLast(child);
                    visited.put(ref, child);
                }
                continue;
            }
            ClassMetadata metadata = ObjectProfiler.getClassMetadata(objectClass, metadataMap, caAction, faAction);
            Field[] fields = metadata.refFields;
            shell = new ObjectShellProfileNode(node, metadata.primitiveFieldCount, metadata.refFields.length);
            shell.size = metadata.shellSize;
            node.shell = shell;
            node.addFieldRef(shell);
            for (Field field : fields) {
                Object ref;
                if (ObjectProfiler.isMarkedAsIgnored(field)) {
                    log.info("Skipping annotated field '" + field.getName() + "' in " + object.getClass().getCanonicalName());
                    continue;
                }
                try {
                    ref = field.get(object);
                }
                catch (Exception e) {
                    throw new RuntimeException("cannot get field [" + field.getName() + "] of class [" + field.getDeclaringClass().getName() + "]: " + e.toString());
                }
                if (ref == null) continue;
                ObjectProfileNode child = visited.get(ref);
                if (child != null) {
                    ++child.refcount;
                    continue;
                }
                child = new ObjectProfileNode(node, ref, new ClassFieldLink(field));
                node.addFieldRef(child);
                queue.addLast(child);
                visited.put(ref, child);
            }
        }
        return root;
    }

    private static ObjectProfileNode createProfileTree(Object obj_, IdentityHashMap<Object, ObjectProfileNode> visited, Map<Class<?>, ClassMetadata> metadataMap, String ... classnamesToIgnore) {
        Object obj = obj_;
        ObjectProfileNode root = new ObjectProfileNode(null, obj, null);
        LinkedList<ObjectProfileNode> queue = new LinkedList<ObjectProfileNode>();
        queue.addFirst(root);
        visited.put(obj, root);
        ClassAccessPrivilegedAction caAction = new ClassAccessPrivilegedAction();
        FieldAccessPrivilegedAction faAction = new FieldAccessPrivilegedAction();
        while (!queue.isEmpty()) {
            AbstractShellProfileNode shell;
            ObjectProfileNode node = (ObjectProfileNode)queue.removeFirst();
            obj = node.object;
            Class<?> objClass = obj.getClass();
            if (objClass.isArray()) {
                int arrayLength = Array.getLength(obj);
                Class<?> componentType = objClass.getComponentType();
                shell = new ArrayShellProfileNode(node, objClass, arrayLength);
                shell.size = ObjectProfiler.sizeofArrayShell(arrayLength, componentType);
                node.shell = shell;
                node.addFieldRef(shell);
                if (componentType.isPrimitive()) continue;
                for (int i = 0; i < arrayLength; ++i) {
                    Object ref = Array.get(obj, i);
                    if (ref == null) continue;
                    ObjectProfileNode child = visited.get(ref);
                    if (child != null) {
                        ++child.refcount;
                        continue;
                    }
                    child = new ObjectProfileNode(node, ref, new ArrayIndexLink(node.link, i));
                    node.addFieldRef(child);
                    if (!ObjectProfiler.skip(child, classnamesToIgnore)) {
                        queue.addLast(child);
                    }
                    visited.put(ref, child);
                }
                continue;
            }
            ClassMetadata metadata = ObjectProfiler.getClassMetadata(objClass, metadataMap, caAction, faAction);
            Field[] fields = metadata.refFields;
            shell = new ObjectShellProfileNode(node, metadata.primitiveFieldCount, metadata.refFields.length);
            shell.size = metadata.shellSize;
            node.shell = shell;
            node.addFieldRef(shell);
            for (Field field : fields) {
                Object ref;
                try {
                    ref = field.get(obj);
                }
                catch (Exception e) {
                    throw new RuntimeException("cannot get field [" + field.getName() + "] of class [" + field.getDeclaringClass().getName() + "]: " + e.toString());
                }
                if (ref == null) continue;
                ObjectProfileNode child = visited.get(ref);
                if (child != null) {
                    ++child.refcount;
                    continue;
                }
                child = new ObjectProfileNode(node, ref, new ClassFieldLink(field));
                node.addFieldRef(child);
                if (!ObjectProfiler.skip(child, classnamesToIgnore)) {
                    queue.addLast(child);
                }
                visited.put(ref, child);
            }
        }
        return root;
    }

    static String fieldName(Field field, boolean shortClassNames) {
        return ObjectProfiler.typeName(field.getDeclaringClass(), shortClassNames).concat("#").concat(field.getName());
    }

    private static void finishProfileTree(ObjectProfileNode node_) {
        ObjectProfileNode node = node_;
        LinkedList<IObjectProfileNode> queue = new LinkedList<IObjectProfileNode>();
        ObjectProfileNode lastFinished = null;
        while (node != null) {
            if (node.size == 1 || lastFinished == node.children[1]) {
                node.finish();
                lastFinished = node;
            } else {
                queue.addFirst(node);
                for (int i = 1; i < node.size; ++i) {
                    IObjectProfileNode child = node.children[i];
                    queue.addFirst(child);
                }
            }
            if (queue.isEmpty()) {
                return;
            }
            node = (ObjectProfileNode)queue.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassMetadata getClassMetadata(Class<?> clazz, Map<Class<?>, ClassMetadata> metadataMap, ClassAccessPrivilegedAction caAction, FieldAccessPrivilegedAction faAction) {
        Field[] declaredFields;
        ClassMetadata result;
        if (clazz == null) {
            return null;
        }
        Map<Class<?>, ClassMetadata> map = metadataMap;
        synchronized (map) {
            result = metadataMap.get(clazz);
        }
        if (result != null) {
            return result;
        }
        int primitiveFieldCount = 0;
        int shellSize = 8;
        LinkedList<Field> refFields = new LinkedList<Field>();
        try {
            caAction.setContext(clazz);
            declaredFields = (Field[])AccessController.doPrivileged(caAction);
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException("could not access declared fields of class " + clazz.getName() + ": " + pae.getException());
        }
        for (int f = 0; f < declaredFields.length; ++f) {
            Field field = declaredFields[f];
            if (Modifier.isStatic(field.getModifiers())) continue;
            if (ObjectProfiler.isMarkedAsIgnored(field)) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Skipping annotated field '" + field.getName() + "' in " + clazz.getCanonicalName());
                continue;
            }
            Class<?> fieldType = field.getType();
            if (fieldType.isPrimitive()) {
                shellSize += ObjectProfiler.sizeofPrimitiveType(fieldType);
                ++primitiveFieldCount;
                continue;
            }
            if (!field.isAccessible()) {
                try {
                    faAction.setContext(field);
                    AccessController.doPrivileged(faAction);
                }
                catch (PrivilegedActionException pae) {
                    throw new RuntimeException("could not make field " + field + " accessible: " + pae.getException());
                }
            }
            shellSize += 4;
            refFields.add(field);
        }
        ClassMetadata superMetadata = ObjectProfiler.getClassMetadata(clazz.getSuperclass(), metadataMap, caAction, faAction);
        if (superMetadata != null) {
            primitiveFieldCount += superMetadata.primitiveFieldCount;
            shellSize += superMetadata.shellSize - 8;
            refFields.addAll(Arrays.asList(superMetadata.refFields));
        }
        Field[] _refFields = new Field[refFields.size()];
        refFields.toArray(_refFields);
        result = new ClassMetadata(primitiveFieldCount, shellSize, _refFields);
        Map<Class<?>, ClassMetadata> map2 = metadataMap;
        synchronized (map2) {
            metadataMap.put(clazz, result);
        }
        return result;
    }

    private static boolean isMarkedAsIgnored(Field field) {
        return field.getAnnotation(IgnoreMemoryConsumption.class) != null;
    }

    public static String pathName(IObjectProfileNode[] path) {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < path.length; ++i) {
            if (i != 0) {
                s.append('/');
            }
            s.append(path[i].name());
        }
        return s.toString();
    }

    static IObjectProfileNode profile(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("null input: object");
        }
        IdentityHashMap<Object, ObjectProfileNode> visited = new IdentityHashMap<Object, ObjectProfileNode>();
        ObjectProfileNode root = ObjectProfiler.createProfileTree(object, visited, CLASS_METADATA_CACHE);
        ObjectProfiler.finishProfileTree(root);
        return root;
    }

    public static IObjectProfileNode profile(Object obj, String ... classnamesToIgnore) {
        if (obj == null) {
            throw new IllegalArgumentException("null input: obj");
        }
        IdentityHashMap<Object, ObjectProfileNode> visited = new IdentityHashMap<Object, ObjectProfileNode>(5);
        ObjectProfileNode root = ObjectProfiler.createProfileTree(obj, visited, CLASS_METADATA_CACHE, classnamesToIgnore);
        ObjectProfiler.finishProfileTree(root);
        return root;
    }

    public static int sizedelta(Object base, Object obj) {
        if (obj == null) {
            return 0;
        }
        if (base == null) {
            throw new IllegalArgumentException("null input: base");
        }
        IdentityHashMap<Object, Object> visited = new IdentityHashMap<Object, Object>();
        ObjectProfiler.computeSizeof(base, visited, CLASS_METADATA_CACHE);
        return visited.containsKey(obj) ? 0 : ObjectProfiler.computeSizeof(obj, visited, CLASS_METADATA_CACHE);
    }

    public static int sizeof(Object obj) {
        if (obj == null) {
            return 0;
        }
        IdentityHashMap<Object, Object> visited = new IdentityHashMap<Object, Object>();
        return ObjectProfiler.computeSizeof(obj, visited, CLASS_METADATA_CACHE);
    }

    private static int sizeofArrayShell(int length, Class<?> componentType) {
        int slotSize = componentType.isPrimitive() ? ObjectProfiler.sizeofPrimitiveType(componentType) : 4;
        return 16 + length * slotSize;
    }

    private static int sizeofPrimitiveType(Class<?> type) {
        if (type == Integer.TYPE) {
            return 4;
        }
        if (type == Long.TYPE) {
            return 8;
        }
        if (type == Short.TYPE) {
            return 2;
        }
        if (type == Byte.TYPE) {
            return 1;
        }
        if (type == Boolean.TYPE) {
            return 1;
        }
        if (type == Character.TYPE) {
            return 2;
        }
        if (type == Double.TYPE) {
            return 8;
        }
        if (type == Float.TYPE) {
            return 4;
        }
        throw new IllegalArgumentException("not primitive: " + type);
    }

    private static boolean skip(ObjectProfileNode node, String ... classnamesToIgnore) {
        String classname = node.object.getClass().getCanonicalName();
        if (classname == null) {
            classname = "anonymous";
        }
        for (String blacklistedClassname : classnamesToIgnore) {
            assert (blacklistedClassname != null);
            if (!classname.equals(blacklistedClassname)) continue;
            log.debug("ignored it");
            return true;
        }
        return false;
    }

    static String typeName(Class<?> cls_, boolean shortClassNames) {
        Class<?> cls = cls_;
        int dims = 0;
        while (cls.isArray()) {
            cls = cls.getComponentType();
            ++dims;
        }
        String clsName = cls.getName();
        if (shortClassNames) {
            int lastDot = clsName.lastIndexOf(46);
            if (lastDot >= 0) {
                clsName = clsName.substring(lastDot + 1);
            }
        } else if (clsName.startsWith("java.lang.")) {
            clsName = clsName.substring(10);
        } else if (clsName.startsWith("java.util.")) {
            clsName = clsName.substring(10);
        }
        for (int i = 0; i < dims; ++i) {
            clsName = clsName.concat("[]");
        }
        return clsName;
    }

    private ObjectProfiler() {
    }

    private static final class FieldAccessPrivilegedAction
    implements PrivilegedExceptionAction<Object> {
        private Field field;

        private FieldAccessPrivilegedAction() {
        }

        @Override
        public Object run() throws Exception {
            this.field.setAccessible(true);
            return null;
        }

        void setContext(Field field) {
            this.field = field;
        }
    }

    private static final class ClassMetadata {
        final int primitiveFieldCount;
        final Field[] refFields;
        final int shellSize;

        ClassMetadata(int primitiveFieldCount, int shellSize, Field[] refFields) {
            this.primitiveFieldCount = primitiveFieldCount;
            this.shellSize = shellSize;
            this.refFields = refFields;
        }
    }

    private static final class ClassAccessPrivilegedAction
    implements PrivilegedExceptionAction<Object> {
        private Class<?> clazz;

        private ClassAccessPrivilegedAction() {
        }

        @Override
        public Object run() throws Exception {
            return this.clazz.getDeclaredFields();
        }

        void setContext(Class<?> clazz) {
            this.clazz = clazz;
        }
    }
}

