/*
 * Decompiled with CFR 0.152.
 */
package de.xam.memspace;

import de.xam.memspace.IObjectProfileNode;
import de.xam.memspace.ObjectProfiler;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.NumberFormat;

abstract class ObjectProfileVisitors {
    static IObjectProfileNode.INodeVisitor newDefaultNodePrinter(Writer out, String indent, DecimalFormat format, boolean shortClassNames) {
        return new DefaultNodePrinter(out, indent, format, shortClassNames);
    }

    public static IObjectProfileNode.INodeVisitor newXMLNodePrinter(OutputStream out, String indent, DecimalFormat format, boolean shortClassNames) {
        return new XMLNodePrinter(out, indent, format, shortClassNames);
    }

    private ObjectProfileVisitors() {
    }

    private static final class XMLNodePrinter
    extends AbstractProfileNodeVisitor {
        private static final String ENCODING = "UTF-8";
        private final DecimalFormat format;
        private final String indent;
        private final PrintWriter out;
        private final boolean shortClassNames;

        private static void XMLEscape(String s, StringBuffer append) {
            char[] chars = s.toCharArray();
            int iLimit = s.length();
            block6: for (int i = 0; i < iLimit; ++i) {
                char c = chars[i];
                switch (c) {
                    case '<': {
                        append.append("&lt;");
                        continue block6;
                    }
                    case '>': {
                        append.append("&gt;");
                        continue block6;
                    }
                    case '\"': {
                        append.append("&#34;");
                        continue block6;
                    }
                    case '&': {
                        append.append("&amp;");
                        continue block6;
                    }
                    default: {
                        append.append(c);
                    }
                }
            }
        }

        XMLNodePrinter(OutputStream out, String indent, DecimalFormat format, boolean shortClassNames) {
            assert (out != null) : "null input: out";
            try {
                this.out = new PrintWriter(new OutputStreamWriter(out, ENCODING));
            }
            catch (UnsupportedEncodingException uee) {
                throw new Error(uee);
            }
            String string = this.indent = indent != null ? indent : "  ";
            if (format != null) {
                this.format = format;
            } else {
                this.format = (DecimalFormat)NumberFormat.getPercentInstance();
                this.format.setMaximumFractionDigits(2);
            }
            this.shortClassNames = shortClassNames;
        }

        @Override
        public void postvisit(IObjectProfileNode node) {
            StringBuffer indent = new StringBuffer();
            int pLimit = node.pathlength();
            for (int p = 0; p < pLimit; ++p) {
                indent.append(this.indent);
            }
            this.out.print(indent);
            this.out.println("</object>");
            if (node.root() == node) {
                this.out.println("</input>");
                this.out.flush();
            }
        }

        @Override
        public void previsit(IObjectProfileNode node) {
            boolean isRoot;
            IObjectProfileNode root = node.root();
            boolean bl = isRoot = root == node;
            if (isRoot) {
                this.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                this.out.println("<input>");
            }
            StringBuffer indent = new StringBuffer();
            int pLimit = node.pathlength();
            for (int p = 0; p < pLimit; ++p) {
                indent.append(this.indent);
            }
            StringBuffer sb = new StringBuffer();
            sb.append("<object");
            sb.append(" size=\"");
            sb.append(node.size());
            sb.append('\"');
            if (!isRoot) {
                sb.append(" part=\"");
                sb.append(this.format.format((double)node.size() / (double)root.size()));
                sb.append('\"');
            }
            sb.append(" name=\"");
            XMLNodePrinter.XMLEscape(node.name(), sb);
            sb.append('\"');
            if (node.object() != null) {
                sb.append(" objclass=\"");
                XMLNodePrinter.XMLEscape(ObjectProfiler.typeName(node.object().getClass(), this.shortClassNames), sb);
                sb.append('\"');
                if (node.refcount() > 1) {
                    sb.append(" refcount=\"");
                    sb.append(node.refcount());
                    sb.append('\"');
                }
            }
            sb.append('>');
            this.out.print(indent);
            this.out.println(sb);
        }
    }

    private static final class DefaultNodePrinter
    extends AbstractProfileNodeVisitor {
        private final DecimalFormat format;
        private final String indent;
        private final Writer out;
        private final boolean shortClassNames;
        private final boolean printObjectToString = false;

        DefaultNodePrinter(Writer out, String indent, DecimalFormat format, boolean shortClassNames) {
            assert (out != null) : "null input: out";
            this.out = out;
            String string = this.indent = indent != null ? indent : "  ";
            if (format != null) {
                this.format = format;
            } else {
                this.format = (DecimalFormat)NumberFormat.getPercentInstance();
                this.format.setMaximumFractionDigits(1);
            }
            this.shortClassNames = shortClassNames;
        }

        @Override
        public void previsit(IObjectProfileNode node) throws IOException {
            StringBuffer sb = new StringBuffer();
            int pLimit = node.pathlength();
            for (int p = 0; p < pLimit; ++p) {
                sb.append(this.indent);
            }
            IObjectProfileNode root = node.root();
            sb.append(node.size());
            if (node != root) {
                sb.append(" (");
                sb.append(this.format.format((double)node.size() / (double)root.size()));
                sb.append(")");
            }
            sb.append(" -> ");
            sb.append(node.name());
            if (node.object() != null) {
                sb.append(" : ");
                sb.append(ObjectProfiler.typeName(node.object().getClass(), this.shortClassNames));
                if (node.refcount() > 1) {
                    sb.append(", refcount=");
                    sb.append(node.refcount());
                }
                this.getClass();
            }
            this.out.write(sb + "\n");
            this.out.flush();
        }
    }

    private static abstract class AbstractProfileNodeVisitor
    implements IObjectProfileNode.INodeVisitor {
        private AbstractProfileNodeVisitor() {
        }

        @Override
        public void postvisit(IObjectProfileNode node) {
        }

        @Override
        public void previsit(IObjectProfileNode node) throws IOException {
        }
    }
}

