/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.web;

import com.googlecode.gwt.test.internal.utils.LinkedCaseInsensitiveMap;
import com.googlecode.gwt.test.web.DelegatingServletOutputStream;
import com.googlecode.gwt.test.web.HeaderValueHolder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.ObjectAssert;
import org.fest.assertions.api.StringAssert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockHttpServletResponse
implements HttpServletResponse {
    public static final int DEFAULT_SERVER_PORT = 80;
    private static final String CHARSET_PREFIX = "charset=";
    private static final String DEFAULT_CHARACTER_ENCODING = "ISO-8859-1";
    private int bufferSize = 4096;
    private String characterEncoding = "ISO-8859-1";
    private boolean committed;
    private final ByteArrayOutputStream content = new ByteArrayOutputStream();
    private int contentLength = 0;
    private String contentType;
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private String errorMessage;
    private String forwardedUrl;
    private final Map<String, HeaderValueHolder> headers = new LinkedCaseInsensitiveMap<HeaderValueHolder>();
    private final List<String> includedUrls = new ArrayList<String>();
    private Locale locale = Locale.getDefault();
    private final ServletOutputStream outputStream = new ResponseServletOutputStream(this.content);
    private boolean outputStreamAccessAllowed = true;
    private String redirectedUrl;
    private int status = 200;
    private PrintWriter writer;
    private boolean writerAccessAllowed = true;

    public void addCookie(Cookie cookie) {
        ((ObjectAssert)Assertions.assertThat((Object)cookie).as("Cookie must not be null")).isNotNull();
        this.cookies.add(cookie);
    }

    public void addDateHeader(String name, long value) {
        this.addHeaderValue(name, value);
    }

    public void addHeader(String name, String value) {
        this.addHeaderValue(name, value);
    }

    public void addIncludedUrl(String includedUrl) {
        ((StringAssert)Assertions.assertThat((String)includedUrl).as("Included URL must not be null")).isNotNull();
        this.includedUrls.add(includedUrl);
    }

    public void addIntHeader(String name, int value) {
        this.addHeaderValue(name, value);
    }

    public boolean containsHeader(String name) {
        return HeaderValueHolder.getByName(this.headers, name) != null;
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String encodeRedirectURL(String url) {
        return this.encodeURL(url);
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeURL(String url) {
        return url;
    }

    public void flushBuffer() {
        this.setCommitted(true);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public byte[] getContentAsByteArray() {
        this.flushBuffer();
        return this.content.toByteArray();
    }

    public String getContentAsString() throws UnsupportedEncodingException {
        this.flushBuffer();
        return this.characterEncoding != null ? this.content.toString(this.characterEncoding) : this.content.toString();
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Cookie getCookie(String name) {
        ((StringAssert)Assertions.assertThat((String)name).as("Cookie name must not be null")).isNotNull();
        for (Cookie cookie : this.cookies) {
            if (!name.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    public Cookie[] getCookies() {
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getForwardedUrl() {
        return this.forwardedUrl;
    }

    public Object getHeader(String name) {
        HeaderValueHolder header = HeaderValueHolder.getByName(this.headers, name);
        return header != null ? header.getValue() : null;
    }

    public Set<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public List<Object> getHeaders(String name) {
        HeaderValueHolder header = HeaderValueHolder.getByName(this.headers, name);
        return header != null ? header.getValues() : Collections.emptyList();
    }

    public String getIncludedUrl() {
        int count = this.includedUrls.size();
        if (count > 1) {
            throw new IllegalStateException("More than 1 URL included - check getIncludedUrls instead: " + this.includedUrls);
        }
        return count == 1 ? this.includedUrls.get(0) : null;
    }

    public List<String> getIncludedUrls() {
        return this.includedUrls;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ServletOutputStream getOutputStream() {
        if (!this.outputStreamAccessAllowed) {
            throw new IllegalStateException("OutputStream access not allowed");
        }
        return this.outputStream;
    }

    public String getRedirectedUrl() {
        return this.redirectedUrl;
    }

    public int getStatus() {
        return this.status;
    }

    public PrintWriter getWriter() throws UnsupportedEncodingException {
        if (!this.writerAccessAllowed) {
            throw new IllegalStateException("Writer access not allowed");
        }
        if (this.writer == null) {
            OutputStreamWriter targetWriter = this.characterEncoding != null ? new OutputStreamWriter((OutputStream)this.content, this.characterEncoding) : new OutputStreamWriter(this.content);
            this.writer = new ResponsePrintWriter(targetWriter);
        }
        return this.writer;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public boolean isOutputStreamAccessAllowed() {
        return this.outputStreamAccessAllowed;
    }

    public boolean isWriterAccessAllowed() {
        return this.writerAccessAllowed;
    }

    public void reset() {
        this.resetBuffer();
        this.characterEncoding = null;
        this.contentLength = 0;
        this.contentType = null;
        this.locale = null;
        this.cookies.clear();
        this.headers.clear();
        this.status = 200;
        this.errorMessage = null;
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Cannot reset buffer - response is already committed");
        }
        this.content.reset();
    }

    public void sendError(int status) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Cannot set error status - response is already committed");
        }
        this.status = status;
        this.setCommitted(true);
    }

    public void sendError(int status, String errorMessage) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Cannot set error status - response is already committed");
        }
        this.status = status;
        this.errorMessage = errorMessage;
        this.setCommitted(true);
    }

    public void sendRedirect(String url) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Cannot send redirect - response is already committed");
        }
        ((StringAssert)Assertions.assertThat((String)url).as("Redirect URL must not be null")).isNotNull();
        this.redirectedUrl = url;
        this.setCommitted(true);
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public void setCommitted(boolean committed) {
        this.committed = committed;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public void setContentType(String contentType) {
        int charsetIndex;
        this.contentType = contentType;
        if (contentType != null && (charsetIndex = contentType.toLowerCase().indexOf(CHARSET_PREFIX)) != -1) {
            String encoding = contentType.substring(charsetIndex + CHARSET_PREFIX.length());
            this.setCharacterEncoding(encoding);
        }
    }

    public void setDateHeader(String name, long value) {
        this.setHeaderValue(name, value);
    }

    public void setForwardedUrl(String forwardedUrl) {
        this.forwardedUrl = forwardedUrl;
    }

    public void setHeader(String name, String value) {
        this.setHeaderValue(name, value);
    }

    public void setIncludedUrl(String includedUrl) {
        this.includedUrls.clear();
        if (includedUrl != null) {
            this.includedUrls.add(includedUrl);
        }
    }

    public void setIntHeader(String name, int value) {
        this.setHeaderValue(name, value);
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setOutputStreamAccessAllowed(boolean outputStreamAccessAllowed) {
        this.outputStreamAccessAllowed = outputStreamAccessAllowed;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setStatus(int status, String errorMessage) {
        this.status = status;
        this.errorMessage = errorMessage;
    }

    public void setWriterAccessAllowed(boolean writerAccessAllowed) {
        this.writerAccessAllowed = writerAccessAllowed;
    }

    private void addHeaderValue(String name, Object value) {
        this.doAddHeaderValue(name, value, false);
    }

    private void doAddHeaderValue(String name, Object value, boolean replace) {
        HeaderValueHolder header = HeaderValueHolder.getByName(this.headers, name);
        ((ObjectAssert)Assertions.assertThat((Object)value).as("Header value must not be null")).isNotNull();
        if (header == null) {
            header = new HeaderValueHolder();
            this.headers.put(name, header);
        }
        if (replace) {
            header.setValue(value);
        } else {
            header.addValue(value);
        }
    }

    private void setCommittedIfBufferSizeExceeded() {
        int bufSize = this.getBufferSize();
        if (bufSize > 0 && this.content.size() > bufSize) {
            this.setCommitted(true);
        }
    }

    private void setHeaderValue(String name, Object value) {
        this.doAddHeaderValue(name, value, true);
    }

    private class ResponseServletOutputStream
    extends DelegatingServletOutputStream {
        public ResponseServletOutputStream(OutputStream out) {
            super(out);
        }

        public void flush() throws IOException {
            super.flush();
            MockHttpServletResponse.this.setCommitted(true);
        }

        public void write(int b) throws IOException {
            super.write(b);
            super.flush();
            MockHttpServletResponse.this.setCommittedIfBufferSizeExceeded();
        }
    }

    private class ResponsePrintWriter
    extends PrintWriter {
        public ResponsePrintWriter(Writer out) {
            super(out, true);
        }

        public void flush() {
            super.flush();
            MockHttpServletResponse.this.setCommitted(true);
        }

        public void write(char[] buf, int off, int len) {
            super.write(buf, off, len);
            super.flush();
            MockHttpServletResponse.this.setCommittedIfBufferSizeExceeded();
        }

        public void write(int c) {
            super.write(c);
            super.flush();
            MockHttpServletResponse.this.setCommittedIfBufferSizeExceeded();
        }

        public void write(String s, int off, int len) {
            super.write(s, off, len);
            super.flush();
            MockHttpServletResponse.this.setCommittedIfBufferSizeExceeded();
        }
    }
}

