/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.utils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.web.bindery.event.shared.UmbrellaException;
import com.googlecode.gwt.test.exceptions.GwtTestException;
import com.googlecode.gwt.test.exceptions.ReflectionException;
import com.googlecode.gwt.test.internal.utils.DoubleMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GwtReflectionUtils {
    private static final String ASSERTIONS_FIELD_NAME = "$assertionsDisabled";
    private static DoubleMap<Class<?>, Class<?>, Map<Field, ?>> cacheAnnotatedField = new DoubleMap();
    private static DoubleMap<Class<?>, Class<?>, Map<Method, ?>> cacheAnnotatedMethod = new DoubleMap();
    private static DoubleMap<Class<?>, Class<?>, Object> cacheAnnotation = new DoubleMap();
    private static Map<Class<?>, Set<Field>> cacheField = new HashMap();
    private static DoubleMap<Class<?>, String, Method> cacheMethod = new DoubleMap();
    private static DoubleMap<Class<?>, String, Field> cacheUniqueField = new DoubleMap();

    public static <T> T callPrivateMethod(JavaScriptObject target, String methodName, String overlayOriginalType, Object ... args) {
        if (overlayOriginalType == null) {
            throw new IllegalArgumentException("The specified overlay type should not be null");
        }
        if ((overlayOriginalType = overlayOriginalType.trim()).equals("")) {
            throw new IllegalArgumentException("The specified overlay type should not be blank");
        }
        if (overlayOriginalType.endsWith("$")) {
            throw new IllegalArgumentException("The specified overlay type should not be a rewritten type : " + overlayOriginalType);
        }
        Class<?> rewrittenOverlayType = null;
        try {
            rewrittenOverlayType = Class.forName(overlayOriginalType + "$");
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException("Error while calling overlay rewritten method " + overlayOriginalType + "$." + methodName + "$(..) :", e);
        }
        Object[] newArgs = new Object[args.length + 1];
        newArgs[0] = target;
        System.arraycopy(args, 0, newArgs, 1, args.length);
        return GwtReflectionUtils.callStaticMethod(rewrittenOverlayType, methodName + "$", newArgs);
    }

    public static <T> T callPrivateMethod(Object target, Method method, Object ... args) {
        try {
            method.setAccessible(true);
            Object res = method.invoke(target, args);
            return (T)res;
        }
        catch (InvocationTargetException e) {
            if (GwtTestException.class.isInstance(e.getCause())) {
                throw (GwtTestException)e.getCause();
            }
            if (AssertionError.class.isInstance(e.getCause())) {
                throw (AssertionError)((Object)e.getCause());
            }
            if (UmbrellaException.class.isInstance(e.getCause())) {
                throw new ReflectionException("Error while calling method '" + method.toString() + "'", e.getCause().getCause());
            }
            throw new ReflectionException("Error while calling method '" + method.toString() + "'", e.getCause());
        }
        catch (Exception e) {
            throw new ReflectionException("Unable to call method '" + target.getClass().getSimpleName() + "." + method.getName() + "(..)'", e);
        }
    }

    public static <T> T callPrivateMethod(Object target, String methodName, Object ... args) {
        if (target instanceof JavaScriptObject) {
            throw new UnsupportedOperationException("Cannot call instance method on Overlay types without specifying its base type");
        }
        Method method = GwtReflectionUtils.findMethod(target.getClass(), methodName, args);
        if (method == null) {
            throw new ReflectionException("Cannot find method '" + target.getClass().getName() + "." + methodName + "(..)'");
        }
        return GwtReflectionUtils.callPrivateMethod(target, method, args);
    }

    public static <T> T callStaticMethod(Class<?> clazz, String methodName, Object ... args) {
        Method m = GwtReflectionUtils.findMethod(clazz, methodName, args);
        if (m == null) {
            throw new ReflectionException("Cannot find method '" + clazz.getName() + "." + methodName + "(..)'");
        }
        try {
            m.setAccessible(true);
            Object res = m.invoke(null, args);
            return (T)res;
        }
        catch (Exception e) {
            throw new ReflectionException("Unable to call static method '" + m.toString() + "'", e);
        }
    }

    public static void doWithFields(Class<?> clazz, FieldCallback fc) throws IllegalArgumentException {
        GwtReflectionUtils.doWithFields(clazz, fc, null);
    }

    public static void doWithFields(Class<?> clazz, FieldCallback fc, FieldFilter ff) throws IllegalArgumentException {
        Class<?> targetClass = clazz;
        do {
            Field[] fields;
            for (Field field : fields = targetClass.getDeclaredFields()) {
                if (ff != null && !ff.matches(field)) continue;
                try {
                    fc.doWith(field);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Shouldn't be illegal to access field '" + field.getName() + "': " + ex);
                }
            }
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
    }

    public static void doWithMethods(Class<?> clazz, MethodCallback mc) throws IllegalArgumentException {
        GwtReflectionUtils.doWithMethods(clazz, mc, null);
    }

    public static void doWithMethods(Class<?> clazz, MethodCallback mc, MethodFilter mf) throws IllegalArgumentException {
        Method[] methods = clazz.getDeclaredMethods();
        for (Method method : methods) {
            if (mf != null && !mf.matches(method)) continue;
            try {
                mc.doWith(method);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Shouldn't be illegal to access method '" + method.getName() + "': " + ex);
            }
        }
        if (clazz.getSuperclass() != null) {
            GwtReflectionUtils.doWithMethods(clazz.getSuperclass(), mc, mf);
        } else if (clazz.isInterface()) {
            for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
                GwtReflectionUtils.doWithMethods(genericDeclaration, mc, mf);
            }
        }
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        for (Class<?> searchType = clazz; !Object.class.equals(searchType) && searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods = searchType.isInterface() ? searchType.getMethods() : searchType.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!name.equals(method.getName()) || paramTypes.length != method.getParameterTypes().length) continue;
                boolean compatibleParams = true;
                for (int j = 0; j < paramTypes.length; ++j) {
                    Class<?> searchParamType;
                    Class<?> methodParamType;
                    if (paramTypes[j] == null || (methodParamType = GwtReflectionUtils.getCheckedClass(method.getParameterTypes()[j])).isAssignableFrom(searchParamType = GwtReflectionUtils.getCheckedClass(paramTypes[j]))) continue;
                    compatibleParams = false;
                }
                if (!compatibleParams) continue;
                return method;
            }
        }
        return null;
    }

    public static Method[] getAllDeclaredMethods(Class<?> leafClass) throws IllegalArgumentException {
        final ArrayList methods = new ArrayList(32);
        GwtReflectionUtils.doWithMethods(leafClass, new MethodCallback(){

            public void doWith(Method method) {
                methods.add(method);
            }
        });
        return methods.toArray(new Method[methods.size()]);
    }

    public static <T extends Annotation> Map<Field, T> getAnnotatedField(Class<?> clazz, Class<T> annotationClass) {
        Map<Field, ?> l = cacheAnnotatedField.get(clazz, annotationClass);
        if (l != null) {
            return l;
        }
        l = new HashMap();
        GwtReflectionUtils.recurseGetAnnotatedField(l, clazz, annotationClass);
        cacheAnnotatedField.put(clazz, annotationClass, l);
        return l;
    }

    public static <T extends Annotation> Map<Method, T> getAnnotatedMethod(Class<?> target, Class<T> annotationClass) {
        Map<Method, ?> map = cacheAnnotatedMethod.get(target, annotationClass);
        if (map != null) {
            return map;
        }
        map = new HashMap();
        GwtReflectionUtils.recurseGetAnnotatedMethod(map, target, annotationClass);
        cacheAnnotatedMethod.put(target, annotationClass, map);
        return map;
    }

    public static <T> T getAnnotation(Class<?> clazz, Class<T> annotationClass) {
        Object o = cacheAnnotation.get(clazz, annotationClass);
        if (o != null) {
            return (T)o;
        }
        Annotation result = null;
        for (Annotation a : clazz.getDeclaredAnnotations()) {
            if (a.annotationType() != annotationClass) continue;
            result = a;
        }
        if (result == null && clazz.getSuperclass() != null) {
            result = GwtReflectionUtils.getAnnotation(clazz.getSuperclass(), annotationClass);
        }
        cacheAnnotation.put(clazz, annotationClass, result);
        return (T)result;
    }

    public static Class<?> getClass(String type) throws ClassNotFoundException {
        try {
            return Class.forName(type);
        }
        catch (ClassNotFoundException e1) {
            int lastIndex = type.lastIndexOf(46);
            String innerTypeName = type.substring(0, lastIndex) + "$" + type.substring(lastIndex + 1);
            try {
                return Class.forName(innerTypeName);
            }
            catch (ClassNotFoundException e2) {
                throw e1;
            }
        }
    }

    public static Set<Field> getFields(Class<?> clazz) {
        Set<Field> set = cacheField.get(clazz);
        if (set != null) {
            return set;
        }
        set = GwtReflectionUtils.getFields(clazz, false);
        cacheField.put(clazz, set);
        return set;
    }

    public static Method getMethod(Class<?> clazz, String methodName) {
        Method res = cacheMethod.get(clazz, methodName);
        if (res != null) {
            return res;
        }
        for (Method m : clazz.getDeclaredMethods()) {
            if (!methodName.equalsIgnoreCase(m.getName())) continue;
            m.setAccessible(true);
            cacheMethod.put(clazz, methodName, m);
            return m;
        }
        for (Method m : clazz.getMethods()) {
            if (!methodName.equalsIgnoreCase(m.getName())) continue;
            m.setAccessible(true);
            cacheMethod.put(clazz, methodName, m);
            return m;
        }
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null) {
            res = GwtReflectionUtils.getMethod(superClazz, methodName);
        }
        cacheMethod.put(clazz, methodName, res);
        return res;
    }

    public static <T> T getPrivateFieldValue(Object target, Field field) {
        try {
            GwtReflectionUtils.makeAccessible(field);
            return (T)field.get(target);
        }
        catch (Exception e) {
            throw new ReflectionException("Unable to get field '" + target.getClass().getSimpleName() + "." + field.getName() + "'", e);
        }
    }

    public static <T> T getPrivateFieldValue(Object target, String fieldName) {
        Field field = GwtReflectionUtils.getUniqueFieldByName(target.getClass(), fieldName);
        return GwtReflectionUtils.getPrivateFieldValue(target, field);
    }

    public static <T> T getStaticFieldValue(Class<?> clazz, String fieldName) {
        Field field = GwtReflectionUtils.getUniqueFieldByName(clazz, fieldName);
        try {
            return (T)field.get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ReflectionException(e.getMessage() + " Unable to get static field, class " + fieldName + ", fieldClass " + clazz);
        }
    }

    public static <T> T instantiateClass(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (clazz.isInterface()) {
            throw new ReflectionException("Error during instanciation of '" + clazz.getName() + "'. Specified class is an interface");
        }
        try {
            return GwtReflectionUtils.instantiateClass(clazz.getDeclaredConstructor(new Class[0]), new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new ReflectionException("Error during instanciation of '" + clazz.getName() + "'. No default constructor found", ex);
        }
    }

    public static <T> T instantiateClass(Constructor<T> ctor, Object ... args) {
        if (ctor == null) {
            throw new IllegalArgumentException("Constructor must not be null");
        }
        try {
            GwtReflectionUtils.makeAccessible(ctor);
            return ctor.newInstance(args);
        }
        catch (InstantiationException ex) {
            throw new ReflectionException("Error during instanciation of '" + ctor.getDeclaringClass().getName() + "'. Is it an abstract class?", ex);
        }
        catch (IllegalAccessException ex) {
            throw new ReflectionException("Error during instanciation of '" + ctor.getDeclaringClass().getName() + "'. Has the class definition changed? Is the constructor accessible?", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new ReflectionException("Error during instanciation of '" + ctor.getDeclaringClass().getName() + "'. Illegal arguments for constructor", ex);
        }
        catch (InvocationTargetException ex) {
            if (GwtTestException.class.isInstance(ex.getTargetException())) {
                throw (GwtTestException)ex.getTargetException();
            }
            if (GwtTestException.class.isInstance(ex.getTargetException().getCause())) {
                throw (GwtTestException)ex.getTargetException().getCause();
            }
            throw new ReflectionException("Error during instanciation of '" + ctor.getDeclaringClass().getName() + "'. Constructor threw exception", ex.getTargetException());
        }
    }

    public static void makeAccessible(Constructor<?> ctor) {
        if (!Modifier.isPublic(ctor.getModifiers()) || !Modifier.isPublic(ctor.getDeclaringClass().getModifiers())) {
            ctor.setAccessible(true);
        }
    }

    public static void makeAccessible(Field field) {
        if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
            field.setAccessible(true);
        }
    }

    public static void makeAccessible(Method method) {
        if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            method.setAccessible(true);
        }
    }

    public static void setPrivateFieldValue(Object target, String fieldName, Object value) {
        Field field = GwtReflectionUtils.getUniqueFieldByName(target.getClass(), fieldName);
        try {
            field.set(target, value);
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    public static void setStaticField(Class<?> clazz, String fieldName, Object value) {
        Field field = GwtReflectionUtils.getUniqueFieldByName(clazz, fieldName);
        try {
            field.set(null, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ReflectionException(e);
        }
    }

    private static Method findMethod(Class<?> clazz, String methodName, Object ... args) {
        Class[] l = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            l[i] = args[i] != null ? args[i].getClass() : null;
        }
        return GwtReflectionUtils.findMethod(clazz, methodName, l);
    }

    private static Class<?> getCheckedClass(Class<?> potentialPrimitiveType) {
        if (!potentialPrimitiveType.isPrimitive()) {
            return potentialPrimitiveType;
        }
        if (potentialPrimitiveType == Byte.TYPE) {
            return Byte.class;
        }
        if (potentialPrimitiveType == Short.TYPE) {
            return Short.class;
        }
        if (potentialPrimitiveType == Integer.TYPE) {
            return Integer.class;
        }
        if (potentialPrimitiveType == Long.TYPE) {
            return Long.class;
        }
        if (potentialPrimitiveType == Float.TYPE) {
            return Float.class;
        }
        if (potentialPrimitiveType == Double.TYPE) {
            return Double.class;
        }
        if (potentialPrimitiveType == Boolean.TYPE) {
            return Boolean.class;
        }
        return Character.class;
    }

    private static Set<Field> getFields(Class<?> clazz, boolean hasAssertionField) {
        HashSet<Field> set = new HashSet<Field>();
        for (Field f : clazz.getDeclaredFields()) {
            if (ASSERTIONS_FIELD_NAME.equals(f.getName())) {
                if (hasAssertionField) continue;
                f.setAccessible(true);
                set.add(f);
                hasAssertionField = true;
                continue;
            }
            f.setAccessible(true);
            set.add(f);
        }
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null) {
            set.addAll(GwtReflectionUtils.getFields(superClazz, hasAssertionField));
        }
        return set;
    }

    private static Field getUniqueFieldByName(Class<?> clazz, String fieldName) {
        Field f = cacheUniqueField.get(clazz, fieldName);
        if (f != null) {
            return f;
        }
        Set<Field> fieldSet = GwtReflectionUtils.getFields(clazz);
        HashSet<Field> result = new HashSet<Field>();
        for (Field field : fieldSet) {
            if (!field.getName().equals(fieldName)) continue;
            result.add(field);
        }
        if (result.size() == 0) {
            throw new ReflectionException("Unable to find field, class '" + clazz + "', fieldName '" + fieldName + "'");
        }
        if (result.size() > 1) {
            throw new ReflectionException("Unable to choose field, '" + clazz + "', fieldName '" + fieldName + "'");
        }
        Field field = (Field)result.iterator().next();
        cacheUniqueField.put(clazz, fieldName, field);
        return field;
    }

    private static <T extends Annotation> void recurseGetAnnotatedField(Map<Field, T> map, Class<?> target, Class<?> annotationClass) {
        for (Field f : target.getDeclaredFields()) {
            for (Annotation a : f.getDeclaredAnnotations()) {
                if (a.annotationType() != annotationClass) continue;
                map.put(f, a);
            }
        }
        if (target.getSuperclass() != null) {
            GwtReflectionUtils.recurseGetAnnotatedField(map, target.getSuperclass(), annotationClass);
        }
    }

    private static <T extends Annotation> void recurseGetAnnotatedMethod(Map<Method, T> map, Class<?> target, Class<?> annotationClass) {
        for (Method m : target.getDeclaredMethods()) {
            for (Annotation a : m.getDeclaredAnnotations()) {
                if (a.annotationType() != annotationClass) continue;
                map.put(m, a);
            }
        }
        if (target.getSuperclass() != null) {
            GwtReflectionUtils.recurseGetAnnotatedMethod(map, target.getSuperclass(), annotationClass);
        }
    }

    private GwtReflectionUtils() {
    }

    public static interface MethodFilter {
        public boolean matches(Method var1);
    }

    public static interface MethodCallback {
        public void doWith(Method var1) throws IllegalArgumentException, IllegalAccessException;
    }

    public static interface FieldFilter {
        public boolean matches(Field var1);
    }

    public static interface FieldCallback {
        public void doWith(Field var1) throws IllegalArgumentException, IllegalAccessException;
    }
}

