/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.uibinder;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Text;
import com.google.gwt.uibinder.client.UiChild;
import com.google.gwt.user.client.ui.HasHTML;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.UIObject;
import com.googlecode.gwt.test.exceptions.GwtTestUiBinderException;
import com.googlecode.gwt.test.exceptions.ReflectionException;
import com.googlecode.gwt.test.internal.utils.JsoUtils;
import com.googlecode.gwt.test.uibinder.UiBinderBeanUtils;
import com.googlecode.gwt.test.uibinder.UiBinderInstanciator;
import com.googlecode.gwt.test.uibinder.UiBinderXmlUtils;
import com.googlecode.gwt.test.uibinder.UiObjectTagFactory;
import com.googlecode.gwt.test.uibinder.UiTag;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import com.googlecode.gwt.test.utils.JavaScriptObjects;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UiObjectTag<T>
implements UiTag<T> {
    private UiTag<?> parentTag;
    private Map<String, UiChildMethodHolder> uiChildMethodMap;
    private T wrapped;

    @Override
    public final void addElement(Element element) {
        String namespaceURI = JavaScriptObjects.getString((JavaScriptObject)element, "UIBINDER_XML_NAMESPACE");
        this.appendElement(this.wrapped, element, namespaceURI, UiBinderXmlUtils.getChildWidgets(element));
    }

    @Override
    public final void addUiObject(UIObject uiObject) {
        this.addUIObject(this.wrapped, uiObject);
    }

    @Override
    public final void addWidget(IsWidget isWidget) {
        this.addWidget(this.wrapped, isWidget);
    }

    @Override
    public final void appendText(String data) {
        if (!"".equals(data.trim())) {
            this.appendText(this.wrapped, data);
        }
    }

    @Override
    public final T endTag() {
        this.finalizeObject(this.wrapped);
        return this.wrapped;
    }

    @Override
    public final UiTag<?> getParentTag() {
        return this.parentTag;
    }

    protected void addUIObject(T wrapped, UIObject uiObject) {
    }

    protected void addWidget(T wrapped, IsWidget isWidget) {
        if (HasWidgets.ForIsWidget.class.isInstance(wrapped)) {
            ((HasWidgets.ForIsWidget)wrapped).add(isWidget);
        } else if (HasWidgets.class.isInstance(wrapped)) {
            ((HasWidgets)wrapped).add(isWidget.asWidget());
        }
    }

    protected void appendElement(T wrapped, Element element, String namespaceURI, List<IsWidget> childWidgets) {
        UiChildMethodHolder uiChildMethodHolder = this.uiChildMethodMap.get(element.getTagName());
        if (uiChildMethodHolder != null) {
            this.invokeUiChildMethod(wrapped, childWidgets, uiChildMethodHolder);
        } else if (HasHTML.class.isInstance(wrapped)) {
            this.getElement(wrapped).appendChild((Node)element);
        } else {
            String elementToString = namespaceURI != null && namespaceURI.length() > 0 ? namespaceURI + ":" + element.getTagName() : element.getTagName();
            throw new GwtTestUiBinderException("Found unexpected child element : <" + elementToString + "> in " + wrapped.getClass().getName());
        }
    }

    protected void appendText(T wrapped, String data) {
        if (HasText.class.isInstance(wrapped)) {
            ((HasText)wrapped).setText(data);
        } else {
            Element element = this.getElement(wrapped);
            Text text = JsoUtils.newText(data, element.getOwnerDocument());
            element.appendChild((Node)text);
        }
    }

    protected abstract void finalizeObject(T var1);

    protected Element getElement(T wrapped) {
        if (wrapped instanceof UIObject) {
            return ((UIObject)wrapped).getElement();
        }
        if (wrapped instanceof IsWidget) {
            return ((IsWidget)wrapped).asWidget().getElement();
        }
        throw new GwtTestUiBinderException("Cannot retrieve the Element instance in instances of '" + wrapped.getClass().getName() + "', you have to override " + this.getClass() + ".getElement(..) protected method");
    }

    protected abstract void initializeObject(T var1, Map<String, Object> var2, Object var3);

    protected T instanciate(Class<? extends T> clazz, Map<String, Object> attributes, Object owner) {
        try {
            Constructor<? extends T> defaultCons = clazz.getDeclaredConstructor(new Class[0]);
            return GwtReflectionUtils.instantiateClass(defaultCons, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new GwtTestUiBinderException(clazz.getName() + " has no default (zero args) constructor. You have to register a custom " + UiObjectTagFactory.class.getSimpleName() + " by calling the protected method 'addUiObjectTagFactory' of your test class and override the 'instanciate(Class<T>) method in it");
        }
    }

    final void startTag(Class<? extends T> clazz, Map<String, Object> attributes, UiTag<?> parentTag, Object owner) {
        String uiFieldValue;
        this.parentTag = parentTag;
        this.uiChildMethodMap = this.collectUiChildMethods(clazz);
        this.wrapped = UiBinderInstanciator.getInstance(clazz, attributes, owner);
        if (this.wrapped == null) {
            this.wrapped = this.instanciate(clazz, attributes, owner);
        }
        if ((uiFieldValue = (String)attributes.get("ui:field")) != null) {
            attributes.remove("ui:field");
            try {
                GwtReflectionUtils.setPrivateFieldValue(owner, uiFieldValue, this.wrapped);
            }
            catch (ReflectionException e) {
                // empty catch block
            }
        }
        this.initializeObject(this.wrapped, attributes, owner);
        UiBinderBeanUtils.populateObject(this.wrapped, attributes);
    }

    private Map<String, UiChildMethodHolder> collectUiChildMethods(Class<? extends T> clazz) {
        HashMap<String, UiChildMethodHolder> map = new HashMap<String, UiChildMethodHolder>();
        Map<Method, UiChild> uiChildMap = GwtReflectionUtils.getAnnotatedMethod(clazz, UiChild.class);
        for (Map.Entry<Method, UiChild> entry : uiChildMap.entrySet()) {
            Method method = entry.getKey();
            UiChild annotation = entry.getValue();
            UiChildMethodHolder holder = new UiChildMethodHolder();
            holder.uiChildMethod = method;
            holder.invocationLimit = annotation.limit();
            holder.invocationCount = 0;
            String tagName = annotation.tagname().equals("") ? this.computeUiChildMethodTagName(method) : annotation.tagname();
            map.put(tagName, holder);
        }
        return map;
    }

    private String computeUiChildMethodTagName(Method method) {
        if (!method.getName().startsWith("add")) {
            throw new GwtTestUiBinderException("Cannot compute tagname of @UiChild annotated method '" + method.toGenericString() + "': you have to fill the 'tagname' property of the @UiChild or to prefix your the method name with 'add'");
        }
        return method.getName().substring(3).toLowerCase();
    }

    private void invokeUiChildMethod(T wrapped, List<IsWidget> childWidgets, UiChildMethodHolder uiChildMethodHolder) {
        if (uiChildMethodHolder.invocationLimit > -1 && uiChildMethodHolder.invocationCount > uiChildMethodHolder.invocationLimit) {
            throw new GwtTestUiBinderException("@UiChild method '" + uiChildMethodHolder.uiChildMethod.toGenericString() + "' cannot be invoked more than " + uiChildMethodHolder.invocationLimit + " times");
        }
        if (childWidgets.size() != 1) {
            throw new GwtTestUiBinderException("@UiChild method '" + uiChildMethodHolder.uiChildMethod.toGenericString() + "' can only be applied to add one Widget, but " + childWidgets.size() + " have been found");
        }
        try {
            uiChildMethodHolder.uiChildMethod.invoke(wrapped, childWidgets.get(0));
        }
        catch (Exception e) {
            throw new GwtTestUiBinderException("An exception has been thrown during invocation of @UiChild method: " + uiChildMethodHolder.uiChildMethod.toGenericString(), e);
        }
        ++uiChildMethodHolder.invocationCount;
    }

    private static class UiChildMethodHolder {
        int invocationCount;
        int invocationLimit;
        Method uiChildMethod;

        private UiChildMethodHolder() {
        }
    }
}

